/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.MaskSensitiveTraceDataHelper;
import com.gridnine.farelogix.ndc.AirShoppingRQ;
import com.gridnine.farelogix.ndc.IATAPayloadStdAttributes;
import com.gridnine.farelogix.ndc.MsgDocumentType;
import com.gridnine.xtrip.common.gds.farelogix.model.FarelogixGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.RequestMethod;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FareLogixAbstractRequestBuilder;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.model.Transaction;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.naming.NoNameCoder;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.Xpp3Driver;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;

public class FareLogixHttpRequestBuilder
extends FareLogixAbstractRequestBuilder {
    private final XStream xstream = new XStream((HierarchicalStreamDriver)new Xpp3Driver((NameCoder)new NoNameCoder()));

    public FareLogixHttpRequestBuilder() {
        this.xstream.processAnnotations(Transaction.class);
        this.xstream.setMode(1001);
    }

    public void process(MessageContext ctx) throws Exception {
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        Object rq = ctx.getObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_REQUEST);
        this.setIATAPayloadStdAttributes(rq);
        if (TextUtil.isBlank((String)((FarelogixGdsAccount)accountCtr.getEntity()).getAddress())) {
            throw Xeption.forAdmin((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d URL", (Object[])new Object[0]);
        }
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(((FarelogixGdsAccount)accountCtr.getEntity()).getAddress());
        httpRequest.setRequestMethod(RequestMethod.POST);
        httpRequest.setUseTrustfulManager(true);
        httpRequest.setBody(this.buildBody((FarelogixGdsAccount)accountCtr.getEntity(), rq));
        MaskSensitiveTraceDataHelper.addMaskedValue((MessageContext)ctx, (String)((FarelogixGdsAccount)accountCtr.getEntity()).getPassword());
        if (((FarelogixGdsAccount)accountCtr.getEntity()).getSubscriptionKey() != null) {
            httpRequest.getRequestProperties().put((Object)"Ocp-Apim-Subscription-Key", (Object)((FarelogixGdsAccount)accountCtr.getEntity()).getSubscriptionKey());
        }
        httpRequest.getRequestProperties().put((Object)"Agency", (Object)((FarelogixGdsAccount)accountCtr.getEntity()).getSystemIdentity());
        httpRequest.getRequestProperties().put((Object)"IATA", (Object)((FarelogixGdsAccount)accountCtr.getEntity()).getAgencyCode());
        httpRequest.getRequestProperties().put((Object)"PCC", (Object)((FarelogixGdsAccount)accountCtr.getEntity()).getPcc());
        httpRequest.getRequestProperties().put((Object)"SOAPAction", (Object)rq.getClass().getSimpleName());
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)httpRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] buildBody(FarelogixGdsAccount gdsAccount, Object rq) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        sb.append("<SOAP-ENV:Header>");
        Object header = this.buildTransaction(gdsAccount);
        try (StringWriter sw = new StringWriter();
             CompactWriter cw = new CompactWriter((Writer)sw);){
            this.xstream.marshal(header, (HierarchicalStreamWriter)cw);
        }
        sb.append(sw.toString());
        sb.append("</SOAP-ENV:Header>");
        sb.append("<SOAP-ENV:Body>");
        sb.append("<ns1:XXTransaction xmlns:ns1=\"xxs\"><REQ>");
        IBindingFactory factory = BindingDirectory.getFactory(rq.getClass());
        IMarshallingContext marshaller = factory.createMarshallingContext();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            marshaller.setOutput((OutputStream)baos, "utf-8");
            marshaller.marshalDocument(rq);
            baos.flush();
            sb.append(new String(baos.toByteArray(), "utf-8"));
        }
        sb.append("</REQ></ns1:XXTransaction>");
        sb.append("</SOAP-ENV:Body>");
        sb.append("</SOAP-ENV:Envelope>");
        return sb.toString().getBytes();
    }

    private void setIATAPayloadStdAttributes(Object request) {
        if (request instanceof AirShoppingRQ) {
            AirShoppingRQ rq = (AirShoppingRQ)request;
            rq.setIATAPayloadStdAttributes(this.buildIATAPayloadStdAttributes());
            rq.setDocument(new MsgDocumentType());
        }
    }

    private IATAPayloadStdAttributes buildIATAPayloadStdAttributes() {
        IATAPayloadStdAttributes result = new IATAPayloadStdAttributes();
        result.setVersion("17.2");
        result.setTransactionIdentifier(this.getRequestTransactionId());
        return result;
    }
}

