/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.farelogix.ibus.GdsErrorTranslator;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.model.BaseFlxResponse;
import com.gridnine.xtrip.server.gds.farelogix.model.FarelogixResponse;
import com.gridnine.xtrip.server.gds.farelogix.model.XXTransactionResponse;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.xstreamws.IBusWsContextKeys;
import com.gridnine.xtrip.server.xstreamws.WsResponse;
import java.util.Iterator;

public class FareLogixWsResponseParser
extends BaseProcessor {
    private static final String RETRY_ERROR_CODE = "1660";

    public void process(MessageContext ctx) throws Exception {
        WsResponse wsResponse = (WsResponse)ctx.getMandatoryObject((Enum)IBusWsContextKeys.WS_XSTREAM_RESPONSE);
        XXTransactionResponse transactionResp = (XXTransactionResponse)wsResponse.getPayload();
        FarelogixResponse response = transactionResp.getResponse();
        Object flxResponse = null;
        if (response.getAirAvailabilityRS() != null) {
            flxResponse = response.getAirAvailabilityRS();
        } else if (response.getAirShoppingRS() != null) {
            flxResponse = response.getAirShoppingRS();
        } else if (response.getFareRulesRS() != null) {
            flxResponse = response.getFareRulesRS();
        } else if (response.getFlightPriceRS() != null) {
            flxResponse = response.getFlightPriceRS();
        } else if (response.getPnrViewRS() != null) {
            flxResponse = response.getPnrViewRS();
        } else if (response.getPnrCancelRS() != null) {
            flxResponse = response.getPnrCancelRS();
        } else if (response.getTicketIssueRS() != null) {
            flxResponse = response.getTicketIssueRS();
        } else if (response.getTicketImageRS() != null) {
            flxResponse = response.getTicketImageRS();
        } else if (response.getTicketVoidRS() != null) {
            flxResponse = response.getTicketVoidRS();
        } else if (response.getPnrSplitRS() != null) {
            flxResponse = response.getPnrSplitRS();
        } else {
            throw Xeption.forDeveloper((String)"response is null", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE, flxResponse);
        ctx.putObject((Enum)IBusWsContextKeys.WS_XSTREAM_RESPONSE, null);
        boolean needRetry = this.isNeedRetry(flxResponse);
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RETRY_INVOKE, (Object)needRetry);
        if (!needRetry) {
            this.checkErrors(flxResponse);
        }
    }

    private boolean isNeedRetry(Object flxResponse) {
        if (!(flxResponse instanceof BaseFlxResponse)) {
            return false;
        }
        BaseFlxResponse baseFlxResponse = (BaseFlxResponse)flxResponse;
        if (baseFlxResponse.getInfoGroups() == null) {
            return false;
        }
        for (BaseFlxResponse.InfoGroup infoGroup : baseFlxResponse.getInfoGroups()) {
            for (BaseFlxResponse.FlxError flxError : infoGroup.getErrors()) {
                if (!RETRY_ERROR_CODE.equals(flxError.getCode())) continue;
                return true;
            }
        }
        return false;
    }

    private void checkErrors(Object flxResponse) {
        if (flxResponse instanceof BaseFlxResponse) {
            this.checkInfoGroupErrors((BaseFlxResponse)flxResponse);
        }
    }

    private void checkInfoGroupErrors(BaseFlxResponse flxResponse) {
        if (flxResponse.getInfoGroups() == null) {
            return;
        }
        for (BaseFlxResponse.InfoGroup infoGroup : flxResponse.getInfoGroups()) {
            Iterator<BaseFlxResponse.FlxError> iterator = infoGroup.getErrors().iterator();
            if (!iterator.hasNext()) continue;
            GdsErrorTranslator translator = new GdsErrorTranslator();
            BaseFlxResponse.FlxError flxError = iterator.next();
            Xeption xeption = translator.translate(flxError);
            if (xeption != null) {
                throw xeption;
            }
            throw Xeption.forDeveloper((String)this.getText(flxError), (Object[])new Object[0]);
        }
    }

    private String getText(BaseFlxResponse.FlxError flxError) {
        return String.format("%s: %s", flxError.getCode(), TextUtil.join((String)"\n", flxError.getText()));
    }
}

