/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus;

import com.gridnine.farelogix.ndc.CurrCode;
import com.gridnine.farelogix.ndc.CurrencyAmountOptType;
import com.gridnine.farelogix.ndc.FareComponentType;
import com.gridnine.farelogix.ndc.FareDetailType;
import com.gridnine.farelogix.ndc.FarePriceDetailType;
import com.gridnine.farelogix.ndc.TaxDetailType;
import com.gridnine.xtrip.common.gds.farelogix.model.FarelogixRemarksSearchContext;
import com.gridnine.xtrip.common.gds.model.DocaAddressType;
import com.gridnine.xtrip.common.gds.model.DocaInformation;
import com.gridnine.xtrip.common.gds.model.DocoInformation;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.gds.farelogix.model.PNRCreateRQ;
import com.gridnine.xtrip.server.gds.farelogix.model.PNRViewRS;
import com.gridnine.xtrip.server.gds.farelogix.model.common.Carrier;
import com.gridnine.xtrip.server.gds.farelogix.model.common.CurrencyInfo;
import com.gridnine.xtrip.server.gds.farelogix.model.common.EmailAddressType;
import com.gridnine.xtrip.server.gds.farelogix.model.common.Equipment;
import com.gridnine.xtrip.server.gds.farelogix.model.common.FareBasisCode;
import com.gridnine.xtrip.server.gds.farelogix.model.common.FareGroup;
import com.gridnine.xtrip.server.gds.farelogix.model.common.FareGroupRS;
import com.gridnine.xtrip.server.gds.farelogix.model.common.FlightEvent;
import com.gridnine.xtrip.server.gds.farelogix.model.common.FlightPriceClass;
import com.gridnine.xtrip.server.gds.farelogix.model.common.PhoneType;
import com.gridnine.xtrip.server.gds.farelogix.model.common.PricingInfo;
import com.gridnine.xtrip.server.gds.farelogix.model.common.PrivateFares;
import com.gridnine.xtrip.server.gds.farelogix.model.common.TravelerInfo;
import com.gridnine.xtrip.server.gds.farelogix.model.common.TravelerRS;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FarelogixHelper {
    public static final DateTimeFormatter DF = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TF = DateTimeFormatter.ofPattern("HH:mm");
    private static final Logger log = LoggerFactory.getLogger(FarelogixHelper.class);
    private static final CodeTranslator translator = new CodeTranslator(new String[]{CodeSystem.FARELOGIX.name(), CodeSystem.IATA.name()});
    private static final CodeTranslator responseTranslator = new CodeTranslator(new String[]{CodeSystem.FARELOGIX.name(), CodeSystem.IATA.name(), CodeSystem.FARELOGIX_RESPONSE.name()});
    private static Map<Gender, com.gridnine.xtrip.server.gds.farelogix.model.common.Gender> genderMap = new HashMap<Gender, com.gridnine.xtrip.server.gds.farelogix.model.common.Gender>();
    private static Map<PassportType, PNRCreateRQ.DocType> passportTypeMap;
    private static Map<CommunicationType, PhoneType> phoneTypeMap;
    private static Map<CommunicationType, EmailAddressType> emailAddressTypeMap;
    private static Map<ClassOfService, String> serviceClassMap;
    private static Map<String, String> fareCodeTypesMap;
    private static String CUSTOM_PROPERTY_FARECODE_SEP;

    public static <D extends BaseDictionary> String getNativeCode(DictionaryReference<D> dictRef) {
        return translator.getNativeCode(dictRef);
    }

    public static <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code) {
        return responseTranslator.resolveNativeCode(cls, code);
    }

    public static <D extends BaseDictionary> DictionaryReference<D> getDictReference(Class<D> cls, String code) {
        DictionaryReference result = responseTranslator.resolveNativeCode(cls, code, false);
        if (result == null) {
            throw Xeption.forDeveloper((String)"can't resolve dict code {0} for {1}", (Object[])new Object[]{code, cls});
        }
        return result;
    }

    public static Date calcDateTime(LocalDate localDate, LocalTime localTime) {
        return localDate.toDateTime(localTime).toDate();
    }

    public static Date calcDateTime(LocalDate localDate, String localTimeStr) {
        LocalTime localTime = LocalTime.parse((String)localTimeStr);
        return FarelogixHelper.calcDateTime(localDate, localTime);
    }

    public static Date toSystemDateTime(String date, String time) {
        String dateTime = String.format("%sT%s", date, time);
        return ISODateTimeFormat.dateTimeParser().parseDateTime(dateTime).toLocalDateTime().toDate();
    }

    public static Date toDate(LocalDate localDate) {
        return localDate == null ? null : localDate.toDate();
    }

    public static LocalDate toLocalDate(Date date) {
        return date == null ? null : new LocalDate((Object)date);
    }

    public static LocalTime toLocalTime(Date date) {
        return date == null ? null : new LocalTime((Object)date);
    }

    public static int getTravelDuration(Date dateBegin, Date dateEnd) {
        return (int)((dateEnd.getTime() - dateBegin.getTime()) / 60000L);
    }

    public static FlightEvent buildFlightEvent(DictionaryReference<GeoLocation> locationRef, Date date) {
        FlightEvent result = new FlightEvent();
        result.setAirportCode(FarelogixHelper.getNativeCode(locationRef));
        result.setDate(FarelogixHelper.toLocalDate(date));
        result.setTime(FarelogixHelper.toLocalTime(date));
        return result;
    }

    public static Carrier buildCarrier(DictionaryReference<Airline> airline, String flightNumber) {
        Carrier result = new Carrier();
        result.setAirlineCode(FarelogixHelper.getNativeCode(airline));
        result.setFlightNumber(flightNumber);
        return result;
    }

    public static Equipment buildEquipment(DictionaryReference<Aircraft> aircraft, String name) {
        Equipment result = new Equipment();
        result.setCode(FarelogixHelper.getNativeCode(aircraft));
        result.setName(name);
        return result;
    }

    public static com.gridnine.xtrip.server.gds.farelogix.model.common.Gender convertGenderToGds(Gender value) {
        return genderMap.get(value);
    }

    public static Gender convertGenderFromGds(com.gridnine.xtrip.server.gds.farelogix.model.common.Gender gdsValue) {
        return (Gender)CollectionUtil.getKeyByValue(genderMap, (Object)((Object)gdsValue));
    }

    public static String getTravellerTitle(Gender gender, DictionaryReference<PassengerType> passengerType) {
        if (Gender.MALE.equals((Object)gender)) {
            return "MR";
        }
        boolean isAdult = !DictHelper.isChildPassengerTypeCategory(passengerType) && !DictHelper.isInfantPassengerTypeCategory(passengerType);
        return isAdult ? "MRS" : "MISS";
    }

    public static PNRCreateRQ.DocType convertPassportTypeToGds(PassportType value) {
        PNRCreateRQ.DocType docType = passportTypeMap.get(value);
        return docType == null ? PNRCreateRQ.DocType.PASSPORT : docType;
    }

    public static PhoneType convertPhoneTypeToGds(CommunicationType value) {
        return phoneTypeMap.get(value);
    }

    public static EmailAddressType convertEmailAddressTypeToGds(CommunicationType value) {
        return emailAddressTypeMap.get(value);
    }

    public static String convertServiceClassToGds(ClassOfService value) {
        return serviceClassMap.get(value);
    }

    public static ClassOfService convertServiceClassFromGds(String value) {
        return (ClassOfService)CollectionUtil.getKeyByValue(serviceClassMap, (Object)value);
    }

    public static String getFareTypeByCode(String fareCode) {
        if (TextUtil.isBlank((String)fareCode)) {
            return null;
        }
        String[] fareCodes = fareCode.split(CUSTOM_PROPERTY_FARECODE_SEP);
        if (fareCodes.length > 1) {
            return "BOTH";
        }
        return fareCodeTypesMap.get(fareCodes[0]);
    }

    public static String buildFareCode2CustomProperty(Collection<String> fareCodes) {
        if (CollectionUtil.isEmpty(fareCodes)) {
            return null;
        }
        return TextUtil.join((String)CUSTOM_PROPERTY_FARECODE_SEP, fareCodes, (boolean)true);
    }

    public static String joinFareCodes2CustomProperty(Flight fl1, Flight fl2) {
        String value1 = NamedValueHelper.getValueForName((String)"farelogix-fare-code", (Collection)fl1.getCustomProperties());
        String value2 = NamedValueHelper.getValueForName((String)"farelogix-fare-code", (Collection)fl2.getCustomProperties());
        HashSet<String> resultSet = new HashSet<String>();
        if (!TextUtil.isBlank((String)value1)) {
            resultSet.addAll(Arrays.asList(value1.split(CUSTOM_PROPERTY_FARECODE_SEP)));
        }
        if (!TextUtil.isBlank((String)value2)) {
            resultSet.addAll(Arrays.asList(value1.split(CUSTOM_PROPERTY_FARECODE_SEP)));
        }
        return FarelogixHelper.buildFareCode2CustomProperty(resultSet);
    }

    public static String buildRemarksSearchContext(String segmentKey, FareBasisCode fareBasisCode, String fareRefKey, String fareType, String source) throws Exception {
        FarelogixRemarksSearchContext ctx = new FarelogixRemarksSearchContext();
        ctx.setSegmentKey(segmentKey);
        ctx.setFareBasis(fareBasisCode.getValue());
        ctx.setPriceClassCode(fareBasisCode.getCode());
        ctx.setPriceClassName(fareBasisCode.getPriceClass());
        ctx.setFareRefKey(fareRefKey);
        ctx.setFareType(fareType);
        ctx.setSource(source);
        ctx.setUid(null);
        return XSUtil.toString((XSSerializable)ctx);
    }

    public static FarelogixRemarksSearchContext convertToRemarksSearchContext(String contextStr) throws Exception {
        FarelogixRemarksSearchContext result = new FarelogixRemarksSearchContext();
        XUtil.fromString((String)contextStr, (XSerializable)result);
        return result;
    }

    public static String getFareRefKey(FlightSegment fs) throws Exception {
        if (fs.getFareInfos().isEmpty()) {
            return null;
        }
        FareInfo fareInfo = (FareInfo)fs.getFareInfos().get(0);
        FarelogixRemarksSearchContext ctx = FarelogixHelper.convertToRemarksSearchContext(fareInfo.getRemarksSearchContext());
        return ctx.getFareRefKey();
    }

    public static FlightPriceClass buildPriceClass(FlightSegment fs) {
        String priceClassCode = NamedValueHelper.getValueForName((String)"farelogix-fareDetail-priceClass-code", (Collection)fs.getCustomProperties());
        String priceClassName = NamedValueHelper.getValueForName((String)"farelogix-fareDetail-priceClass-name", (Collection)fs.getCustomProperties());
        if (TextUtil.isBlank((String)priceClassCode) && TextUtil.isBlank((String)priceClassName)) {
            return null;
        }
        FlightPriceClass result = new FlightPriceClass();
        result.setCode(priceClassCode);
        result.setName(priceClassName);
        return result;
    }

    public static PricingInfo.Restrictions buildStandardRestrictions() {
        PricingInfo.Restrictions result = new PricingInfo.Restrictions();
        result.setMinimumStay(true);
        result.setMaximumStay(true);
        result.setAdvance(true);
        result.setPenalty(true);
        return result;
    }

    public static PrivateFares buildStandardPrivateFares(String pcc) {
        PrivateFares result = new PrivateFares();
        result.setOffice(new PrivateFares.Office());
        result.getOffice().setProvider("F1");
        result.getOffice().setValue(pcc);
        return result;
    }

    public static TravelerRS findGdsTraveller(Traveller traveller, boolean isInfant, List<TravelerRS> travelers) {
        for (TravelerRS tr : travelers) {
            if (!(isInfant ? FarelogixHelper.isSameTraveller(traveller, tr.getInfant()) : FarelogixHelper.isSameTraveller(traveller, tr.getTravelerName()))) continue;
            return tr;
        }
        return null;
    }

    public static boolean isSameTraveller(Traveller traveller, TravelerInfo gdsTraveler) {
        if (gdsTraveler == null) {
            return false;
        }
        Passport passport = traveller.getPassport();
        if (!MiscUtil.equals((Object)FarelogixHelper.toLocalDate(passport.getBirthday()), (Object)gdsTraveler.getDateOfBirth())) {
            return false;
        }
        if (!MiscUtil.equals((Object)passport.getLastName().toUpperCase(), (Object)gdsTraveler.getSurname())) {
            return false;
        }
        return MiscUtil.equals((Object)passport.getFirstName().toUpperCase(), (Object)gdsTraveler.getGivenName());
    }

    public static String buildProductSegmentKey(Segment segment) {
        return segment.getGdsId();
    }

    public static String buildProductSegmentKeyOld(Product product, Segment segment) {
        return String.format("%s:%s", product.getGdsId(), segment.getGdsId());
    }

    public static void updateProduct(Product product, PNRViewRS.TravelerGroupRS tg, CurrencyInfo currencyInfo, String fareType, String source) throws Exception {
        product.setFareCalculationData(tg.getFareRules().getFareCalculation());
        product.setEndorsement(FarelogixHelper.calcEndorsement(tg.getFareRules()));
        product.getFares().clear();
        product.getTaxes().clear();
        product.getFares().add(FarelogixHelper.createProductFare(tg.getPrice(), currencyInfo));
        product.getTaxes().addAll(FarelogixHelper.buildTaxes(tg.getPrice(), currencyInfo));
        for (Segment seg : AirProductHelper.getSegments((Collection)product.getSegmentTariffs())) {
            MiscUtil.Pair<FareGroup.FareInfo, FareGroup.RelatedSegment> pair = FarelogixHelper.getFareInfoAndSegment(tg.getFareRules(), seg.getGdsId());
            if (pair == null) {
                throw Xeption.forDeveloper((String)"can't find segment for ref={0}", (Object[])new Object[]{seg.getGdsId()});
            }
            FareGroup.FareInfo gdsFi = (FareGroup.FareInfo)pair.getFirst();
            FareGroup.RelatedSegment gdsSeg = (FareGroup.RelatedSegment)pair.getSecond();
            seg.setFareBasis(gdsFi.getFareBasisCode().getValue());
            seg.setRemarksSearchContext(FarelogixHelper.buildRemarksSearchContext(FarelogixHelper.buildProductSegmentKey(seg), gdsFi.getFareBasisCode(), gdsFi.getFareRefKey(), fareType, source));
            seg.setLuggageInfo(AirProductHelper.parseLuggageInfo((String)gdsSeg.getBaggageAllowance()));
            seg.setNotValidBefore(FarelogixHelper.toDate(gdsSeg.getNvb()));
            seg.setNotValidAfter(FarelogixHelper.toDate(gdsSeg.getNva()));
        }
    }

    private static String calcEndorsement(FareGroup.FareRules fareRules) {
        return TextUtil.join((String)"/", fareRules.getEndorsements());
    }

    private static ProductFare createProductFare(FareGroup.Price price, CurrencyInfo currencyInfo) {
        ProductFare fare = new ProductFare();
        fare.setEquivalentFare(FarelogixHelper.applyNumberOfDecimals(price.getBaseFare().getAmount(), currencyInfo));
        fare.setBaseFare(MoneyHelper.buildMoney((BigDecimal)FarelogixHelper.applyNumberOfDecimals(fare.getEquivalentFare(), currencyInfo), (String)currencyInfo.getCurrencyCode()));
        return fare;
    }

    private static List<Tax> buildTaxes(FareGroup.Price price, CurrencyInfo currencyInfo) {
        ArrayList<Tax> result = new ArrayList<Tax>();
        for (FareGroup.Tax gdsTax : price.getTaxes().getTaxes()) {
            Tax tax = new Tax();
            tax.setCode(gdsTax.getDesignator());
            tax.setEquivalentAmount(FarelogixHelper.applyNumberOfDecimals(gdsTax.getAmount(), currencyInfo));
            tax.setAmount(MoneyHelper.buildMoney((BigDecimal)tax.getEquivalentAmount(), (String)currencyInfo.getCurrencyCode()));
            result.add(tax);
        }
        return result;
    }

    private static MiscUtil.Pair<FareGroup.FareInfo, FareGroup.RelatedSegment> getFareInfoAndSegment(FareGroup.FareRules fareRules, String segElNumber) {
        for (FareGroup.FareInfo fi : fareRules.getFareInfos()) {
            for (FareGroup.RelatedSegment relatedSegment : fi.getRelatedSegments()) {
                if (!segElNumber.equals(relatedSegment.getSegmentIDRef())) continue;
                return MiscUtil.Pair.of((Object)fi, (Object)relatedSegment);
            }
        }
        return null;
    }

    public static MiscUtil.Pair<FareGroupRS, PNRViewRS.TravelerGroupRS> findTravelerGroup(String gdsId, PNRViewRS response) {
        for (FareGroupRS fg : response.getFareGroups()) {
            for (PNRViewRS.TravelerGroupRS tg : fg.getTravelerGroups()) {
                if (!tg.getTravelerElementNumbers().contains(gdsId)) continue;
                return MiscUtil.Pair.of((Object)fg, (Object)tg);
            }
        }
        return null;
    }

    public static PNRCreateRQ.AddressType convertDocaAddressType(DocaAddressType type) {
        switch (type) {
            case DESTINATION: {
                return PNRCreateRQ.AddressType.DESTINATION_ADDRESS;
            }
            case RESIDENCE: {
                return PNRCreateRQ.AddressType.RESIDENCE_ADDRESS;
            }
        }
        throw Xeption.forDeveloper((String)"unexpected doca address type", (Object[])new Object[]{type});
    }

    public static List<PNRCreateRQ.Apis> buildDocoDocaApis(Traveller traveller, String travelerIDRef, boolean isInfant) {
        ArrayList<PNRCreateRQ.Apis> result = new ArrayList<PNRCreateRQ.Apis>();
        traveller.getDocoInformations().forEach(doco -> {
            PNRCreateRQ.Apis docoApis = new PNRCreateRQ.Apis();
            docoApis.setTravelerIDRef(travelerIDRef);
            docoApis.setVisa(FarelogixHelper.buildVisa(doco, isInfant));
            result.add(docoApis);
        });
        traveller.getDocaInformations().forEach(doca -> {
            PNRCreateRQ.Apis docoApis = new PNRCreateRQ.Apis();
            docoApis.setTravelerIDRef(travelerIDRef);
            docoApis.setStayingAt(FarelogixHelper.buildStayingAt(doca, isInfant));
            result.add(docoApis);
        });
        return result;
    }

    private static PNRCreateRQ.Visa buildVisa(DocoInformation doco, boolean isInfant) {
        PNRCreateRQ.Visa result = new PNRCreateRQ.Visa();
        result.setDocType(PNRCreateRQ.VisaDocType.VISA);
        result.setDocNumber(doco.getVisaNumber());
        result.setPlaceOfBirth(FarelogixHelper.getPlaceOfBirth(doco));
        result.setPlaceOfIssue(doco.getVisaIssuePlace());
        result.setIssueDate(FarelogixHelper.toLocalDate(doco.getVisaIssueDate()));
        if (doco.getVisaApplicableCountry() != null) {
            result.setIssuedForCountry(FarelogixHelper.getNativeCode(doco.getVisaApplicableCountry()));
        }
        result.setInfantOnLap(isInfant);
        return result;
    }

    private static String getPlaceOfBirth(DocoInformation doco) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(doco.getPlaceOfBirthCity());
        parts.add(doco.getPlaceOfBirthState());
        if (doco.getPlaceOfBirthCountry() != null) {
            parts.add(FarelogixHelper.getNativeCode(doco.getPlaceOfBirthCountry()));
        }
        return TextUtil.join((String)" ", parts, (boolean)true);
    }

    public static Map<String, Integer> findMyNumberOfDecimalsMap(FareDetailType fareDetail) {
        List breakdowns = Optional.ofNullable(fareDetail).map(FareDetailType::getFareComponentList).map(e -> e.stream().filter(Objects::nonNull).map(FareComponentType::getPrice).filter(Objects::nonNull).map(FarePriceDetailType::getTaxes).filter(Objects::nonNull).map(TaxDetailType::getBreakdown).filter(Objects::nonNull).collect(Collectors.toList())).orElse(new ArrayList());
        Optional.ofNullable(fareDetail).map(FareDetailType::getPrice).map(FarePriceDetailType::getTaxes).map(TaxDetailType::getBreakdown).ifPresent(breakdowns::add);
        return FarelogixHelper.buildNumberOfDecimals(breakdowns);
    }

    public static Map<String, Integer> buildNumberOfDecimals(List<TaxDetailType.Breakdown> breakdowns) {
        List currCodeList = breakdowns.stream().map(TaxDetailType.Breakdown::getTaxList).filter(Objects::nonNull).flatMap(e -> e.stream().map(TaxDetailType.Breakdown.Tax::getCollectionPointList).filter(Objects::nonNull).flatMap(Collection::stream).map(TaxDetailType.Breakdown.Tax.CollectionPoint::getCurrCode).filter(Objects::nonNull).filter(cc -> TextUtil.nonBlank((String)cc.getString()) && cc.getNumberOfDecimals() != null && cc.getNumberOfDecimals() > 0).collect(Collectors.toList()).stream()).collect(Collectors.toList());
        return currCodeList.stream().collect(Collectors.toMap(CurrCode::getString, CurrCode::getNumberOfDecimals, (k, v) -> v));
    }

    public static BigDecimal applyNumberOfDecimals(CurrencyAmountOptType currencyAmount, Map<String, Integer> numberOfDecimalsMap) {
        return FarelogixHelper.applyNumberOfDecimals(currencyAmount.getDecimal(), currencyAmount.getCode(), numberOfDecimalsMap);
    }

    public static BigDecimal applyNumberOfDecimals(BigDecimal amount, String code, Map<String, Integer> numberOfDecimalsMap) {
        Integer number;
        if (TextUtil.nonBlank((String)code) && amount != null && !numberOfDecimalsMap.isEmpty() && (number = numberOfDecimalsMap.get(code)) != null) {
            return FarelogixHelper.calculationAmount(amount, number);
        }
        return amount;
    }

    public static BigDecimal applyNumberOfDecimals(BigDecimal amount, CurrencyInfo currencyInfo) {
        if (currencyInfo.getNumberOfDecimals() != null && currencyInfo.getNumberOfDecimals() > 0) {
            return FarelogixHelper.calculationAmount(amount, currencyInfo.getNumberOfDecimals());
        }
        return amount;
    }

    private static BigDecimal calculationAmount(BigDecimal amount, Integer numberOfDecimals) {
        return amount.divide(BigDecimal.valueOf((int)Math.pow(10.0, numberOfDecimals.intValue())), (int)numberOfDecimals, RoundingMode.HALF_UP);
    }

    private static PNRCreateRQ.StayingAt buildStayingAt(DocaInformation doca, boolean isInfant) {
        PNRCreateRQ.StayingAt result = new PNRCreateRQ.StayingAt();
        result.setAddressType(FarelogixHelper.convertDocaAddressType(doca.getType()));
        result.set\u0421ountryCode(FarelogixHelper.getNativeCode(doca.getCountry()));
        result.setCity(doca.getCity());
        result.setStateCode(doca.getStateProvince());
        result.setPostalCode(doca.getZipPostalCode());
        result.setAddress(doca.getStreet());
        result.setInfantOnLap(isInfant);
        return result;
    }

    public static String getRecordLocator(Reservation reservation) {
        return ReservationGdsNameInfoHelper.getOnlineRecordLocator((Reservation)reservation, (RecordLocatorType)RecordLocatorType.DEFAULT);
    }

    static {
        genderMap.put(Gender.MALE, com.gridnine.xtrip.server.gds.farelogix.model.common.Gender.MALE);
        genderMap.put(Gender.FEMALE, com.gridnine.xtrip.server.gds.farelogix.model.common.Gender.FEMALE);
        passportTypeMap = new HashMap<PassportType, PNRCreateRQ.DocType>();
        passportTypeMap.put(PassportType.ALIENRESIDENTCARD, PNRCreateRQ.DocType.ALIEN_RESIDENT_CARD);
        passportTypeMap.put(PassportType.PERMANENTRESIDENTCARD, PNRCreateRQ.DocType.PERMANENT_RESIDENT_CARD);
        passportTypeMap.put(PassportType.TRAVELDOCUMENT, PNRCreateRQ.DocType.TRAVEL_DOCUMENT);
        passportTypeMap.put(PassportType.FACILITATIONDOCUMENT, PNRCreateRQ.DocType.FACILITATION_DOCUMENT);
        passportTypeMap.put(PassportType.MILITARYID, PNRCreateRQ.DocType.MILITARY);
        passportTypeMap.put(PassportType.NATURALIZATIONCERTIFICATE, PNRCreateRQ.DocType.NATURALIZATION_CERTIFICATE);
        passportTypeMap.put(PassportType.BORDERCROSSINGCARD, PNRCreateRQ.DocType.BORDER_CROSSING_CARD);
        phoneTypeMap = new HashMap<CommunicationType, PhoneType>();
        phoneTypeMap.put(CommunicationType.MOBILE, PhoneType.MOBILE);
        phoneTypeMap.put(CommunicationType.HOME_PHONE, PhoneType.HOME);
        phoneTypeMap.put(CommunicationType.WORK_PHONE, PhoneType.BUSINESS);
        phoneTypeMap.put(CommunicationType.AGENCY, PhoneType.AGENCY);
        phoneTypeMap.put(CommunicationType.FAX, PhoneType.FAX);
        emailAddressTypeMap = new HashMap<CommunicationType, EmailAddressType>();
        emailAddressTypeMap.put(CommunicationType.EMAIL, EmailAddressType.OTHER);
        serviceClassMap = new HashMap<ClassOfService, String>();
        serviceClassMap.put(ClassOfService.ECONOMY, "Y");
        serviceClassMap.put(ClassOfService.BUSINESS, "C");
        serviceClassMap.put(ClassOfService.PREMIUM, "W");
        serviceClassMap.put(ClassOfService.FIRST, "F");
        fareCodeTypesMap = new HashMap<String, String>();
        fareCodeTypesMap.put("70E", "A35F");
        fareCodeTypesMap.put("70F", "CA35");
        fareCodeTypesMap.put("70H", "CDDF");
        fareCodeTypesMap.put("70J", "PUBL");
        fareCodeTypesMap.put("70K", "DDFR");
        fareCodeTypesMap.put("70L", "A15F");
        fareCodeTypesMap.put("70M", "CA15");
        fareCodeTypesMap.put("749", "NEGO");
        CUSTOM_PROPERTY_FARECODE_SEP = ",";
    }
}

