/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.test.TestBase;
import com.gridnine.xtrip.server.gds.farelogix.ibus.GdsErrorTranslator;
import com.gridnine.xtrip.server.gds.farelogix.model.BaseFlxResponse;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class GdsErrorTranslatorTest
extends TestBase {
    public void setUp() {
        this.publishLocaleManager();
        Class<?> cls = ((Object)((Object)this)).getClass();
        URL resource = cls.getClassLoader().getResource("com/gridnine/xtrip/server/gds/farelogix/ibus/l10n/");
        LocaleManager.get().getL10nResourceManager().registerResource(resource);
    }

    @Test
    public void parseGdsErrors() {
        this.setUp();
        BaseFlxResponse.FlxError flxError = new BaseFlxResponse.FlxError();
        flxError.setCode("421");
        this.translateLogic("Airline does not confirm seats at the selected fare. Try again in a few minutes and/or change search parameters", flxError);
        flxError.setCode("9999");
        this.translateLogic("Lost connection to the booking system. If you tried to issue a ticket or cancel the order, contact the call center to check the booking status", flxError);
        flxError.setCode("140011072");
        this.translateLogic("The airline does not confirm seats for the selected fare. If you tried to issue a ticket or cancel the order, contact the call center to check the booking status.", flxError);
    }

    private void translateLogic(String endUserTranslation, BaseFlxResponse.FlxError flxError) {
        Xeption xeption = new GdsErrorTranslator().translate(flxError);
        Assert.assertThat((Object)xeption.getEndUserMessage().toString(), (Matcher)CoreMatchers.is((Object)endUserTranslation));
    }
}

