/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.farelogix.model.FarelogixGdsAccount;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FarelogixHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.model.PNRCreateRQ;
import com.gridnine.xtrip.server.gds.farelogix.model.common.EmailAddressType;
import com.gridnine.xtrip.server.gds.farelogix.model.common.PhoneType;
import com.gridnine.xtrip.server.gds.farelogix.model.common.PricingInfo;
import com.gridnine.xtrip.server.gds.farelogix.model.common.TravelerInfo;
import com.gridnine.xtrip.server.gds.farelogix.model.common.TravelerName;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FarelogixCreateReservationRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        Customer customer = (Customer)ctx.getObject((Enum)IBusMidofficeContextKeys.CUSTOMER);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_REQUEST, (Object)this.buildRequest(parameters, travellers, customer, (FarelogixGdsAccount)accountCtr.getEntity()));
    }

    private PNRCreateRQ buildRequest(GdsReservationCreationParameters parameters, Collection<Traveller> travellers, Customer customer, FarelogixGdsAccount gdsAccount) throws Exception {
        Flight flight = parameters.getFlight();
        List gdsTravellers = parameters.getGdsTravellers();
        PNRCreateRQ result = new PNRCreateRQ();
        PNRCreateRQ.EndTransaction et = new PNRCreateRQ.EndTransaction();
        et.setIgnoreWarnings(true);
        et.setTransactionType(PNRCreateRQ.TransactionType.END_TRANSACTION_RETRIEVE_PNR);
        result.setEndTransaction(et);
        PNRCreateRQ.CompletePNRElements pnrElements = new PNRCreateRQ.CompletePNRElements();
        PNRCreateRQ.OtherPNRElements otherPnrElements = new PNRCreateRQ.OtherPNRElements();
        int index = 0;
        ArrayList<Traveller> infants = new ArrayList<Traveller>();
        ArrayList<Object> adults = new ArrayList<Object>();
        for (GdsTraveller gdsTraveller : gdsTravellers) {
            ++index;
            Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)gdsTraveller.getTravellerUid());
            DictionaryReference passengerType = gdsTraveller.getPassengerType();
            if (DictHelper.isInfantPassengerType((DictionaryReference)passengerType)) {
                infants.add(traveller);
                continue;
            }
            PNRCreateRQ.Traveler tr = new PNRCreateRQ.Traveler();
            String travelerIDRef = "T" + index;
            tr.setAssociationID(travelerIDRef);
            tr.setType(FarelogixHelper.getNativeCode(passengerType));
            tr.setTravelerName(this.buildTravelerName(traveller, (DictionaryReference<PassengerType>)passengerType));
            pnrElements.getTravelers().add(tr);
            if (DictHelper.isAdultPassengerTypeCategory((DictionaryReference)passengerType)) {
                adults.add(tr);
            }
            this.fillTravellerElements(pnrElements, otherPnrElements, traveller, travelerIDRef, false);
        }
        int travellersWithSeats = gdsTravellers.size() - infants.size();
        PNRCreateRQ.Itinerary itinerary = new PNRCreateRQ.Itinerary();
        int i = 1;
        int odInd = 0;
        for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
            for (FlightSegment fs : fst.getSegments()) {
                PNRCreateRQ.FlightRQ gdsFlight = this.buildGdsFlight(fs);
                gdsFlight.setAssociationID("F".concat(String.valueOf(i++)));
                if (fs.isStarting()) {
                    ++odInd;
                }
                gdsFlight.setOriginDestinationID("OD".concat(String.valueOf(odInd)));
                gdsFlight.setNumberInParty(String.valueOf(travellersWithSeats));
                itinerary.getFlights().add(gdsFlight);
            }
        }
        pnrElements.setItinerary(itinerary);
        for (int i2 = 0; i2 < infants.size(); ++i2) {
            Traveller infant = (Traveller)infants.get(i2);
            PNRCreateRQ.Traveler adult = (PNRCreateRQ.Traveler)adults.get(i2);
            String travelerIDRef = adult.getAssociationID().concat(".1");
            PNRCreateRQ.Infant inf = this.buildInfant(infant);
            inf.setAssociationID(travelerIDRef);
            inf.setType(FarelogixHelper.getNativeCode(DictHelper.getInfantPassengerType()));
            adult.setInfant(inf);
            this.fillTravellerElements(pnrElements, otherPnrElements, infant, travelerIDRef, true);
        }
        this.fillContacts(pnrElements.getTelephones(), otherPnrElements.getEmailAddresses(), customer.getCommunications(), null);
        result.setCompletePNRElements(pnrElements);
        result.setOtherPNRElements(otherPnrElements);
        PricingInfo pi = new PricingInfo();
        pi.setWithPrice(Boolean.TRUE);
        pi.setStorePrice(Boolean.TRUE);
        pi.setFareType(NamedValueHelper.getValueForName((String)"farelogix-fare-type", (Collection)flight.getCustomProperties()));
        pi.setRestrictions(FarelogixHelper.buildStandardRestrictions());
        pi.setPrivateFares(FarelogixHelper.buildStandardPrivateFares(gdsAccount.getPcc()));
        pi.getSegmentIDRefs().addAll(this.buildSegmentIDRefs(result.getCompletePNRElements().getItinerary()));
        pi.getTravelerIDRefs().addAll(this.getTravelerIDRefs(result.getOtherPNRElements()));
        result.getPricingInfoList().add(pi);
        return result;
    }

    private PNRCreateRQ.FlightRQ buildGdsFlight(FlightSegment fs) throws Exception {
        PNRCreateRQ.FlightRQ result = new PNRCreateRQ.FlightRQ();
        String source = NamedValueHelper.getValueForName((String)"farelogix-source", (Collection)fs.getCustomProperties());
        result.setSource(source);
        result.setDeparture(FarelogixHelper.buildFlightEvent((DictionaryReference<GeoLocation>)fs.getLocationBegin(), fs.getDateBegin()));
        result.setArrival(FarelogixHelper.buildFlightEvent((DictionaryReference<GeoLocation>)fs.getLocationEnd(), fs.getDateEnd()));
        result.setCarrier(FarelogixHelper.buildCarrier((DictionaryReference<Airline>)fs.getAirline(), fs.getFlightNumber()));
        result.setClassOfService(fs.getBookingClass());
        result.setFareRefKey(FarelogixHelper.getFareRefKey(fs));
        result.setPriceClass(FarelogixHelper.buildPriceClass(fs));
        return result;
    }

    private TravelerName buildTravelerName(Traveller traveller, DictionaryReference<PassengerType> passengerType) {
        TravelerName result = new TravelerName();
        this.fillTravelInfo(result, traveller);
        result.setTitle(FarelogixHelper.getTravellerTitle(traveller.getPassport().getGender(), passengerType));
        return result;
    }

    private PNRCreateRQ.Infant buildInfant(Traveller traveller) {
        PNRCreateRQ.Infant result = new PNRCreateRQ.Infant();
        this.fillTravelInfo(result, traveller);
        return result;
    }

    private void fillTravelInfo(TravelerInfo result, Traveller traveller) {
        result.setGender(FarelogixHelper.convertGenderToGds(traveller.getPassport().getGender()));
        result.setSurname(traveller.getPassport().getLastName());
        result.setGivenName(traveller.getPassport().getFirstName());
        result.setDateOfBirth(FarelogixHelper.toLocalDate(traveller.getPassport().getBirthday()));
    }

    private void fillTravellerElements(PNRCreateRQ.CompletePNRElements pnrElements, PNRCreateRQ.OtherPNRElements otherPnrElements, Traveller traveller, String travelerIDRef, boolean isInfant) {
        PNRCreateRQ.Apis apis = new PNRCreateRQ.Apis();
        apis.setTravelerIDRef(travelerIDRef);
        apis.setPictureID(this.buildPictureId(traveller));
        otherPnrElements.getApisList().add(apis);
        this.fillContacts(pnrElements.getTelephones(), otherPnrElements.getEmailAddresses(), traveller.getCommunications(), travelerIDRef);
        for (AirlineBonusCard card : traveller.getAirlineBonusCards()) {
            PNRCreateRQ.FrequentTravelerGroup ftg = new PNRCreateRQ.FrequentTravelerGroup();
            ftg.setTravelerIDRef(travelerIDRef);
            ftg.setFfCompanyCode(card.getAirline().getCode());
            ftg.setFfNumber(card.getNumber());
            otherPnrElements.getFrequentTravelerGroups().add(ftg);
        }
        otherPnrElements.getApisList().addAll(FarelogixHelper.buildDocoDocaApis(traveller, travelerIDRef, isInfant));
    }

    private PNRCreateRQ.PictureID buildPictureId(Traveller traveller) {
        PNRCreateRQ.PictureID result = new PNRCreateRQ.PictureID();
        result.setGender(FarelogixHelper.convertGenderToGds(traveller.getPassport().getGender()));
        result.setSurname(traveller.getPassport().getLastName());
        result.setGivenName(traveller.getPassport().getFirstName());
        result.setDateOfBirth(FarelogixHelper.toLocalDate(traveller.getPassport().getBirthday()));
        result.setDocType(FarelogixHelper.convertPassportTypeToGds(traveller.getPassport().getType()));
        result.setDocNumber(traveller.getPassport().getNumber());
        String country = FarelogixHelper.getNativeCode(traveller.getPassport().getCitizenship());
        result.setNationalityCountry(country);
        result.setIssueCountry(country);
        result.setDocExpirationDate(FarelogixHelper.toLocalDate(traveller.getPassport().getExpired()));
        return result;
    }

    private void fillContacts(List<PNRCreateRQ.Telephone> telephones, List<PNRCreateRQ.EmailAddress> emailAddresses, List<Communication> communications, String travelerIDRef) {
        for (Communication comm : communications) {
            PNRCreateRQ.Telephone tel = this.buildTelephone(comm);
            if (tel != null) {
                if (!TextUtil.isBlank((String)travelerIDRef)) {
                    tel.getTravelerIDRefs().add(travelerIDRef);
                }
                telephones.add(tel);
                continue;
            }
            PNRCreateRQ.EmailAddress ea = this.buildEmailAddress(comm);
            if (ea == null) continue;
            if (!TextUtil.isBlank((String)travelerIDRef)) {
                ea.getTravelerIDRefs().add(travelerIDRef);
            }
            emailAddresses.add(ea);
        }
    }

    private PNRCreateRQ.Telephone buildTelephone(Communication comm) {
        PhoneType phoneType = FarelogixHelper.convertPhoneTypeToGds(comm.getType());
        if (phoneType == null) {
            return null;
        }
        PNRCreateRQ.Telephone result = new PNRCreateRQ.Telephone();
        result.setType(phoneType);
        result.setTelephoneNumber(ProfileHelper.getCommunicationPhone((Communication)comm));
        return result;
    }

    private PNRCreateRQ.EmailAddress buildEmailAddress(Communication comm) {
        EmailAddressType emailAddressType = FarelogixHelper.convertEmailAddressTypeToGds(comm.getType());
        if (emailAddressType == null) {
            return null;
        }
        PNRCreateRQ.EmailAddress result = new PNRCreateRQ.EmailAddress();
        result.setType(emailAddressType);
        result.setEmail(ProfileHelper.normalizeCommunicationPart((String)comm.getSense()));
        return result;
    }

    private List<PricingInfo.SegmentIDRef> buildSegmentIDRefs(PNRCreateRQ.Itinerary itinerary) {
        ArrayList<PricingInfo.SegmentIDRef> result = new ArrayList<PricingInfo.SegmentIDRef>();
        itinerary.getFlights().forEach(fl -> result.add(this.buildSegmentIDRef((PNRCreateRQ.FlightRQ)fl)));
        return result;
    }

    private PricingInfo.SegmentIDRef buildSegmentIDRef(PNRCreateRQ.FlightRQ fl) {
        PricingInfo.SegmentIDRef result = new PricingInfo.SegmentIDRef();
        result.setValue(fl.getAssociationID());
        result.setFareRefKey(fl.getFareRefKey());
        if (fl.getPriceClass() != null) {
            result.setPriceClassCode(fl.getPriceClass().getCode());
            result.setPriceClassName(fl.getPriceClass().getName());
        }
        fl.setFareRefKey(null);
        fl.setPriceClass(null);
        return result;
    }

    private List<String> getTravelerIDRefs(PNRCreateRQ.OtherPNRElements otherPNRElements) {
        ArrayList<String> result = new ArrayList<String>();
        otherPNRElements.getApisList().forEach(ap -> {
            if (!result.contains(ap.getTravelerIDRef())) {
                result.add(ap.getTravelerIDRef());
            }
        });
        return result;
    }
}

