/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FarelogixHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.model.PNRViewRS;
import com.gridnine.xtrip.server.gds.farelogix.model.common.CurrencyInfo;
import com.gridnine.xtrip.server.gds.farelogix.model.common.FareGroup;
import com.gridnine.xtrip.server.gds.farelogix.model.common.FareGroupRS;
import com.gridnine.xtrip.server.gds.farelogix.model.common.TravelerRS;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class FarelogixCreateReservationResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        PNRViewRS response = (PNRViewRS)ctx.getMandatoryObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        Reservation reservation = this.createReservation(response, parameters, travellers, gdsParameters);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)reservation);
    }

    private Reservation createReservation(PNRViewRS response, GdsReservationCreationParameters parameters, Collection<Traveller> travellers, GDSParameters gdsParameters) throws Exception {
        Date now = new Date();
        Reservation res = new Reservation();
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)res, (GdsName)GdsName.FARELOGIX, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)response.getPnrIdentification().getRecordLocator());
        res.setPricingDate(now);
        res.setRefreshFromGdsDate(now);
        res.setResDate(now);
        if (response.getFareGroups().isEmpty()) {
            throw Xeption.forDeveloper((String)"No FareGroup in response", (Object[])new Object[0]);
        }
        if (response.getFareGroups().get(0).getTravelerGroups().isEmpty()) {
            throw Xeption.forDeveloper((String)"No TravelerGroup in response", (Object[])new Object[0]);
        }
        FareGroup.TicketByDate ticketByDate = response.getFareGroups().get(0).getTravelerGroups().get(0).getFareRules().getTicketByDate();
        res.setPqTimeLimit(FarelogixHelper.toSystemDateTime(ticketByDate.getDateValue(), ticketByDate.getTimeValue()));
        Product productTemplate = new Product();
        productTemplate.setProductCategory(ProductCategory.AIR);
        productTemplate.setTicketType(TicketType.OWN);
        productTemplate.setStatus(ProductStatus.BOOKING);
        productTemplate.setTariffType(TariffType.REGULAR);
        productTemplate.setEticket(this.calcEticket(response.getAirGroup().getFlights()));
        productTemplate.setIssueDate(now);
        BlankType blankType = BookingHelper.getBlankType((EntityReference)gdsParameters.getBlankOwner(), (Product)productTemplate);
        if (blankType != null) {
            productTemplate.setBlankType((DictionaryReference)blankType.toReference());
        }
        productTemplate.setCarrier(FarelogixHelper.getDictReference(Airline.class, response.getValidatingCarrier().getAirlineCode()));
        if (productTemplate.getCarrier() != null) {
            productTemplate.setCarrierNumber(((Airline)DictionaryCache.get().resolveReference(productTemplate.getCarrier())).getAirlineNumber());
        }
        ArrayList<Segment> segments = new ArrayList<Segment>();
        String odRefOld = null;
        for (PNRViewRS.FlightRS flight : response.getAirGroup().getFlights()) {
            Segment seg = FarelogixCreateReservationResponseParser.buildSegment(flight);
            String odRef = flight.getOriginDestinationID();
            boolean newLeg = !MiscUtil.equals(odRefOld, (Object)odRef);
            seg.setStarting(newLeg);
            if (newLeg) {
                odRefOld = odRef;
            }
            segments.add(seg);
        }
        for (GdsTraveller gdsTraveller : parameters.getGdsTravellers()) {
            boolean isInfant = DictHelper.isInfantPassengerType((DictionaryReference)gdsTraveller.getPassengerType());
            Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)gdsTraveller.getTravellerUid());
            TravelerRS gdsTr = FarelogixHelper.findGdsTraveller(traveller, isInfant, response.getTravelers());
            if (gdsTr == null) {
                throw Xeption.forDeveloper((String)"can't find gds traveller {0}", (Object[])new Object[]{traveller.getName()});
            }
            String travelerElementNumber = isInfant ? gdsTr.getInfant().getElementNumber() : gdsTr.getElementNumber();
            String passengerTypeCode = isInfant ? gdsTr.getInfant().getType() : gdsTr.getType();
            MiscUtil.Pair<FareGroupRS, PNRViewRS.TravelerGroupRS> pair = FarelogixHelper.findTravelerGroup(travelerElementNumber, response);
            if (pair == null) {
                throw Xeption.forDeveloper((String)"can't find TravelerGroup by travelerElementNumber {0}", (Object[])new Object[]{travelerElementNumber});
            }
            FareGroupRS fg = (FareGroupRS)pair.getFirst();
            PNRViewRS.TravelerGroupRS tg = (PNRViewRS.TravelerGroupRS)pair.getSecond();
            CurrencyInfo currencyInfo = fg.getCurrencyInfo();
            if (productTemplate.getSegmentTariffs().isEmpty()) {
                String calcLine = tg.getFareRules().getFareCalculation();
                List stList = GDSHelper.buildSegmentTariffs(segments, (String)calcLine);
                productTemplate.getSegmentTariffs().addAll(stList);
            }
            Product product = (Product)XCloneHelper.clone((XCloneable)productTemplate, (boolean)true);
            product.setGdsCurrency(currencyInfo.getCurrencyCode());
            ProductHandler.of((BaseProduct)product).setOrReplaceTraveller((BaseProduct)product, traveller);
            product.setPassengerType(FarelogixHelper.getDictReference(PassengerType.class, passengerTypeCode));
            res.getProducts().add(product);
            product.setReservation(res);
            product.setGdsId(travelerElementNumber);
            FarelogixHelper.updateProduct(product, tg, currencyInfo, fg.getFareType(), fg.getSource());
        }
        return res;
    }

    private boolean calcEticket(List<PNRViewRS.FlightRS> flights) {
        for (PNRViewRS.FlightRS flight : flights) {
            if (flight.isElectronicTicketing()) continue;
            return false;
        }
        return true;
    }

    public static Segment buildSegment(PNRViewRS.FlightRS flight) {
        Segment result = new Segment();
        result.setGdsId(flight.getElementNumber());
        result.setAirlineLocator(flight.getSourceRef());
        result.setDepartureLocation(FarelogixHelper.getDictReference(GeoLocation.class, flight.getDeparture().getAirportCode()));
        result.setDepartTerminal(flight.getDeparture().getTerminal());
        result.setStartDate(FarelogixHelper.calcDateTime(flight.getDeparture().getDate(), flight.getDeparture().getTime()));
        result.setArriveLocation(FarelogixHelper.getDictReference(GeoLocation.class, flight.getArrival().getAirportCode()));
        result.setArriveTerminal(flight.getArrival().getTerminal());
        result.setEndDate(FarelogixHelper.calcDateTime(flight.getArrival().getDate(), flight.getArrival().getTime()));
        if (flight.getFlightDuration() != null) {
            result.setFlightDuration(Integer.valueOf((int)flight.getFlightDuration().getStandardMinutes()));
        }
        result.setAirline(FarelogixHelper.getDictReference(Airline.class, flight.getCarrier().getAirlineCode()));
        result.setFlightNo(flight.getCarrier().getFlightNumber());
        if (flight.getOperatingCarrier() != null) {
            result.setCodeShareCarrier(FarelogixHelper.resolveNativeCode(Airline.class, flight.getOperatingCarrier().getAirlineCode()));
            if (result.getAirline() != null) {
                result.setCodeShare(!result.getAirline().equals((Object)result.getCodeShareCarrier()));
            }
        } else {
            result.setCodeShareCarrier(result.getAirline());
        }
        if (flight.getEquipment() != null) {
            result.setBoard(FarelogixHelper.getDictReference(Aircraft.class, flight.getEquipment().getCode()));
        }
        result.setClassOfSvcCode(flight.getClassOfService());
        result.setNotValidBefore(result.getStartDate());
        result.setNotValidAfter(result.getEndDate());
        return result;
    }
}

