/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.getFareRules;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.farelogix.model.FarelogixGdsAccount;
import com.gridnine.xtrip.common.gds.farelogix.model.FarelogixRemarksSearchContext;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FarelogixHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.model.FareRulesRQ;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;

public class FarelogixGetFareRulesRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String context = (String)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FARE_REMARKS_SEARCH_CONTEXT);
        Flight flight = (Flight)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT);
        Reservation reservation = (Reservation)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        FareRulesRQ request = null;
        if (flight != null) {
            request = this.buildRequest(flight, context);
        } else if (reservation != null) {
            request = this.buildRequest(reservation, context);
        } else {
            throw Xeption.forDeveloper((String)"FareRulesRQ is null", (Object[])new Object[0]);
        }
        request.setFareOptions(new FareRulesRQ.FareOptions());
        request.getFareOptions().setPrivateFares(FarelogixHelper.buildStandardPrivateFares(((FarelogixGdsAccount)accountCtr.getEntity()).getPcc()));
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_REQUEST, (Object)request);
    }

    private FareRulesRQ buildRequest(Flight flight, String contextStr) throws Exception {
        FareRulesRQ result = new FareRulesRQ();
        FarelogixRemarksSearchContext ctx = FarelogixHelper.convertToRemarksSearchContext(contextStr);
        FlightSegment fs = FlightHelper.findSegmentByGdsId((Flight)flight, (String)ctx.getSegmentKey());
        if (fs == null) {
            throw Xeption.forDeveloper((String)"can't find segment by gdsId {0}", (Object[])new Object[]{ctx.getSegmentKey()});
        }
        result.setDepartureDate(FarelogixHelper.toLocalDate(fs.getDateBegin()));
        result.setDepartureCity(FarelogixHelper.getNativeCode(fs.getLocationBegin()));
        result.setArrivalCity(FarelogixHelper.getNativeCode(fs.getLocationEnd()));
        result.setAirlineCode(FarelogixHelper.getNativeCode(fs.getAirline()));
        this.updateRequest(result, ctx);
        return result;
    }

    private FareRulesRQ buildRequest(Reservation reservation, String contextStr) throws Exception {
        FareRulesRQ result = new FareRulesRQ();
        FarelogixRemarksSearchContext ctx = FarelogixHelper.convertToRemarksSearchContext(contextStr);
        Segment seg = this.findSegmentByKey(reservation, ctx.getSegmentKey());
        if (seg == null) {
            seg = this.findSegmentByKeyOld(reservation, ctx.getSegmentKey());
        }
        if (seg == null) {
            throw Xeption.forDeveloper((String)"can't find segment by key {0}", (Object[])new Object[]{ctx.getSegmentKey()});
        }
        result.setDepartureDate(FarelogixHelper.toLocalDate(seg.getStartDate()));
        result.setDepartureCity(FarelogixHelper.getNativeCode(seg.getDepartureLocation()));
        result.setArrivalCity(FarelogixHelper.getNativeCode(seg.getArriveLocation()));
        result.setAirlineCode(FarelogixHelper.getNativeCode(seg.getAirline()));
        this.updateRequest(result, ctx);
        return result;
    }

    private void updateRequest(FareRulesRQ result, FarelogixRemarksSearchContext ctx) {
        result.setFareRefKey(ctx.getFareRefKey());
        result.setFareType(ctx.getFareType());
        FareRulesRQ.RulesFareBasisCode fareBasisCode = new FareRulesRQ.RulesFareBasisCode();
        fareBasisCode.setValue(ctx.getFareBasis());
        fareBasisCode.setCode(ctx.getPriceClassCode());
        fareBasisCode.setPriceClass(ctx.getPriceClassName());
        fareBasisCode.setSource(ctx.getSource());
        result.setFareBasisCode(fareBasisCode);
    }

    private Segment findSegmentByKey(Reservation reservation, String segmentKey) {
        if (TextUtil.isBlank((String)segmentKey)) {
            return null;
        }
        Product firstProduct = (Product)AirProductHelper.getAirProductsList((Reservation)reservation).get(0);
        for (Segment segment : AirProductHelper.getSegments((Collection)firstProduct.getSegmentTariffs())) {
            String key = FarelogixHelper.buildProductSegmentKey(segment);
            if (!segmentKey.equals(key)) continue;
            return segment;
        }
        return null;
    }

    private Segment findSegmentByKeyOld(Reservation reservation, String segmentKey) {
        if (TextUtil.isBlank((String)segmentKey)) {
            return null;
        }
        for (BaseProduct bp : reservation.getProducts()) {
            if (!(bp instanceof Product)) continue;
            Product prod = (Product)bp;
            for (Segment segment : AirProductHelper.getSegments((Collection)prod.getSegmentTariffs())) {
                String key = FarelogixHelper.buildProductSegmentKeyOld(prod, segment);
                if (!segmentKey.equals(key)) continue;
                return segment;
            }
        }
        return null;
    }
}

