/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.modifyFqtv;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.farelogix.model.FarelogixGdsAccount;
import com.gridnine.xtrip.common.gds.model.AirlineBonusCardParameters;
import com.gridnine.xtrip.common.gds.model.ModifyAirlineBonusCardsParameters;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BookingAirlineBonusCard;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FarelogixHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.ibus.modifyFqtv.PNRCreateRQBuilder;
import com.gridnine.xtrip.server.gds.farelogix.model.PNRCreateRQ;
import com.gridnine.xtrip.server.gds.ibus.fqtv.IBusGdsFqtvContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import org.junit.Assert;
import org.junit.Test;

public class PNRCreateRQBuilderTest
extends ModelTestBase {
    @Test
    public void test() throws Exception {
        MessageContext ctx = new MessageContext();
        ModifyAirlineBonusCardsParameters mabcp = new ModifyAirlineBonusCardsParameters();
        AirlineBonusCardParameters acp = new AirlineBonusCardParameters();
        acp.setTravellerUid("TestTravelerUID1");
        BookingAirlineBonusCard babc = new BookingAirlineBonusCard();
        babc.setAirline(FarelogixHelper.getDictReference(Airline.class, "SU"));
        babc.setNumber("12345678");
        acp.setCard(babc);
        mabcp.getCardsToAdd().add(acp);
        ctx.putObject((Enum)IBusGdsFqtvContextKeys.MODIFY_AIRLINE_BONUS_CARDS_PARAMETERS, (Object)mabcp);
        Reservation reservation = new Reservation();
        FarelogixGdsAccount account = new FarelogixGdsAccount();
        account.setGds(GdsName.FARELOGIX);
        EntityContainer accountCtr = EntityContainer.create((BaseEntity)account);
        EntityStorage.get().save(accountCtr, true);
        reservation.getGdsNameInfo().setOnlineGdsAccount(accountCtr.toReference());
        Product prod = new Product();
        prod.setGdsId("ProductGdsID");
        Traveller trav = new Traveller();
        trav.setUid("TestTravelerUID1");
        prod.setTraveller(trav);
        reservation.getProducts().add(prod);
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.FARELOGIX, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)"RecordLocator");
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)reservation);
        new PNRCreateRQBuilder().process(ctx);
        PNRCreateRQ pnrCreateRQ = (PNRCreateRQ)ctx.getMandatoryObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_REQUEST);
        Assert.assertEquals((Object)"ProductGdsID", (Object)pnrCreateRQ.getOtherPNRElements().getFrequentTravelerGroups().get(0).getTravelerIDRef());
        Assert.assertEquals((Object)"SU", (Object)pnrCreateRQ.getOtherPNRElements().getFrequentTravelerGroups().get(0).getFfCompanyCode());
        Assert.assertEquals((Object)"12345678", (Object)pnrCreateRQ.getOtherPNRElements().getFrequentTravelerGroups().get(0).getFfNumber());
        Assert.assertEquals((Object)((Object)PNRCreateRQ.TransactionType.END_TRANSACTION_RETRIEVE_PNR), (Object)((Object)pnrCreateRQ.getEndTransaction().getTransactionType()));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)pnrCreateRQ.getEndTransaction().isIgnoreWarnings());
        Assert.assertEquals((Object)"RecordLocator", (Object)pnrCreateRQ.getRecordLocator());
    }
}

