/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.pnrRetrieve;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FarelogixHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.model.PNRViewRS;
import com.gridnine.xtrip.server.gds.farelogix.model.common.TravelerRS;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Set;
import java.util.stream.Collectors;

public class FarelogixUpdateProductGdsIdProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PNRViewRS response = (PNRViewRS)ctx.getMandatoryObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        boolean isSplit = BooleanUtil.nullAsFalse((Boolean)((Boolean)ctx.getObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_GDS_IS_SPLIT)));
        if (!this.check(response, reservation) && !isSplit) {
            throw Xeption.forEndUser((String)"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e \u0432 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u0440\u0443\u0447\u043d\u043e\u0433\u043e \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f, \u0434\u0430\u043b\u044c\u043d\u0435\u0439\u0448\u0438\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0441 \u0437\u0430\u043a\u0430\u0437\u043e\u043c \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b, \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u0432 \u0441\u043b\u0443\u0436\u0431\u0443 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0438", (Object[])new Object[0]);
        }
        this.updateReservation(reservation, response);
    }

    private boolean check(PNRViewRS response, Reservation reservation) {
        if (reservation.getBookingFile() == null) {
            return true;
        }
        Set travellers = AirProductHelper.getProducts((Reservation)reservation).stream().map(Product::getTraveller).collect(Collectors.toSet());
        return response.getFareGroups().get(0).getTravelerCount().intValue() == travellers.size();
    }

    private void updateReservation(Reservation reservation, PNRViewRS response) throws Exception {
        for (Product prod : AirProductHelper.getProducts((Reservation)reservation)) {
            boolean isInfant = DictHelper.isInfantPassengerType((DictionaryReference)prod.getPassengerType());
            Traveller traveller = prod.getTraveller();
            TravelerRS gdsTr = FarelogixHelper.findGdsTraveller(traveller, isInfant, response.getTravelers());
            if (gdsTr == null) {
                throw Xeption.forDeveloper((String)"can't find gds traveller {0}", (Object[])new Object[]{traveller.getName()});
            }
            String travelerElementNumber = isInfant ? gdsTr.getInfant().getElementNumber() : gdsTr.getElementNumber();
            prod.setGdsId(travelerElementNumber);
        }
    }
}

