/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.searchFlights;

import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.farelogix.ndc.AirShopResMetadataType;
import com.gridnine.farelogix.ndc.AirShoppingRS;
import com.gridnine.farelogix.ndc.AugPointType;
import com.gridnine.farelogix.ndc.CurrencyAmountOptType;
import com.gridnine.farelogix.ndc.FareComponentType;
import com.gridnine.farelogix.ndc.FareDetailType;
import com.gridnine.farelogix.ndc.FareList;
import com.gridnine.farelogix.ndc.ListOfFlightSegmentType;
import com.gridnine.farelogix.ndc.Offer;
import com.gridnine.farelogix.ndc.OfferInstructionMetadata;
import com.gridnine.farelogix.ndc.OfferItemType;
import com.gridnine.farelogix.ndc.OfferType;
import com.gridnine.farelogix.ndc.OriginDestination;
import com.gridnine.farelogix.ndc.OriginDestinationType;
import com.gridnine.farelogix.ndc.PTCQuantityPricedType;
import com.gridnine.farelogix.ndc.PassengerType;
import com.gridnine.farelogix.ndc.PriceClassType;
import com.gridnine.farelogix.ndc.TaxDetailType;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FarelogixHelper;
import com.gridnine.xtrip.server.gds.farelogix.model.common.FareBasisCode;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FarelogixFlightsBuilder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int DEFAULT_FLIGHTS_LIMIT = 200;
    private final List<AirShoppingRS.Sequence.AirlineOffers.Offer> completedOffers = new ArrayList<AirShoppingRS.Sequence.AirlineOffers.Offer>();
    private final Map<String, List<AirShoppingRS.Sequence.AirlineOffers.Offer>> offersByFlightRef = new HashMap<String, List<AirShoppingRS.Sequence.AirlineOffers.Offer>>();
    private final Map<String, ListOfFlightSegmentType> flightSegmentsMap = new HashMap<String, ListOfFlightSegmentType>();
    private final Map<String, DictionaryReference<com.gridnine.xtrip.common.model.booking.PassengerType>> passengerTypes = new HashMap<String, DictionaryReference<com.gridnine.xtrip.common.model.booking.PassengerType>>();
    private final Map<String, String> fareRefKeys = new HashMap<String, String>();
    private final Map<String, FareList.FareGroup> fareListGroups = new HashMap<String, FareList.FareGroup>();
    private final Map<String, AirShoppingRS.Sequence.DataLists.FlightList.Flight> flightsMap = new HashMap<String, AirShoppingRS.Sequence.DataLists.FlightList.Flight>();
    private final Map<String, PriceClassType> gdsPriceClasses = new HashMap<String, PriceClassType>();
    private final Map<String, List<String>> priceClassAssociations = new HashMap<String, List<String>>();
    private final Map<FilterFlight, Collection<String>> traceFlights = new LinkedHashMap<FilterFlight, Collection<String>>();
    private final AirShoppingRS response;
    private final FlightSearchParameters fsp;
    private final GdsTracingItemBuilder<Flight> builder;
    private final boolean isSaveRulesTraces;

    public FarelogixFlightsBuilder(AirShoppingRS response, FlightSearchParameters fsp, GdsTracingItemBuilder<Flight> builder, boolean isSaveRulesTraces) {
        this.response = response;
        this.fsp = fsp;
        this.builder = builder;
        this.isSaveRulesTraces = isSaveRulesTraces;
    }

    public List<Flight> build() throws Exception {
        ArrayList<Flight> result = new ArrayList<Flight>();
        if (this.response.getSequence().getSuccess() == null) {
            return result;
        }
        this.fillPassengerTypes(this.response.getSequence().getDataLists());
        this.fillAirlineOfferMaps(this.response.getSequence().getAirlineOfferList());
        this.fillFareRefKeys(this.response.getSequence().getMetadata().getOther());
        this.fillFareListGroups(this.response.getSequence().getDataLists());
        this.fillFlightsMap(this.response.getSequence().getDataLists());
        this.fillFlightSegmentsMap(this.response.getSequence().getDataLists());
        this.fillPriceClassMaps();
        result.addAll(this.buildSimpleFlights());
        result.addAll(this.buildMultiFlights());
        this.saveRulesTraces();
        return result;
    }

    private List<Flight> buildSimpleFlights() throws Exception {
        ArrayList<Flight> result = new ArrayList<Flight>();
        for (AirShoppingRS.Sequence.AirlineOffers.Offer offer : this.completedOffers) {
            Flight flight = this.buildFlight(Collections.singletonList(offer));
            result.add(flight);
        }
        return result;
    }

    private List<Flight> buildMultiFlights() throws Exception {
        int limit;
        ArrayList<Flight> result = new ArrayList<Flight>();
        Map<String, List<OriginDestination>> carrierDestinations = this.response.getSequence().getDataLists().getOriginDestinationList().getOriginDestinationList().stream().collect(Collectors.groupingBy(OriginDestinationType::getRefs));
        ArrayList<List<AirShoppingRS.Sequence.AirlineOffers.Offer>> allCartesianVariants = new ArrayList<List<AirShoppingRS.Sequence.AirlineOffers.Offer>>();
        for (List<OriginDestination> ods : carrierDestinations.values()) {
            ArrayList arrayList = new ArrayList();
            for (OriginDestination originDestination : ods) {
                ArrayList<AirShoppingRS.Sequence.AirlineOffers.Offer> offers2 = new ArrayList<AirShoppingRS.Sequence.AirlineOffers.Offer>();
                for (String flightRef : FarelogixFlightsBuilder.toArray(originDestination.getFlightReferences().getString())) {
                    List<AirShoppingRS.Sequence.AirlineOffers.Offer> flightOffers = this.offersByFlightRef.get(flightRef);
                    if (flightOffers == null) continue;
                    offers2.addAll(flightOffers);
                }
                arrayList.add(offers2);
            }
            if (arrayList.size() != this.fsp.getRoute().size()) {
                throw Xeption.forDeveloper((String)"gds legs number {0} != search legs number {1}", (Object[])new Object[]{arrayList.size(), this.fsp.getRoute().size()});
            }
            List cartesianVariants = CollectionUtil.cartesianProduct(arrayList);
            allCartesianVariants.addAll(cartesianVariants);
        }
        allCartesianVariants.removeIf(offers -> !this.validVariant((List<AirShoppingRS.Sequence.AirlineOffers.Offer>)offers));
        int n = limit = this.fsp.getLimit() != null ? this.fsp.getLimit() : 200;
        if (allCartesianVariants.size() > limit) {
            this.limitVariants(allCartesianVariants, limit);
            try {
                if (this.isSaveRulesTraces) {
                    String mes = String.format("flights limit (%s) exceeded: %s \n", limit, allCartesianVariants.size());
                    Collection collection = CollectionUtil.getOrAddList(this.traceFlights, (Object)((Object)FilterFlight.EXCEEDED_LIMIT));
                    collection.add(mes);
                }
            }
            catch (Exception e) {
                this.log.error("writing limitLog failed", (Throwable)e);
            }
        }
        for (List list : allCartesianVariants) {
            Flight flight = this.buildFlight(list);
            result.add(flight);
        }
        return result;
    }

    private boolean validVariant(List<AirShoppingRS.Sequence.AirlineOffers.Offer> offers) {
        String offersInfo = this.getOffersInfo(offers);
        String mes = this.checkCarriers(offers);
        if (TextUtil.nonBlank((String)mes)) {
            Collection messages = CollectionUtil.getOrAddList(this.traceFlights, (Object)((Object)FilterFlight.INVALID_SEGMENTS));
            messages.add(String.format("offers %s excluded: %s", offersInfo, mes));
            return false;
        }
        mes = this.checkPriceClasses(offers);
        if (TextUtil.nonBlank((String)mes)) {
            Collection messages = CollectionUtil.getOrAddList(this.traceFlights, (Object)((Object)FilterFlight.INVALID_PRICE_CLASSES));
            messages.add(String.format("offers %s excluded: %s", offersInfo, mes));
            return false;
        }
        return true;
    }

    private String checkCarriers(List<AirShoppingRS.Sequence.AirlineOffers.Offer> airlineOffers) {
        Set carriers = airlineOffers.stream().map(OfferType::getOwner).collect(Collectors.toSet());
        if (carriers.size() > 1) {
            return String.format("different carriers: %s", carriers);
        }
        return null;
    }

    private String checkPriceClasses(List<AirShoppingRS.Sequence.AirlineOffers.Offer> offers) {
        if (offers.isEmpty()) {
            return null;
        }
        ArrayList<String> flightClasses = new ArrayList<String>();
        ArrayList<String> availableClasses = new ArrayList<String>();
        for (int i = 0; i < offers.size(); ++i) {
            AirShoppingRS.Sequence.AirlineOffers.Offer firstOffer = offers.get(i);
            for (AirShoppingRS.Sequence.AirlineOffers.Offer.FlightsOverview.FlightRef flightRef : firstOffer.getFlightsOverview().getFlightRefList()) {
                List<String> classAssociations;
                if (CollectionUtil.isEmptyMap(this.priceClassAssociations)) continue;
                String priceClass = flightRef.getPriceClassRef();
                if (priceClass != null) {
                    flightClasses.add(priceClass);
                }
                if (i != 0 || CollectionUtil.isEmpty(classAssociations = this.priceClassAssociations.get(priceClass))) continue;
                availableClasses.addAll(classAssociations);
            }
        }
        if (!availableClasses.isEmpty() && !availableClasses.containsAll(flightClasses)) {
            return String.format("flight price classes %s is not in %s", flightClasses, availableClasses);
        }
        return null;
    }

    private void limitVariants(List<List<AirShoppingRS.Sequence.AirlineOffers.Offer>> cartesianVariants, int limit) {
        cartesianVariants.sort(Comparator.comparing(this::getPrice));
        int cur = 0;
        BigDecimal lastPrice = null;
        Iterator<List<AirShoppingRS.Sequence.AirlineOffers.Offer>> it = cartesianVariants.iterator();
        while (it.hasNext()) {
            List<AirShoppingRS.Sequence.AirlineOffers.Offer> legs = it.next();
            if (++cur <= limit) continue;
            BigDecimal price = this.getPrice(legs);
            if (lastPrice == null) {
                lastPrice = price;
            }
            if (lastPrice.compareTo(price) >= 0) continue;
            it.remove();
        }
    }

    private BigDecimal getPrice(List<AirShoppingRS.Sequence.AirlineOffers.Offer> offers) {
        return offers.stream().map(this::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal getPrice(AirShoppingRS.Sequence.AirlineOffers.Offer offer) {
        return offer.getTotalPrice().getDetailCurrencyPrice().getTotal().getDecimal();
    }

    private List<SeatPreferences> buildSeats(AirShoppingRS.Sequence.AirlineOffers.Offer offer) {
        ArrayList<SeatPreferences> result = new ArrayList<SeatPreferences>();
        for (PTCQuantityPricedType ptcPriced : offer.getParameters().getPTCPricedList()) {
            DictionaryReference<com.gridnine.xtrip.common.model.booking.PassengerType> pt = FarelogixHelper.resolveNativeCode(com.gridnine.xtrip.common.model.booking.PassengerType.class, ptcPriced.getPriced().getString());
            if (pt == null) continue;
            SeatPreferences sp = new SeatPreferences();
            sp.setPassengerType(pt);
            sp.setCount(ptcPriced.getPriced().getQuantity().intValue());
            result.add(sp);
        }
        return result;
    }

    private String checkPassengerTypes(List<SeatPreferences> flightSeats) {
        Map searchPassengers;
        List searchSeats = this.fsp.getSeats();
        Map flightPassengers = GDSHelper.getPassengerTypesMap(flightSeats);
        if (!CollectionUtil.equals((Map)flightPassengers, (Map)(searchPassengers = GDSHelper.getPassengerTypesMap((List)searchSeats)), (boolean)true)) {
            return String.format("different passengers: search (%s) != flight (%s)", this.toString(searchPassengers), this.toString(flightPassengers));
        }
        return null;
    }

    private String toString(Map<DictionaryReference<com.gridnine.xtrip.common.model.booking.PassengerType>, Integer> passengers) {
        return passengers.entrySet().stream().map(entry -> String.format("%s %s", entry.getValue(), ((DictionaryReference)entry.getKey()).getCode())).collect(Collectors.joining(", "));
    }

    private void fillAirlineOfferMaps(List<AirShoppingRS.Sequence.AirlineOffers> airlineOffersList) {
        for (AirShoppingRS.Sequence.AirlineOffers airlineOffers : airlineOffersList) {
            for (AirShoppingRS.Sequence.AirlineOffers.Offer offer : airlineOffers.getOfferList()) {
                List<SeatPreferences> seatPreferences = this.buildSeats(offer);
                String mes = this.checkPassengerTypes(seatPreferences);
                if (TextUtil.nonBlank((String)mes)) {
                    Collection messages = CollectionUtil.getOrAddList(this.traceFlights, (Object)((Object)FilterFlight.INVALID_PASSENGER_TYPES));
                    messages.add(String.format("AirlineOffer %s excluded: %s", offer.getOfferID(), mes));
                    continue;
                }
                List flightRefList = offer.getFlightsOverview().getFlightRefList();
                if (CollectionUtil.isEmpty((Collection)flightRefList)) {
                    throw Xeption.forDeveloper((String)"unsupported case for offer {0}: no flights in FlightsOverview", (Object[])new Object[]{offer.getOfferID()});
                }
                if (flightRefList.size() == this.fsp.getRoute().size()) {
                    this.completedOffers.add(offer);
                    continue;
                }
                if (flightRefList.size() > 1) {
                    throw Xeption.forDeveloper((String)"unsupported case for offer {0}: flights number = {1} in FlightsOverview", (Object[])new Object[]{offer.getOfferID(), flightRefList.size()});
                }
                String flightRef = ((AirShoppingRS.Sequence.AirlineOffers.Offer.FlightsOverview.FlightRef)flightRefList.get(0)).getString();
                List offers = (List)CollectionUtil.getFromMap(this.offersByFlightRef, (Object)flightRef, ArrayList::new);
                offers.add(offer);
            }
        }
    }

    private void fillPassengerTypes(AirShoppingRS.Sequence.DataLists dataLists) {
        for (PassengerType passenger : dataLists.getPassengerList().getPassengerList()) {
            DictionaryReference<com.gridnine.xtrip.common.model.booking.PassengerType> pt = FarelogixHelper.resolveNativeCode(com.gridnine.xtrip.common.model.booking.PassengerType.class, passenger.getPTC());
            if (pt == null) continue;
            this.passengerTypes.put(passenger.getPassengerID(), pt);
        }
    }

    private void fillFareRefKeys(AirShopResMetadataType.Other metadata) {
        metadata.getOtherMetadataList().stream().map(AirShopResMetadataType.Other.OtherMetadata::getPriceMetadatas).filter(Objects::nonNull).flatMap(priceMetaData -> priceMetaData.getPriceMetadataList().stream()).filter(Objects::nonNull).forEach(priceMetadata -> {
            String metadataKey = priceMetadata.getMetadataKey();
            for (AugPointType augPoint : priceMetadata.getAugmentationPoint().getAugPointList()) {
                String fareRefKey = augPoint.getFareRefKey().getFareRefKey();
                if (TextUtil.isBlank((String)fareRefKey)) continue;
                this.fareRefKeys.put(metadataKey, fareRefKey);
                break;
            }
        });
    }

    private void fillFareListGroups(AirShoppingRS.Sequence.DataLists dataLists) {
        dataLists.getFareList().getFareGroupList().forEach(fg -> this.fareListGroups.put(fg.getDataListObjAttrGroup().getListKey(), (FareList.FareGroup)fg));
    }

    private void fillFlightsMap(AirShoppingRS.Sequence.DataLists dataLists) {
        dataLists.getFlightList().getFlightList().forEach(fl -> this.flightsMap.put(fl.getFlightKey(), (AirShoppingRS.Sequence.DataLists.FlightList.Flight)fl));
    }

    private void fillFlightSegmentsMap(AirShoppingRS.Sequence.DataLists dataLists) {
        dataLists.getFlightSegmentList().getFlightSegmentList().forEach(seg -> this.flightSegmentsMap.put(seg.getSegmentKey(), (ListOfFlightSegmentType)seg));
    }

    private void fillPriceClassMaps() {
        AirShoppingRS.Sequence.DataLists.PriceClassList priceClassList = this.response.getSequence().getDataLists().getPriceClassList();
        if (priceClassList == null) {
            return;
        }
        if (this.response.getSequence().getMetadata().getShopping() != null) {
            for (Offer.OfferInner offerMeta : this.response.getSequence().getMetadata().getShopping().getOffer().getOfferList()) {
                if (offerMeta.getOfferInstructionMetadatas() == null) continue;
                for (OfferInstructionMetadata offerInstructionMeta : offerMeta.getOfferInstructionMetadatas().getOfferInstructionMetadataList()) {
                    String priceClassId = offerInstructionMeta.getRefs();
                    List associations = offerInstructionMeta.getAugmentationPoint().getAugPointList().stream().flatMap(augPoint -> augPoint.getCombinability().getAssociationList().stream()).filter(assoc -> "PriceClass".equals(assoc.getType())).flatMap(assoc -> assoc.getReferenceValueList().stream()).collect(Collectors.toList());
                    this.priceClassAssociations.put(priceClassId, associations);
                }
            }
        }
        priceClassList.getPriceClassList().forEach(pc -> {
            String priceClassId = pc.getPriceClassID();
            this.gdsPriceClasses.put(priceClassId, (PriceClassType)pc);
            this.priceClassAssociations.putIfAbsent(priceClassId, Collections.emptyList());
        });
    }

    private Flight buildFlight(List<AirShoppingRS.Sequence.AirlineOffers.Offer> offers) throws Exception {
        Flight result = new Flight();
        HashSet<String> fareCodes = new HashSet<String>();
        String owner = null;
        for (AirShoppingRS.Sequence.AirlineOffers.Offer offer : offers) {
            if (owner == null) {
                owner = offer.getOwner();
            }
            FlightSegmentTariff fst = new FlightSegmentTariff();
            result.getSegmentTariffs().add(fst);
            for (AirShoppingRS.Sequence.AirlineOffers.Offer.FlightsOverview.FlightRef flightRef : offer.getFlightsOverview().getFlightRefList()) {
                String flightId = flightRef.getString();
                AirShoppingRS.Sequence.DataLists.FlightList.Flight flight = this.flightsMap.get(flightId);
                boolean isStarting = true;
                for (String segmentRef : FarelogixFlightsBuilder.toArray(flight.getSegmentReferences().getString())) {
                    ListOfFlightSegmentType gdsSeg = this.flightSegmentsMap.get(segmentRef);
                    if (gdsSeg == null) {
                        throw Xeption.forDeveloper((String)"can't find Flight segment {0}", (Object[])new Object[]{segmentRef});
                    }
                    fst.getSegments().add(this.buildFlightSegment(gdsSeg, isStarting, offer.getOwner()));
                    isStarting = false;
                }
            }
            this.fillFareInfo(result, fst, offer, fareCodes);
        }
        result.setEticket(true);
        result.setLatinRegistration(true);
        result.setCarrier(FarelogixHelper.resolveNativeCode(Airline.class, owner));
        result.setFlightFaresSearchDisabled(true);
        NamedValueHelper.setValueForName((String)"farelogix-fare-code", (String)FarelogixHelper.buildFareCode2CustomProperty(fareCodes), (Collection)result.getCustomProperties());
        NamedValueHelper.setValueForName((String)"debug-offer-ids", (String)this.getOffersInfo(offers), (Collection)result.getCustomProperties());
        result.getSeats().addAll(this.fsp.getSeats());
        return result;
    }

    private String getOffersInfo(List<AirShoppingRS.Sequence.AirlineOffers.Offer> offers) {
        return offers.stream().map(OfferType::getOfferID).collect(Collectors.joining("/"));
    }

    private FlightSegment buildFlightSegment(ListOfFlightSegmentType gdsSeg, boolean isStarting, String source) {
        FlightSegment result = new FlightSegment();
        result.setGds(GdsName.FARELOGIX);
        result.setGdsId(gdsSeg.getSegmentKey());
        result.getCustomProperties().add(NamedValueHelper.namedValue((String)"farelogix-source", (String)source));
        if (gdsSeg.getEquipment() != null) {
            result.getCustomProperties().add(NamedValueHelper.namedValue((String)"farelogix-equipment-name", (String)gdsSeg.getEquipment().getName()));
        }
        result.setAirline(FarelogixHelper.resolveNativeCode(Airline.class, gdsSeg.getMarketingCarrier().getAirlineID().getString()));
        result.setFlightNumber(gdsSeg.getMarketingCarrier().getFlightNumber().getString());
        if (gdsSeg.getOperatingCarrier() != null && gdsSeg.getOperatingCarrier().getAirlineID() != null) {
            result.setOperatingAirline(FarelogixHelper.resolveNativeCode(Airline.class, gdsSeg.getOperatingCarrier().getAirlineID().getString()));
        } else {
            result.setOperatingAirline(result.getAirline());
        }
        result.setLocationBegin(FarelogixHelper.resolveNativeCode(GeoLocation.class, gdsSeg.getDeparture().getAirportCodeString()));
        if (gdsSeg.getDeparture().getTerminal() != null) {
            result.setTerminalBegin(gdsSeg.getDeparture().getTerminal().getName());
        }
        result.setLocationEnd(FarelogixHelper.resolveNativeCode(GeoLocation.class, gdsSeg.getArrival().getAirportCodeString()));
        if (gdsSeg.getArrival().getTerminal() != null) {
            result.setTerminalEnd(gdsSeg.getArrival().getTerminal().getName());
        }
        result.setDateBegin(FarelogixHelper.calcDateTime(gdsSeg.getDeparture().getDate(), gdsSeg.getDeparture().getTime()));
        result.setDateEnd(FarelogixHelper.calcDateTime(gdsSeg.getArrival().getDate(), gdsSeg.getArrival().getTime()));
        result.setBoard(FarelogixHelper.resolveNativeCode(Aircraft.class, gdsSeg.getEquipment().getAircraftCode().getString()));
        Integer travelDuration = GdsDictHelper.getTravelDuration((DictionaryReference)result.getLocationBegin(), (DictionaryReference)result.getLocationEnd(), (Date)result.getDateBegin(), (Date)result.getDateEnd());
        if (travelDuration == null) {
            this.log.error("Travel duration is null");
        }
        result.setTravelDuration(MiscUtil.guarded((Integer)travelDuration).intValue());
        result.setStarting(isStarting);
        return result;
    }

    private void fillFareInfo(Flight flight, FlightSegmentTariff fst, AirShoppingRS.Sequence.AirlineOffers.Offer offer, Set<String> fareCodes) throws Exception {
        flight.setGdsCurrencyCode(null);
        for (OfferItemType offerItem : offer.getOfferItemList()) {
            DictionaryReference<com.gridnine.xtrip.common.model.booking.PassengerType> passengerType = this.getPassengerType(offerItem);
            List fareDetailList = offerItem.getFareDetailList();
            if (fareDetailList.size() != 1) {
                throw Xeption.forDeveloper((String)"OfferItem {0} has {1} FareDetail", (Object[])new Object[]{offerItem.getOfferItemID(), fareDetailList.size()});
            }
            FareDetailType fareDetail = (FareDetailType)fareDetailList.get(0);
            Map<String, Integer> numberOfDecimalsMap = FarelogixHelper.findMyNumberOfDecimalsMap(fareDetail);
            CurrencyAmountOptType baseAmount = fareDetail.getPrice().getBaseAmount();
            if (TextUtil.isBlank((String)flight.getGdsCurrencyCode())) {
                flight.setGdsCurrencyCode(baseAmount.getCode());
            } else if (!MiscUtil.equals((Object)flight.getGdsCurrencyCode(), (Object)baseAmount.getCode())) {
                throw Xeption.forDeveloper((String)"many currency codes are not supported: {0}, {1}", (Object[])new Object[]{flight.getGdsCurrencyCode(), baseAmount.getCode()});
            }
            FlightFare fare = new FlightFare();
            fare.setPassengerType(passengerType);
            fare.setEquivalentAmount(FarelogixHelper.applyNumberOfDecimals(baseAmount, numberOfDecimalsMap));
            fare.setBaseAmount(MoneyHelper.moneyOrNull((BigDecimal)fare.getEquivalentAmount(), (String)baseAmount.getCode()));
            fare.setSegmentTariff(fst);
            flight.getFares().add(fare);
            TaxDetailType taxes = fareDetail.getPrice().getTaxes();
            if (taxes != null && taxes.getBreakdown() != null) {
                for (TaxDetailType.Breakdown.Tax gdsTax : taxes.getBreakdown().getTaxList()) {
                    FlightTax tax = new FlightTax();
                    tax.setPassengerType(passengerType);
                    tax.setCode(gdsTax.getTaxCode());
                    tax.setEquivalentAmount(FarelogixHelper.applyNumberOfDecimals(gdsTax.getAmount(), numberOfDecimalsMap));
                    tax.setSegmentTariff(fst);
                    flight.getTaxes().add(tax);
                }
            }
            for (FareComponentType fareComponent : fareDetail.getFareComponentList()) {
                FareComponentType.FareBasis gdsFareBasis = fareComponent.getFareBasis();
                String fareGroupKey = gdsFareBasis.getFareBasisCode().getRefs();
                FareList.FareGroup fareGroup = this.fareListGroups.get(fareGroupKey);
                String fareBasis = gdsFareBasis.getFareBasisCode().getCode();
                String fareCode = fareGroup.getFareFareCode().getFareCode();
                fareCodes.add(fareCode);
                String fareType = FarelogixHelper.getFareTypeByCode(fareCode);
                String priceMetadataRef = fareGroup.getDataListObjAttrGroup().getRefs();
                String fareRefKey = this.fareRefKeys.get(priceMetadataRef);
                String priceClassRef = fareComponent.getPriceClassRef();
                String[] cabinTypeCodes = FarelogixFlightsBuilder.toArray(gdsFareBasis.getCabinTypeCabinTypeCode());
                String[] rbdCodes = FarelogixFlightsBuilder.toArray(gdsFareBasis.getRBD());
                String[] gdsSegRefs = FarelogixFlightsBuilder.toArray(fareComponent.getSegmentRefs().getString());
                for (int i = 0; i < gdsSegRefs.length; ++i) {
                    FlightSegment fs = Objects.requireNonNull(this.findFlightSegment(flight, gdsSegRefs[i]));
                    fs.setServiceClass(FarelogixHelper.convertServiceClassFromGds(cabinTypeCodes[i]));
                    fs.setBookingClass(rbdCodes[i]);
                    NamedValueHelper.setValueForName((String)"farelogix-fareDetail-priceClass", (String)priceClassRef, (Collection)fs.getCustomProperties());
                    PriceClassType priceClass = this.gdsPriceClasses.get(priceClassRef);
                    if (priceClass != null) {
                        NamedValueHelper.setValueForName((String)"farelogix-fareDetail-priceClass-code", (String)priceClass.getCode(), (Collection)fs.getCustomProperties());
                        NamedValueHelper.setValueForName((String)"farelogix-fareDetail-priceClass-name", (String)priceClass.getName(), (Collection)fs.getCustomProperties());
                    }
                    FareInfo fi = new FareInfo();
                    fi.setPassengerType(passengerType);
                    fi.setFareBasis(fareBasis);
                    fi.setRemarksSearchContext(FarelogixHelper.buildRemarksSearchContext(fs.getGdsId(), this.toFareBasisCode(fareBasis, priceClass), fareRefKey, fareType, null));
                    fs.getFareInfos().add(fi);
                }
            }
        }
    }

    private FareBasisCode toFareBasisCode(String fareBasis, PriceClassType priceClass) {
        FareBasisCode result = new FareBasisCode();
        result.setValue(fareBasis);
        if (priceClass != null) {
            result.setCode(priceClass.getCode());
            result.setPriceClass(priceClass.getName());
        }
        return result;
    }

    private DictionaryReference<com.gridnine.xtrip.common.model.booking.PassengerType> getPassengerType(OfferItemType offerItem) {
        for (OfferItemType.Service service : offerItem.getServiceList()) {
            for (String passengerRef : FarelogixFlightsBuilder.toArray(service.getPassengerRefs())) {
                if (!TextUtil.nonBlank((String)passengerRef)) continue;
                return this.passengerTypes.get(passengerRef);
            }
        }
        return null;
    }

    private FlightSegment findFlightSegment(Flight flight, String gdsSegRef) {
        for (FlightSegment fs : FlightHelper.getSegments((Flight)flight)) {
            if (!gdsSegRef.equals(fs.getGdsId())) continue;
            return fs;
        }
        return null;
    }

    private void saveRulesTraces() {
        if (!this.traceFlights.isEmpty() && this.isSaveRulesTraces) {
            for (Map.Entry<FilterFlight, Collection<String>> item : this.traceFlights.entrySet()) {
                FilterFlight ff = item.getKey();
                Collection<String> messages = item.getValue();
                this.builder.traceFlightLogic((BaseEntity)this.createFakeFlight(ff), MessageType.MESSAGE, String.format("%s messages:\n%s", messages.size(), TextUtil.join((String)"\n", messages)));
            }
        }
    }

    private static String[] toArray(String refs) {
        return refs.split(" ");
    }

    private Flight createFakeFlight(FilterFlight ff) {
        Flight result = new Flight();
        FlightSegmentTariff fst = new FlightSegmentTariff();
        FlightSegment fs = new FlightSegment();
        fs.setFlightNumber(ff.name());
        fs.setAirline((DictionaryReference)new AirlineReference(""));
        fst.getSegments().add(fs);
        result.getSegmentTariffs().add(fst);
        return result;
    }

    private static enum FilterFlight {
        INVALID_SEGMENTS,
        INVALID_PRICE_CLASSES,
        INVALID_PASSENGER_TYPES,
        EXCEEDED_LIMIT;

    }
}

