/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.searchFlights;

import com.gridnine.farelogix.ndc.AirShoppingRS;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.ibus.searchFlights.FarelogixSearchFlightsResponseParser;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.test.GDSTestBase;
import com.gridnine.xtrip.server.gds.test.TestFlightSearchParametersBuilder;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jibx.JiBXHelper;
import com.gridnine.xtrip.server.model.test.XModelAssert;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class FarelogixSearchFlightsResponseParserTest
extends GDSTestBase {
    @Test
    public void testMowBerMow() throws Throwable {
        String scenario = "MOW-BER-MOW";
        String responseFile = scenario + ".xml";
        String resultFile = scenario + "_result.xml";
        FarelogixSearchFlightsResponseParser processor = new FarelogixSearchFlightsResponseParser();
        AirShoppingRS resp = (AirShoppingRS)JiBXHelper.read(AirShoppingRS.class, (InputStream)((Object)((Object)this)).getClass().getResourceAsStream(responseFile));
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)new TestFlightSearchParametersBuilder().serviceClass(ClassOfService.ECONOMY).route().end().route().end().seats(DictHelper.getAdultPassengerType(), 2).seats(DictHelper.getChildPassengerType(), 1).seats(DictHelper.getInfantPassengerType(), 1).getEntity());
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE, (Object)resp);
        processor.process(ctx);
        List flights = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Assert.assertEquals((long)207L, (long)flights.size());
        this.assertFlights(flights, resultFile);
    }

    @Test
    public void testVip51907() throws Throwable {
        String scenario = "vip51907";
        String responseFile = scenario + ".xml";
        String resultFile = scenario + "_result.xml";
        FarelogixSearchFlightsResponseParser processor = new FarelogixSearchFlightsResponseParser();
        AirShoppingRS resp = (AirShoppingRS)JiBXHelper.read(AirShoppingRS.class, (InputStream)((Object)((Object)this)).getClass().getResourceAsStream(responseFile));
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)new TestFlightSearchParametersBuilder().serviceClass(ClassOfService.ECONOMY).route().end().route().end().seats(DictHelper.getAdultPassengerType(), 1).getEntity());
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE, (Object)resp);
        processor.process(ctx);
        List flights = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Assert.assertEquals((long)10L, (long)flights.size());
        this.assertFlights(flights, resultFile);
    }

    @Test
    public void testMowMucMow() throws Throwable {
        String scenario = "MOW-MUC-MOW";
        String responseFile = scenario + ".xml";
        String resultFile = scenario + "_result.xml";
        FarelogixSearchFlightsResponseParser processor = new FarelogixSearchFlightsResponseParser();
        AirShoppingRS resp = (AirShoppingRS)JiBXHelper.read(AirShoppingRS.class, (InputStream)((Object)((Object)this)).getClass().getResourceAsStream(responseFile));
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)new TestFlightSearchParametersBuilder().serviceClass(ClassOfService.ECONOMY).route().end().route().end().seats(DictHelper.getAdultPassengerType(), 2).seats(DictHelper.getChildPassengerType(), 1).seats(DictHelper.getInfantPassengerType(), 1).getEntity());
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE, (Object)resp);
        processor.process(ctx);
        List flights = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Assert.assertEquals((long)202L, (long)flights.size());
        this.assertFlights(flights, resultFile);
    }

    @Test
    public void testMowLonMow() throws Throwable {
        String scenario = "MOW-LON-MOW";
        String responseFile = scenario + ".xml";
        String resultFile = scenario + "_result.xml";
        FarelogixSearchFlightsResponseParser processor = new FarelogixSearchFlightsResponseParser();
        AirShoppingRS resp = (AirShoppingRS)JiBXHelper.read(AirShoppingRS.class, (InputStream)((Object)((Object)this)).getClass().getResourceAsStream(responseFile));
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)new TestFlightSearchParametersBuilder().serviceClass(ClassOfService.ECONOMY).route().end().route().end().seats(DictHelper.getAdultPassengerType(), 2).seats(DictHelper.getChildPassengerType(), 1).seats(DictHelper.getInfantPassengerType(), 1).getEntity());
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE, (Object)resp);
        processor.process(ctx);
        List flights = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Assert.assertEquals((long)208L, (long)flights.size());
        this.assertFlights(flights, resultFile);
    }

    @Test
    public void testSkgAth() throws Throwable {
        String scenario = "SKG-ATH";
        String responseFile = scenario + ".xml";
        String resultFile = scenario + "_result.xml";
        FarelogixSearchFlightsResponseParser processor = new FarelogixSearchFlightsResponseParser();
        AirShoppingRS resp = (AirShoppingRS)JiBXHelper.read(AirShoppingRS.class, (InputStream)((Object)((Object)this)).getClass().getResourceAsStream(responseFile));
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)new TestFlightSearchParametersBuilder().serviceClass(ClassOfService.ECONOMY).route().end().seats(DictHelper.getAdultPassengerType(), 1).getEntity());
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE, (Object)resp);
        processor.process(ctx);
        List flights = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Assert.assertEquals((long)26L, (long)flights.size());
        this.assertFlights(flights, resultFile);
    }

    @Test
    public void testVip48718() throws Throwable {
        String scenario = "vip48718";
        String responseFile = scenario + ".xml";
        String resultFile = scenario + "_result.xml";
        FarelogixSearchFlightsResponseParser processor = new FarelogixSearchFlightsResponseParser();
        AirShoppingRS resp = (AirShoppingRS)JiBXHelper.read(AirShoppingRS.class, (InputStream)((Object)((Object)this)).getClass().getResourceAsStream(responseFile));
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)new TestFlightSearchParametersBuilder().serviceClass(ClassOfService.ECONOMY).route().end().seats(DictHelper.getAdultPassengerType(), 1).getEntity());
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE, (Object)resp);
        processor.process(ctx);
        List flights = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Assert.assertEquals((long)6L, (long)flights.size());
        this.assertFlights(flights, resultFile);
    }

    @Test
    public void testVip49922() throws Throwable {
        String scenario = "vip49922";
        String responseFile = scenario + ".xml";
        String resultFile = scenario + "_result.xml";
        FarelogixSearchFlightsResponseParser processor = new FarelogixSearchFlightsResponseParser();
        AirShoppingRS resp = (AirShoppingRS)JiBXHelper.read(AirShoppingRS.class, (InputStream)((Object)((Object)this)).getClass().getResourceAsStream(responseFile));
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)new TestFlightSearchParametersBuilder().route().end().route().end().serviceClass(ClassOfService.ECONOMY).seats(DictHelper.getAdultPassengerType(), 1).getEntity());
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE, (Object)resp);
        processor.process(ctx);
        List flights = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Assert.assertEquals((long)6L, (long)flights.size());
        this.assertFlights(flights, resultFile);
    }

    @Test
    public void testVip50166() throws Throwable {
        String scenario = "vip50166";
        String responseFile = scenario + ".xml";
        String resultFile = scenario + "_result.xml";
        FarelogixSearchFlightsResponseParser processor = new FarelogixSearchFlightsResponseParser();
        AirShoppingRS resp = (AirShoppingRS)JiBXHelper.read(AirShoppingRS.class, (InputStream)((Object)((Object)this)).getClass().getResourceAsStream(responseFile));
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)new TestFlightSearchParametersBuilder().serviceClass(ClassOfService.ECONOMY).route().end().seats(DictHelper.getAdultPassengerType(), 1).getEntity());
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE, (Object)resp);
        processor.process(ctx);
        List flights = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Assert.assertEquals((long)54L, (long)flights.size());
        this.assertFlights(flights, resultFile);
    }

    @Test
    public void testVip50166_RT() throws Throwable {
        String scenario = "vip50166-RT";
        String responseFile = scenario + ".xml";
        String resultFile = scenario + "_result.xml";
        FarelogixSearchFlightsResponseParser processor = new FarelogixSearchFlightsResponseParser();
        AirShoppingRS resp = (AirShoppingRS)JiBXHelper.read(AirShoppingRS.class, (InputStream)((Object)((Object)this)).getClass().getResourceAsStream(responseFile));
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)new TestFlightSearchParametersBuilder().serviceClass(ClassOfService.ECONOMY).route().end().route().end().seats(DictHelper.getAdultPassengerType(), 1).getEntity());
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE, (Object)resp);
        processor.process(ctx);
        List flights = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Assert.assertEquals((long)201L, (long)flights.size());
        this.assertFlights(flights, resultFile);
    }

    @Test
    public void testVip50374() throws Throwable {
        String scenario = "vip50374";
        String responseFile = scenario + ".xml";
        String resultFile = scenario + "_result.xml";
        FarelogixSearchFlightsResponseParser processor = new FarelogixSearchFlightsResponseParser();
        AirShoppingRS resp = (AirShoppingRS)JiBXHelper.read(AirShoppingRS.class, (InputStream)((Object)((Object)this)).getClass().getResourceAsStream(responseFile));
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)new TestFlightSearchParametersBuilder().serviceClass(ClassOfService.ECONOMY).route().end().route().end().seats(DictHelper.getAdultPassengerType(), 2).seats(DictHelper.getChildPassengerType(), 1).seats(DictHelper.getInfantPassengerType(), 1).getEntity());
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE, (Object)resp);
        processor.process(ctx);
        List flights = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Assert.assertEquals((long)249L, (long)flights.size());
        this.assertFlights(flights, resultFile);
    }

    private boolean sameSeats(List<SeatPreferences> seats1, List<SeatPreferences> seats2) {
        Map map1 = GDSHelper.getPassengerTypesMap(seats1);
        Map map2 = GDSHelper.getPassengerTypesMap(seats2);
        return CollectionUtil.equals((Map)map1, (Map)map2, (boolean)true);
    }

    protected List<URL> getDictionariesSetupFiles() throws Exception {
        List result = super.getDictionariesSetupFiles();
        result.add(((Object)((Object)this)).getClass().getResource("dictionaries.xml"));
        return result;
    }

    protected void writeResult(List<? extends XSerializable> objects, String fileName) throws Exception {
        String path = ((Object)((Object)this)).getClass().getResource("").getPath().replace("/classes/", "/source-test/");
        path = URLDecoder.decode(path, "utf-8");
        File file = new File(path + fileName);
        try (FileOutputStream fos = new FileOutputStream(file);){
            XUtil.serialize(objects, (OutputStream)fos);
        }
    }

    private void assertFlights(List<Flight> flights, String resultFile) throws Exception {
        List expectedList = this.loadXSerializableList(resultFile);
        Assert.assertEquals((long)expectedList.size(), (long)flights.size());
        for (int i = 0; i < flights.size(); ++i) {
            Flight expected = (Flight)expectedList.get(i);
            Flight actual = flights.get(i);
            this.clearSomeFields(expected);
            this.clearSomeFields(actual);
            actual.setInitDate(expected.getInitDate());
            XModelAssert.assertEntityEquals((String)String.format("Flight[%d]", i), (BaseEntity)expected, (BaseEntity)actual);
        }
    }

    private void clearSomeFields(Flight flight) {
        NamedValueHelper.setValueForName((String)"debug-offer-ids", null, (Collection)flight.getCustomProperties());
        FlightHelper.getSegments((Flight)flight).forEach(seg -> {
            seg.setAvailableSeats(null);
            seg.setGdsId(null);
            seg.getFareInfos().forEach(fi -> fi.setRemarksSearchContext(null));
            NamedValueHelper.setValueForName((String)"farelogix-fareDetail-priceClass", null, (Collection)seg.getCustomProperties());
        });
    }
}

