/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.selectFlight;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.farelogix.model.FarelogixGdsAccount;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FarelogixHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.model.FlightPriceRQ;
import com.gridnine.xtrip.server.gds.farelogix.model.common.PricingInfo;
import com.gridnine.xtrip.server.gds.farelogix.model.common.TravelerIDs;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FarelogixSelectFlightRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_REQUEST, (Object)this.buildRequest(flight, (FarelogixGdsAccount)accountCtr.getEntity()));
    }

    private FlightPriceRQ buildRequest(Flight flight, FarelogixGdsAccount gdsAccount) throws Exception {
        FlightPriceRQ result = new FlightPriceRQ();
        int trIndex = 1;
        int infIndex = 1;
        for (SeatPreferences seat : GDSHelper.sortByPassengerType((List)flight.getSeats())) {
            String paxType = FarelogixHelper.getNativeCode(seat.getPassengerType());
            boolean isInfant = DictHelper.isInfantPassengerTypeCategory((DictionaryReference)seat.getPassengerType());
            for (int i = 0; i < seat.getCount(); ++i) {
                TravelerIDs tid = new TravelerIDs();
                String associationInd = !isInfant ? String.valueOf(trIndex++) : String.valueOf(infIndex++).concat(".1");
                tid.setAssociationID("T".concat(associationInd));
                tid.setPaxType(paxType);
                result.getTravelerIDs().add(tid);
            }
        }
        result.getOriginDestinations().addAll(this.buildOriginDestinations(flight));
        PricingInfo pi = new PricingInfo();
        pi.setBestPricing(Boolean.FALSE);
        pi.setRequestOptions(Boolean.FALSE);
        pi.setRestrictions(FarelogixHelper.buildStandardRestrictions());
        pi.setPrivateFares(FarelogixHelper.buildStandardPrivateFares(gdsAccount.getPcc()));
        pi.getSegmentIDRefs().addAll(this.buildSegmentIDRefs(result.getOriginDestinations()));
        pi.setFareType(FarelogixHelper.getFareTypeByCode(NamedValueHelper.getValueForName((String)"farelogix-fare-code", (Collection)flight.getCustomProperties())));
        result.getPricingInfoList().add(pi);
        return result;
    }

    private List<FlightPriceRQ.OriginDestination> buildOriginDestinations(Flight flight) throws Exception {
        ArrayList<FlightPriceRQ.OriginDestination> result = new ArrayList<FlightPriceRQ.OriginDestination>();
        FlightPriceRQ.OriginDestination od = null;
        int i = 1;
        for (FlightSegment fs : FlightHelper.getSegments((Flight)flight)) {
            if (fs.isStarting() || od == null) {
                od = new FlightPriceRQ.OriginDestination();
                result.add(od);
            }
            od.getFlights().add(this.buildGdsFlight(fs, i++));
        }
        return result;
    }

    private FlightPriceRQ.Flight buildGdsFlight(FlightSegment fs, int segmentInd) throws Exception {
        FlightPriceRQ.Flight result = new FlightPriceRQ.Flight();
        String source = NamedValueHelper.getValueForName((String)"farelogix-source", (Collection)fs.getCustomProperties());
        result.setSource(source);
        result.setFlightRefKey("F".concat(String.valueOf(segmentInd)));
        result.setAssociationID(result.getFlightRefKey());
        result.setAirlineCode(FarelogixHelper.getNativeCode(fs.getAirline()));
        result.setFlightNumber(fs.getFlightNumber());
        result.setClassOfService(fs.getBookingClass());
        result.setDeparture(FarelogixHelper.buildFlightEvent((DictionaryReference<GeoLocation>)fs.getLocationBegin(), fs.getDateBegin()));
        result.setArrival(FarelogixHelper.buildFlightEvent((DictionaryReference<GeoLocation>)fs.getLocationEnd(), fs.getDateEnd()));
        if (fs.getBoard() != null) {
            String equipmentName = NamedValueHelper.getValueForName((String)"farelogix-equipment-name", (Collection)fs.getCustomProperties());
            result.setEquipment(FarelogixHelper.buildEquipment((DictionaryReference<Aircraft>)fs.getBoard(), equipmentName));
        }
        result.setFareRefKey(FarelogixHelper.getFareRefKey(fs));
        result.setPriceClass(FarelogixHelper.buildPriceClass(fs));
        return result;
    }

    private List<PricingInfo.SegmentIDRef> buildSegmentIDRefs(List<FlightPriceRQ.OriginDestination> originDestinations) {
        ArrayList<PricingInfo.SegmentIDRef> result = new ArrayList<PricingInfo.SegmentIDRef>();
        originDestinations.forEach(od -> od.getFlights().forEach(fl -> result.add(this.buildSegmentIDRef((FlightPriceRQ.Flight)fl))));
        return result;
    }

    private PricingInfo.SegmentIDRef buildSegmentIDRef(FlightPriceRQ.Flight fl) {
        PricingInfo.SegmentIDRef result = new PricingInfo.SegmentIDRef();
        result.setValue(fl.getFlightRefKey());
        result.setFareRefKey(fl.getFareRefKey());
        if (fl.getPriceClass() != null) {
            result.setPriceClassCode(fl.getPriceClass().getCode());
            result.setPriceClassName(fl.getPriceClass().getName());
        }
        fl.setFareRefKey(null);
        fl.setPriceClass(null);
        return result;
    }
}

