/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.selectFlight;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FarelogixHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.model.FlightPriceRS;
import com.gridnine.xtrip.server.gds.farelogix.model.common.CurrencyInfo;
import com.gridnine.xtrip.server.gds.farelogix.model.common.FareGroup;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class FarelogixSelectFlightResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FlightPriceRS response = (FlightPriceRS)ctx.getMandatoryObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_RESPONSE);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        this.updateFlight(flight, response, ctx);
    }

    private void updateFlight(Flight flight, FlightPriceRS response, MessageContext ctx) throws Exception {
        flight.getFares().clear();
        flight.getTaxes().clear();
        flight.setGdsCurrencyCode(null);
        flight.setPqTimeLimit(this.getPqTimeLimitFromResponse(response, ctx));
        List flightSegments = FlightHelper.getSegments((Flight)flight);
        flight.getSegmentTariffs().clear();
        for (FlightSegment fs : flightSegments) {
            fs.getFareInfos().clear();
        }
        String fareType = null;
        for (FlightPriceRS.FareGroupRS fg : response.getFareGroups()) {
            if (TextUtil.isBlank((String)flight.getGdsCurrencyCode())) {
                flight.setGdsCurrencyCode(fg.getCurrencyInfo().getCurrencyCode());
            }
            if (fareType == null) {
                fareType = fg.getFareType();
            }
            if (TextUtil.nonBlank((String)fg.getValidatingCarrier())) {
                flight.setCarrier(FarelogixHelper.resolveNativeCode(Airline.class, fg.getValidatingCarrier()));
            }
            CurrencyInfo currencyInfo = fg.getCurrencyInfo();
            String source = fg.getSource();
            for (FareGroup.TravelerGroup tg : fg.getTravelerGroups()) {
                if (flight.getSegmentTariffs().isEmpty()) {
                    String calcLine = tg.getFareRules().getFareCalculation();
                    List fstList = GDSHelper.buildFlightSegmentTariffs((List)flightSegments, (String)calcLine);
                    flight.getSegmentTariffs().addAll(fstList);
                }
                DictionaryReference<PassengerType> passengerType = FarelogixHelper.getDictReference(PassengerType.class, tg.getTypeRequested());
                flight.getFares().add(this.createFlightFare(passengerType, tg.getPrice().getBaseFare().getAmount(), currencyInfo));
                for (FareGroup.Tax tax : tg.getPrice().getTaxes().getTaxes()) {
                    flight.getTaxes().add(this.createTax(tax, passengerType, currencyInfo));
                }
                for (FareGroup.FareInfo gdsFi : tg.getFareRules().getFareInfos()) {
                    this.addFareInfo(flight, gdsFi, passengerType, source);
                }
            }
            FlightHelper.getSegments((Flight)flight).forEach(seg -> NamedValueHelper.setValueForName((String)"farelogix-source", (String)source, (Collection)seg.getCustomProperties()));
        }
        flight.getCustomProperties().add(NamedValueHelper.namedValue((String)"farelogix-fare-type", fareType));
    }

    private Date getPqTimeLimitFromResponse(FlightPriceRS response, MessageContext ctx) {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        Pcc pcc = PccHelper.getTicketingPcc((GDSParameters)gdsParameters, (EntityReference)salesContext.getSalesPoint(), (GdsName)GdsName.FARELOGIX);
        for (FlightPriceRS.FareGroupRS fg : response.getFareGroups()) {
            for (FareGroup.TravelerGroup travelerGroup : fg.getTravelerGroups()) {
                if (travelerGroup.getFareRules() == null || travelerGroup.getFareRules().getTicketByDate() == null) continue;
                FareGroup.TicketByDate ticketByDate = travelerGroup.getFareRules().getTicketByDate();
                Date parsed = this.getDate(ticketByDate.getDateValue(), ticketByDate.getTimeValue());
                return GDSHelper.convertTimelimitFromPcc((Date)parsed, (Pcc)pcc);
            }
        }
        return null;
    }

    private Date getDate(String date, String time) {
        if (time == null) {
            return FarelogixSelectFlightResponseParser.parseDate(date, "23:59");
        }
        return FarelogixSelectFlightResponseParser.parseDate(date, time);
    }

    public static Date parseDate(String date, String time) {
        return Date.from(LocalDate.parse(date, FarelogixHelper.DF).atTime(LocalTime.parse(time, FarelogixHelper.TF)).atZone(ZoneId.systemDefault()).toInstant());
    }

    private FlightFare createFlightFare(DictionaryReference<PassengerType> passengerType, BigDecimal amount, CurrencyInfo currencyInfo) {
        FlightFare result = new FlightFare();
        result.setPassengerType(passengerType);
        result.setEquivalentAmount(FarelogixHelper.applyNumberOfDecimals(amount, currencyInfo));
        result.setBaseAmount(MoneyHelper.buildMoney((BigDecimal)result.getEquivalentAmount(), (String)currencyInfo.getCurrencyCode()));
        return result;
    }

    private FlightTax createTax(FareGroup.Tax gdsTax, DictionaryReference<PassengerType> passengerType, CurrencyInfo currencyInfo) {
        FlightTax result = new FlightTax();
        result.setPassengerType(passengerType);
        result.setEquivalentAmount(FarelogixHelper.applyNumberOfDecimals(gdsTax.getAmount(), currencyInfo));
        result.setBaseAmount(MoneyHelper.buildMoney((BigDecimal)result.getEquivalentAmount(), (String)currencyInfo.getCurrencyCode()));
        result.setCode(gdsTax.getDesignator());
        return result;
    }

    private void addFareInfo(Flight flight, FareGroup.FareInfo gdsFi, DictionaryReference<PassengerType> passengerType, String source) throws Exception {
        for (FareGroup.RelatedSegment relatedSegment : gdsFi.getRelatedSegments()) {
            String segmentIDRef = relatedSegment.getSegmentIDRef();
            FlightSegment fs = this.findFlightSegment(flight, segmentIDRef);
            if (fs == null) {
                throw Xeption.forDeveloper((String)"can't find flightSegment for ref={0}", (Object[])new Object[]{segmentIDRef});
            }
            FareInfo fi = new FareInfo();
            fi.setPassengerType(passengerType);
            fi.setFareBasis(gdsFi.getFareBasisCode().getValue());
            fi.setLuggageInfo(AirProductHelper.parseLuggageInfo((String)relatedSegment.getBaggageAllowance()));
            fi.setRemarksSearchContext(FarelogixHelper.buildRemarksSearchContext(fs.getGdsId(), gdsFi.getFareBasisCode(), gdsFi.getFareRefKey(), gdsFi.getFareType(), source));
            fs.getFareInfos().add(fi);
        }
    }

    private FlightSegment findFlightSegment(Flight flight, String segmentIDRef) {
        if (TextUtil.isBlank((String)segmentIDRef)) {
            return null;
        }
        int i = 0;
        for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
            for (FlightSegment fs : fst.getSegments()) {
                if (!segmentIDRef.equals(String.valueOf(++i))) continue;
                return fs;
            }
        }
        return null;
    }
}

