/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.sendDocoDoca;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FarelogixHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.model.PNRCreateRQ;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class FarelogixAddApisRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_REQUEST, (Object)this.buildRequest(reservation));
    }

    private PNRCreateRQ buildRequest(Reservation reservation) {
        PNRCreateRQ result = new PNRCreateRQ();
        result.setRecordLocator(FarelogixHelper.getRecordLocator(reservation));
        PNRCreateRQ.EndTransaction et = new PNRCreateRQ.EndTransaction();
        et.setIgnoreWarnings(true);
        et.setTransactionType(PNRCreateRQ.TransactionType.END_TRANSACTION_RETRIEVE_PNR);
        result.setEndTransaction(et);
        PNRCreateRQ.OtherPNRElements otherPnrElements = new PNRCreateRQ.OtherPNRElements();
        for (BaseProduct bp : reservation.getProducts()) {
            if (!(bp instanceof Product)) continue;
            Product p = (Product)bp;
            Traveller traveller = p.getTraveller();
            boolean isInfant = DictHelper.isInfantPassengerType((DictionaryReference)p.getPassengerType());
            otherPnrElements.getApisList().addAll(FarelogixHelper.buildDocoDocaApis(traveller, p.getGdsId(), isInfant));
        }
        result.setOtherPNRElements(otherPnrElements);
        return result;
    }
}

