/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.farelogix.ibus.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.gds.farelogix.ibus.FarelogixHelper;
import com.gridnine.xtrip.server.gds.farelogix.ibus.IBusGdsFarelogixContextKeys;
import com.gridnine.xtrip.server.gds.farelogix.model.TicketIssueRQ;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class FarelogixTicketIssueRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Fop fop = (Fop)ctx.getObject((Enum)IBusMidofficeContextKeys.FOP);
        ctx.putObject((Enum)IBusGdsFarelogixContextKeys.FARELOGIX_REQUEST, (Object)this.buildRequest(reservation, fop));
    }

    private TicketIssueRQ buildRequest(Reservation reservation, Fop fop) {
        TicketIssueRQ result = new TicketIssueRQ();
        result.setReValidate(true);
        result.setRecordLocator(FarelogixHelper.getRecordLocator(reservation));
        TicketIssueRQ.TravelerReq travellerReq = new TicketIssueRQ.TravelerReq();
        ArrayList<String> productGdsIds = new ArrayList<String>();
        List<TicketIssueRQ.TktFlight> tktFlights = null;
        for (Product product : AirProductHelper.getProducts((Reservation)reservation)) {
            TicketIssueRQ.TktTraveler tt = new TicketIssueRQ.TktTraveler();
            tt.setElementNumber(product.getGdsId());
            productGdsIds.add(product.getGdsId());
            if (tktFlights == null) {
                tktFlights = this.buildTktFlights(product);
            }
            tt.getTktFlights().addAll(tktFlights);
            travellerReq.getTktTravelers().add(tt);
        }
        result.setTravelerReq(travellerReq);
        result.setQualifierGroup(this.buildQualifierGroup(fop, productGdsIds));
        return result;
    }

    private List<TicketIssueRQ.TktFlight> buildTktFlights(Product product) {
        ArrayList<TicketIssueRQ.TktFlight> result = new ArrayList<TicketIssueRQ.TktFlight>();
        for (Segment segment : AirProductHelper.getSegments((Collection)product.getSegmentTariffs())) {
            TicketIssueRQ.TktFlight tf = new TicketIssueRQ.TktFlight();
            tf.setElementNumber(segment.getGdsId());
            result.add(tf);
        }
        return result;
    }

    private TicketIssueRQ.QualifierGroup buildQualifierGroup(Fop fop, List<String> productGdsIds) {
        PaymentType paymentType = fop == null ? PaymentType.INVOICE : fop.getType();
        TicketIssueRQ.QualifierGroup result = new TicketIssueRQ.QualifierGroup();
        TicketIssueRQ.FormOfPayment pf = new TicketIssueRQ.FormOfPayment();
        if (fop != null && fop.getCard() != null) {
            pf.getCreditCards().add(this.buildCredicCard(fop.getCard()));
        } else if (paymentType == PaymentType.CASH) {
            pf.getOthers().add("CASH");
        } else {
            pf.getOthers().add("CASH");
        }
        pf.getTravelers().addAll(this.buildTravelers(productGdsIds));
        result.getPaymentForms().add(pf);
        return result;
    }

    private TicketIssueRQ.CreditCard buildCredicCard(Card card) {
        TicketIssueRQ.CreditCard result = new TicketIssueRQ.CreditCard();
        result.setCcCode(this.getCardVendorCode(card.getVendor()));
        result.setCcNumber(card.getNumber());
        result.setSecurityID(card.getSecurityCode());
        result.setCardholderLastName(card.getNameOnCard());
        result.setCcExpiration(this.buildCcExpiration(card.getExpiration()));
        return result;
    }

    private String getCardVendorCode(CardVendor vendor) {
        if (vendor == null) {
            return null;
        }
        switch (vendor) {
            case VISA: {
                return "VI";
            }
            case MASTERCARD: {
                return "CA";
            }
            case AMEX: {
                return "AX";
            }
            case DINERS_CLUB: {
                return "DC";
            }
        }
        return null;
    }

    private TicketIssueRQ.CCExpiration buildCcExpiration(Date expiration) {
        TicketIssueRQ.CCExpiration result = new TicketIssueRQ.CCExpiration();
        Calendar cal = Calendar.getInstance();
        cal.setTime(expiration);
        result.setMonth(cal.get(2) + 1);
        result.setYear(cal.get(1) % 100);
        return result;
    }

    private List<TicketIssueRQ.Traveler> buildTravelers(List<String> productGdsIds) {
        ArrayList<TicketIssueRQ.Traveler> result = new ArrayList<TicketIssueRQ.Traveler>();
        for (String gdsId : productGdsIds) {
            TicketIssueRQ.Traveler tr = new TicketIssueRQ.Traveler();
            tr.setTravelerElementNumber(gdsId);
            result.add(tr);
        }
        return result;
    }
}

