
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Unique 3D Secure transaction reference number assigned by Access Control System (ACS).
 Example: Qzl3WVc1TVpXNW5kR2crUEcxbGMzTmhaMlZKWkQ1UVFWSmxjUzB4TWpnNUSXcKTmprNU5EWThMMjFsYzNOaFoyVkpRDQ4TDAxRVBqd3ZVVEr

 Note: This is typically required for ACS systems that support Status Query.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ACS_TxnReference">
 *   &lt;xs:complexType>
 *     &lt;xs:simpleContent>
 *       &lt;xs:extension base="xs:string">
 *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
 *       &lt;/xs:extension>
 *     &lt;/xs:simpleContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class ACSTxnReference implements Serializable
{
    private String string;
    private String context;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'Context' attribute value. Transaction Reference context.
     * 
     * @return value
     */
    public String getContext() {
        return context;
    }

    /** 
     * Set the 'Context' attribute value. Transaction Reference context.
     * 
     * @param context
     */
    public void setContext(String context) {
        this.context = context;
    }
}
