
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * ACCEPTED PAYMENT FORM definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AcceptedPaymentFormType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Type"/>
 *     &lt;xs:element type="CurrencyAmountOptType" name="Amount" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Qualifier" minOccurs="0"/>
 *     &lt;xs:element ref="Voucher" minOccurs="0"/>
 *     &lt;xs:element ref="PaymentCard" minOccurs="0"/>
 *     &lt;xs:element ref="Other" minOccurs="0"/>
 *     &lt;xs:element ref="MiscChargeOrder" minOccurs="0"/>
 *     &lt;xs:element ref="LoyaltyRedemption" minOccurs="0"/>
 *     &lt;xs:element ref="DirectBill" minOccurs="0"/>
 *     &lt;xs:element ref="Cash" minOccurs="0"/>
 *     &lt;xs:element ref="BankAccount" minOccurs="0"/>
 *     &lt;xs:element ref="Associations" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class AcceptedPaymentFormType implements Serializable
{
    private String type;
    private CurrencyAmountOptType amount;
    private String qualifier;
    private Voucher voucher;
    private PaymentCardType paymentCard;
    private Other other;
    private MiscChargeOrder miscChargeOrder;
    private LoyaltyRedemption loyaltyRedemption;
    private DirectBillType directBill;
    private Cash cash;
    private BankAccountType bankAccount;
    private Associations associations;
    private String refs;

    /** 
     * Get the 'Type' element value. The form of payment type. Examples: Credit Card, Cash.

    Encoding Scheme: IATA PADIS code list data element [9888] Form of Payment Identification
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. The form of payment type. Examples: Credit Card, Cash.

    Encoding Scheme: IATA PADIS code list data element [9888] Form of Payment Identification
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'Amount' element value. The amount for this form of payment. Example: 300 USD
     * 
     * @return value
     */
    public CurrencyAmountOptType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. The amount for this form of payment. Example: 300 USD
     * 
     * @param amount
     */
    public void setAmount(CurrencyAmountOptType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'Qualifier' element value. Used to specify if this is the old, new or orginal form of payment.

    Encoding Scheme: IATA  PADIS code list [9988] Data Indicator
     * 
     * @return value
     */
    public String getQualifier() {
        return qualifier;
    }

    /** 
     * Set the 'Qualifier' element value. Used to specify if this is the old, new or orginal form of payment.

    Encoding Scheme: IATA  PADIS code list [9988] Data Indicator
     * 
     * @param qualifier
     */
    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    /** 
     * Get the 'Voucher' element value. Information relating to prepayment vouchers.
     * 
     * @return value
     */
    public Voucher getVoucher() {
        return voucher;
    }

    /** 
     * Set the 'Voucher' element value. Information relating to prepayment vouchers.
     * 
     * @param voucher
     */
    public void setVoucher(Voucher voucher) {
        this.voucher = voucher;
    }

    /** 
     * Get the 'PaymentCard' element value.
     * 
     * @return value
     */
    public PaymentCardType getPaymentCard() {
        return paymentCard;
    }

    /** 
     * Set the 'PaymentCard' element value.
     * 
     * @param paymentCard
     */
    public void setPaymentCard(PaymentCardType paymentCard) {
        this.paymentCard = paymentCard;
    }

    /** 
     * Get the 'Other' element value.
     * 
     * @return value
     */
    public Other getOther() {
        return other;
    }

    /** 
     * Set the 'Other' element value.
     * 
     * @param other
     */
    public void setOther(Other other) {
        this.other = other;
    }

    /** 
     * Get the 'MiscChargeOrder' element value.
     * 
     * @return value
     */
    public MiscChargeOrder getMiscChargeOrder() {
        return miscChargeOrder;
    }

    /** 
     * Set the 'MiscChargeOrder' element value.
     * 
     * @param miscChargeOrder
     */
    public void setMiscChargeOrder(MiscChargeOrder miscChargeOrder) {
        this.miscChargeOrder = miscChargeOrder;
    }

    /** 
     * Get the 'LoyaltyRedemption' element value.
     * 
     * @return value
     */
    public LoyaltyRedemption getLoyaltyRedemption() {
        return loyaltyRedemption;
    }

    /** 
     * Set the 'LoyaltyRedemption' element value.
     * 
     * @param loyaltyRedemption
     */
    public void setLoyaltyRedemption(LoyaltyRedemption loyaltyRedemption) {
        this.loyaltyRedemption = loyaltyRedemption;
    }

    /** 
     * Get the 'DirectBill' element value.
     * 
     * @return value
     */
    public DirectBillType getDirectBill() {
        return directBill;
    }

    /** 
     * Set the 'DirectBill' element value.
     * 
     * @param directBill
     */
    public void setDirectBill(DirectBillType directBill) {
        this.directBill = directBill;
    }

    /** 
     * Get the 'Cash' element value.
     * 
     * @return value
     */
    public Cash getCash() {
        return cash;
    }

    /** 
     * Set the 'Cash' element value.
     * 
     * @param cash
     */
    public void setCash(Cash cash) {
        this.cash = cash;
    }

    /** 
     * Get the 'BankAccount' element value.
     * 
     * @return value
     */
    public BankAccountType getBankAccount() {
        return bankAccount;
    }

    /** 
     * Set the 'BankAccount' element value.
     * 
     * @param bankAccount
     */
    public void setBankAccount(BankAccountType bankAccount) {
        this.bankAccount = bankAccount;
    }

    /** 
     * Get the 'Associations' element value.
     * 
     * @return value
     */
    public Associations getAssociations() {
        return associations;
    }

    /** 
     * Set the 'Associations' element value.
     * 
     * @param associations
     */
    public void setAssociations(Associations associations) {
        this.associations = associations;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
