
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Actor object instance id and association(s).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ActorObjAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="metadata"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ActorObjAttrGroup implements Serializable
{
    private String metadata;
    private String refs;

    /** 
     * Get the 'metadata' attribute value. Association between this object and metadata instance(s).
     * 
     * @return value
     */
    public String getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'metadata' attribute value. Association between this object and metadata instance(s).
     * 
     * @param metadata
     */
    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this actor object and any object instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this actor object and any object instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
