
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Carry-on and checked baggage allowances.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddlBaggageInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="AllowableBag" minOccurs="0" maxOccurs="99">
 *       &lt;!-- Reference to inner class AllowableBag -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="BagCharge" minOccurs="0" maxOccurs="99">
 *       &lt;!-- Reference to inner class BagCharge -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="CarryOnAllowableBag" minOccurs="0" maxOccurs="99">
 *       &lt;!-- Reference to inner class CarryOnAllowableBag -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="CarryOnChargeableBag" minOccurs="0" maxOccurs="99">
 *       &lt;!-- Reference to inner class CarryOnChargeableBag -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="CarryOnFree" minOccurs="0">
 *       &lt;!-- Reference to inner class CarryOnFree -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="CheckedFree" minOccurs="0">
 *       &lt;!-- Reference to inner class CheckedFree -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="CheckedChargeableBag" minOccurs="0" maxOccurs="99">
 *       &lt;!-- Reference to inner class CheckedChargeableBag -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MaxFreeBagDim"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AddlBaggageInfoType implements Serializable
{
    private List<AllowableBag> allowableBagList = new ArrayList<AllowableBag>();
    private List<BagCharge> bagChargeList = new ArrayList<BagCharge>();
    private List<CarryOnAllowableBag> carryOnAllowableBagList = new ArrayList<CarryOnAllowableBag>();
    private List<CarryOnChargeableBag> carryOnChargeableBagList = new ArrayList<CarryOnChargeableBag>();
    private CarryOnFree carryOnFree;
    private CheckedFree checkedFree;
    private List<CheckedChargeableBag> checkedChargeableBagList = new ArrayList<CheckedChargeableBag>();
    private String maxFreeBagDim;

    /** 
     * Get the list of 'AllowableBag' element items.
     * 
     * @return list
     */
    public List<AllowableBag> getAllowableBagList() {
        return allowableBagList;
    }

    /** 
     * Set the list of 'AllowableBag' element items.
     * 
     * @param list
     */
    public void setAllowableBagList(List<AllowableBag> list) {
        allowableBagList = list;
    }

    /** 
     * Get the list of 'BagCharge' element items.
     * 
     * @return list
     */
    public List<BagCharge> getBagChargeList() {
        return bagChargeList;
    }

    /** 
     * Set the list of 'BagCharge' element items.
     * 
     * @param list
     */
    public void setBagChargeList(List<BagCharge> list) {
        bagChargeList = list;
    }

    /** 
     * Get the list of 'CarryOnAllowableBag' element items.
     * 
     * @return list
     */
    public List<CarryOnAllowableBag> getCarryOnAllowableBagList() {
        return carryOnAllowableBagList;
    }

    /** 
     * Set the list of 'CarryOnAllowableBag' element items.
     * 
     * @param list
     */
    public void setCarryOnAllowableBagList(List<CarryOnAllowableBag> list) {
        carryOnAllowableBagList = list;
    }

    /** 
     * Get the list of 'CarryOnChargeableBag' element items.
     * 
     * @return list
     */
    public List<CarryOnChargeableBag> getCarryOnChargeableBagList() {
        return carryOnChargeableBagList;
    }

    /** 
     * Set the list of 'CarryOnChargeableBag' element items.
     * 
     * @param list
     */
    public void setCarryOnChargeableBagList(List<CarryOnChargeableBag> list) {
        carryOnChargeableBagList = list;
    }

    /** 
     * Get the 'CarryOnFree' element value.
     * 
     * @return value
     */
    public CarryOnFree getCarryOnFree() {
        return carryOnFree;
    }

    /** 
     * Set the 'CarryOnFree' element value.
     * 
     * @param carryOnFree
     */
    public void setCarryOnFree(CarryOnFree carryOnFree) {
        this.carryOnFree = carryOnFree;
    }

    /** 
     * Get the 'CheckedFree' element value.
     * 
     * @return value
     */
    public CheckedFree getCheckedFree() {
        return checkedFree;
    }

    /** 
     * Set the 'CheckedFree' element value.
     * 
     * @param checkedFree
     */
    public void setCheckedFree(CheckedFree checkedFree) {
        this.checkedFree = checkedFree;
    }

    /** 
     * Get the list of 'CheckedChargeableBag' element items.
     * 
     * @return list
     */
    public List<CheckedChargeableBag> getCheckedChargeableBagList() {
        return checkedChargeableBagList;
    }

    /** 
     * Set the list of 'CheckedChargeableBag' element items.
     * 
     * @param list
     */
    public void setCheckedChargeableBagList(List<CheckedChargeableBag> list) {
        checkedChargeableBagList = list;
    }

    /** 
     * Get the 'MaxFreeBagDim' attribute value. The maximum linear dimensions of the baqggage follwed by centimeters 'C' or inches 'I'.
     * 
     * @return value
     */
    public String getMaxFreeBagDim() {
        return maxFreeBagDim;
    }

    /** 
     * Set the 'MaxFreeBagDim' attribute value. The maximum linear dimensions of the baqggage follwed by centimeters 'C' or inches 'I'.
     * 
     * @param maxFreeBagDim
     */
    public void setMaxFreeBagDim(String maxFreeBagDim) {
        this.maxFreeBagDim = maxFreeBagDim;
    }
    /** 
     * The allowable baggage types and max number.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AllowableBag" minOccurs="0" maxOccurs="99">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="Type"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AllowableBag implements Serializable
    {
        private String type;
        private BigInteger number;

        /** 
         * Get the 'Type' attribute value. The permitted baggage types by RFISC for the applicable baggage allowance.
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'Type' attribute value. The permitted baggage types by RFISC for the applicable baggage allowance.
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }

        /** 
         * Get the 'Number' attribute value. The maximum numberof this baggage type.
         * 
         * @return value
         */
        public BigInteger getNumber() {
            return number;
        }

        /** 
         * Set the 'Number' attribute value. The maximum numberof this baggage type.
         * 
         * @param number
         */
        public void setNumber(BigInteger number) {
            this.number = number;
        }
    }
    /** 
     * The charge amount for different baggage types
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagCharge" minOccurs="0" maxOccurs="99">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
     *     &lt;xs:attribute type="xs:string" name="Amount"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BagCharge implements Serializable
    {
        private String type;
        private String amount;
        private String currencyCode;

        /** 
         * Get the 'Type' attribute value. The baggage charge type by RFISC for the applicable baggage charge.
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'Type' attribute value. The baggage charge type by RFISC for the applicable baggage charge.
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }

        /** 
         * Get the 'Amount' attribute value. The baggage charge amount which is applied to the 1st and 2nd checked bag.
         * 
         * @return value
         */
        public String getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' attribute value. The baggage charge amount which is applied to the 1st and 2nd checked bag.
         * 
         * @param amount
         */
        public void setAmount(String amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'CurrencyCode' attribute value. The currency code for payment of a baggage charge. Use ISO 4217, three alpha code.
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'CurrencyCode' attribute value. The currency code for payment of a baggage charge. Use ISO 4217, three alpha code.
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }
    }
    /** 
     * The determining carrier code and the max number for each type of carry-on allowable baggage.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarryOnAllowableBag" minOccurs="0" maxOccurs="99">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="DeterminingCarrierCode"/>
     *     &lt;xs:attribute type="xs:string" name="Type"/>
     *     &lt;xs:attribute type="xs:integer" name="Number"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CarryOnAllowableBag implements Serializable
    {
        private String determiningCarrierCode;
        private String type;
        private BigInteger number;

        /** 
         * Get the 'DeterminingCarrierCode' attribute value. The determining carrier code of the carry-on allowance baggage type.
         * 
         * @return value
         */
        public String getDeterminingCarrierCode() {
            return determiningCarrierCode;
        }

        /** 
         * Set the 'DeterminingCarrierCode' attribute value. The determining carrier code of the carry-on allowance baggage type.
         * 
         * @param determiningCarrierCode
         */
        public void setDeterminingCarrierCode(String determiningCarrierCode) {
            this.determiningCarrierCode = determiningCarrierCode;
        }

        /** 
         * Get the 'Type' attribute value. The permitted baggage type by RFISC for the carry-on baggage allowance.
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'Type' attribute value. The permitted baggage type by RFISC for the carry-on baggage allowance.
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }

        /** 
         * Get the 'Number' attribute value. The maximum number of each allowable baggage type.
         * 
         * @return value
         */
        public BigInteger getNumber() {
            return number;
        }

        /** 
         * Set the 'Number' attribute value. The maximum number of each allowable baggage type.
         * 
         * @param number
         */
        public void setNumber(BigInteger number) {
            this.number = number;
        }
    }
    /** 
     * The carry on chargeable baggage information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarryOnChargeableBag" minOccurs="0" maxOccurs="99">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Embargo" minOccurs="0" maxOccurs="99">
     *         &lt;!-- Reference to inner class Embargo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" name="Type"/>
     *     &lt;xs:attribute type="xs:string" name="Amount"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="MaxBagDim"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="MaxBagWght"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CarryOnChargeableBag implements Serializable
    {
        private List<Embargo> embargoList = new ArrayList<Embargo>();
        private String type;
        private String amount;
        private String currencyCode;
        private String maxBagDim;
        private String maxBagWght;

        /** 
         * Get the list of 'Embargo' element items.
         * 
         * @return list
         */
        public List<Embargo> getEmbargoList() {
            return embargoList;
        }

        /** 
         * Set the list of 'Embargo' element items.
         * 
         * @param list
         */
        public void setEmbargoList(List<Embargo> list) {
            embargoList = list;
        }

        /** 
         * Get the 'Type' attribute value. The permitted baggage type by RFISC for the carry-on baggage allowance.
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'Type' attribute value. The permitted baggage type by RFISC for the carry-on baggage allowance.
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }

        /** 
         * Get the 'Amount' attribute value. The baggage charge amount which is applied to the 1st and 2nd checked bag.
         * 
         * @return value
         */
        public String getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' attribute value. The baggage charge amount which is applied to the 1st and 2nd checked bag.
         * 
         * @param amount
         */
        public void setAmount(String amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'CurrencyCode' attribute value. The currency code for payment of a baggage charge. Use ISO 4217, three alpha code.
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'CurrencyCode' attribute value. The currency code for payment of a baggage charge. Use ISO 4217, three alpha code.
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        /** 
         * Get the 'MaxBagDim' attribute value. The maximum linear dimensions of the baqggage follwed by centimeters 'C' or inches 'I'.
         * 
         * @return value
         */
        public String getMaxBagDim() {
            return maxBagDim;
        }

        /** 
         * Set the 'MaxBagDim' attribute value. The maximum linear dimensions of the baqggage follwed by centimeters 'C' or inches 'I'.
         * 
         * @param maxBagDim
         */
        public void setMaxBagDim(String maxBagDim) {
            this.maxBagDim = maxBagDim;
        }

        /** 
         * Get the 'MaxBagWght' attribute value. The maximum baggage weight followed by kilos 'K' or pounds 'L'.
         * 
         * @return value
         */
        public String getMaxBagWght() {
            return maxBagWght;
        }

        /** 
         * Set the 'MaxBagWght' attribute value. The maximum baggage weight followed by kilos 'K' or pounds 'L'.
         * 
         * @param maxBagWght
         */
        public void setMaxBagWght(String maxBagWght) {
            this.maxBagWght = maxBagWght;
        }
        /** 
         * Specifies the embargo information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Embargo" minOccurs="0" maxOccurs="99">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="Info"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Embargo implements Serializable
        {
            private String info;

            /** 
             * Get the 'Info' attribute value. The embargo information
             * 
             * @return value
             */
            public String getInfo() {
                return info;
            }

            /** 
             * Set the 'Info' attribute value. The embargo information
             * 
             * @param info
             */
            public void setInfo(String info) {
                this.info = info;
            }
        }
    }
    /** 
     * The maximum bag dimensions and weight for free carry on baggage.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarryOnFree" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="MaxBagDim"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="MaxBagWght"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CarryOnFree implements Serializable
    {
        private String maxBagDim;
        private String maxBagWght;

        /** 
         * Get the 'MaxBagDim' attribute value. The maximum linear dimensions of the baqggage follwed by centimeters 'C' or inches 'I'.
         * 
         * @return value
         */
        public String getMaxBagDim() {
            return maxBagDim;
        }

        /** 
         * Set the 'MaxBagDim' attribute value. The maximum linear dimensions of the baqggage follwed by centimeters 'C' or inches 'I'.
         * 
         * @param maxBagDim
         */
        public void setMaxBagDim(String maxBagDim) {
            this.maxBagDim = maxBagDim;
        }

        /** 
         * Get the 'MaxBagWght' attribute value. The maximum baggage weight followed by kilos 'K' or pounds 'L'.
         * 
         * @return value
         */
        public String getMaxBagWght() {
            return maxBagWght;
        }

        /** 
         * Set the 'MaxBagWght' attribute value. The maximum baggage weight followed by kilos 'K' or pounds 'L'.
         * 
         * @param maxBagWght
         */
        public void setMaxBagWght(String maxBagWght) {
            this.maxBagWght = maxBagWght;
        }
    }
    /** 
     * The maximum bag dimensions and weight for free checked baggage.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CheckedFree" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="MaxBagDim"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="MaxBagWght"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CheckedFree implements Serializable
    {
        private String maxBagDim;
        private String maxBagWght;

        /** 
         * Get the 'MaxBagDim' attribute value. The maximum linear dimensions of the baqggage follwed by centimeters 'C' or inches 'I'.
         * 
         * @return value
         */
        public String getMaxBagDim() {
            return maxBagDim;
        }

        /** 
         * Set the 'MaxBagDim' attribute value. The maximum linear dimensions of the baqggage follwed by centimeters 'C' or inches 'I'.
         * 
         * @param maxBagDim
         */
        public void setMaxBagDim(String maxBagDim) {
            this.maxBagDim = maxBagDim;
        }

        /** 
         * Get the 'MaxBagWght' attribute value. The maximum baggage weight followed by kilos 'K' or pounds 'L'.
         * 
         * @return value
         */
        public String getMaxBagWght() {
            return maxBagWght;
        }

        /** 
         * Set the 'MaxBagWght' attribute value. The maximum baggage weight followed by kilos 'K' or pounds 'L'.
         * 
         * @param maxBagWght
         */
        public void setMaxBagWght(String maxBagWght) {
            this.maxBagWght = maxBagWght;
        }
    }
    /** 
     * The checked chargeable baggage information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CheckedChargeableBag" minOccurs="0" maxOccurs="99">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Embargo" minOccurs="0" maxOccurs="99">
     *         &lt;!-- Reference to inner class Embargo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" name="Type"/>
     *     &lt;xs:attribute type="xs:string" name="Amount"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="MaxBagDim"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="MaxBagWght"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CheckedChargeableBag implements Serializable
    {
        private List<Embargo> embargoList = new ArrayList<Embargo>();
        private String type;
        private String amount;
        private String currencyCode;
        private String maxBagDim;
        private String maxBagWght;

        /** 
         * Get the list of 'Embargo' element items.
         * 
         * @return list
         */
        public List<Embargo> getEmbargoList() {
            return embargoList;
        }

        /** 
         * Set the list of 'Embargo' element items.
         * 
         * @param list
         */
        public void setEmbargoList(List<Embargo> list) {
            embargoList = list;
        }

        /** 
         * Get the 'Type' attribute value. The permitted baggage type by RFISC for the checked baggage allowance.
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'Type' attribute value. The permitted baggage type by RFISC for the checked baggage allowance.
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }

        /** 
         * Get the 'Amount' attribute value. The baggage charge amount which is applied to the 1st and 2nd checked bag.
         * 
         * @return value
         */
        public String getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' attribute value. The baggage charge amount which is applied to the 1st and 2nd checked bag.
         * 
         * @param amount
         */
        public void setAmount(String amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'CurrencyCode' attribute value. The currency code for payment of a baggage charge. Use ISO 4217, three alpha code.
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'CurrencyCode' attribute value. The currency code for payment of a baggage charge. Use ISO 4217, three alpha code.
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        /** 
         * Get the 'MaxBagDim' attribute value. The maximum linear dimensions of the baqggage follwed by centimeters 'C' or inches 'I'.
         * 
         * @return value
         */
        public String getMaxBagDim() {
            return maxBagDim;
        }

        /** 
         * Set the 'MaxBagDim' attribute value. The maximum linear dimensions of the baqggage follwed by centimeters 'C' or inches 'I'.
         * 
         * @param maxBagDim
         */
        public void setMaxBagDim(String maxBagDim) {
            this.maxBagDim = maxBagDim;
        }

        /** 
         * Get the 'MaxBagWght' attribute value. The maximum baggage weight followed by kilos 'K' or pounds 'L'.
         * 
         * @return value
         */
        public String getMaxBagWght() {
            return maxBagWght;
        }

        /** 
         * Set the 'MaxBagWght' attribute value. The maximum baggage weight followed by kilos 'K' or pounds 'L'.
         * 
         * @param maxBagWght
         */
        public void setMaxBagWght(String maxBagWght) {
            this.maxBagWght = maxBagWght;
        }
        /** 
         * Specifies the embargo information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Embargo" minOccurs="0" maxOccurs="99">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="Info"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Embargo implements Serializable
        {
            private String info;

            /** 
             * Get the 'Info' attribute value. The embargo information
             * 
             * @return value
             */
            public String getInfo() {
                return info;
            }

            /** 
             * Set the 'Info' attribute value. The embargo information
             * 
             * @param info
             */
            public void setInfo(String info) {
                this.info = info;
            }
        }
    }
}
