
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for Aggregator Message Participant Role. Derived from AggregatorMsgPartyCoreType.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AggregatorParticipantType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="AggregatorMsgPartyCoreType">
 *       &lt;xs:attribute type="xs:string" use="required" name="SequenceNumber"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AggregatorParticipantType extends AggregatorMsgPartyCoreType
    implements Serializable
{
    private String sequenceNumber;

    /** 
     * Get the 'SequenceNumber' attribute value. The sequence number of this participating Party within the collection of parties.
    Example: 1

    Notes:
    1. A sequence number of 1 indicates that this is the first Participant involved in the transaction.
     * 
     * @return value
     */
    public String getSequenceNumber() {
        return sequenceNumber;
    }

    /** 
     * Set the 'SequenceNumber' attribute value. The sequence number of this participating Party within the collection of parties.
    Example: 1

    Notes:
    1. A sequence number of 1 indicates that this is the first Participant involved in the transaction.
     * 
     * @param sequenceNumber
     */
    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }
}
