
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Air Shopping Response Metadata definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirShopResMetadataType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Shopping" minOccurs="0">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element ref="ShopMetadataGroup"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="Passenger" minOccurs="0">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element ref="PassengerMetadata"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="Other" minOccurs="0">
 *       &lt;!-- Reference to inner class Other -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirShopResMetadataType implements Serializable
{
    private ShopMetadataGroup shopping;
    private PassengerMetadataType passenger;
    private Other other;

    /** 
     * Get the 'ShopMetadataGroup' element value. Shopping Query-Related Metadata.
     * 
     * @return value
     */
    public ShopMetadataGroup getShopping() {
        return shopping;
    }

    /** 
     * Set the 'ShopMetadataGroup' element value. Shopping Query-Related Metadata.
     * 
     * @param shopping
     */
    public void setShopping(ShopMetadataGroup shopping) {
        this.shopping = shopping;
    }

    /** 
     * Get the 'PassengerMetadata' element value. Passenger Metadata List(s).
     * 
     * @return value
     */
    public PassengerMetadataType getPassenger() {
        return passenger;
    }

    /** 
     * Set the 'PassengerMetadata' element value. Passenger Metadata List(s).
     * 
     * @param passenger
     */
    public void setPassenger(PassengerMetadataType passenger) {
        this.passenger = passenger;
    }

    /** 
     * Get the 'Other' element value.
     * 
     * @return value
     */
    public Other getOther() {
        return other;
    }

    /** 
     * Set the 'Other' element value.
     * 
     * @param other
     */
    public void setOther(Other other) {
        this.other = other;
    }
    /** 
     * Other Metadata Lists(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Other" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="OtherMetadata" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class OtherMetadata -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Other implements Serializable
    {
        private List<OtherMetadata> otherMetadataList = new ArrayList<OtherMetadata>();

        /** 
         * Get the list of 'OtherMetadata' element items.
         * 
         * @return list
         */
        public List<OtherMetadata> getOtherMetadataList() {
            return otherMetadataList;
        }

        /** 
         * Set the list of 'OtherMetadata' element items.
         * 
         * @param list
         */
        public void setOtherMetadataList(List<OtherMetadata> list) {
            otherMetadataList = list;
        }
        /** 
         * Other Metadata List.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherMetadata" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:choice>
         *       &lt;xs:element ref="AircraftMetadatas"/>
         *       &lt;xs:element ref="AirportMetadatas"/>
         *       &lt;xs:element ref="CityMetadatas"/>
         *       &lt;xs:element ref="CodesetMetadatas"/>
         *       &lt;xs:element ref="ContactMetadatas"/>
         *       &lt;xs:element ref="CountryMetadatas"/>
         *       &lt;xs:element ref="CurrencyMetadatas"/>
         *       &lt;xs:element ref="DescriptionMetadatas"/>
         *       &lt;xs:element ref="EquivalentID_Metadatas"/>
         *       &lt;xs:element ref="LanguageMetadatas"/>
         *       &lt;xs:element ref="PaymentCardMetadatas"/>
         *       &lt;xs:element ref="PaymentFormMetadatas"/>
         *       &lt;xs:element ref="PriceMetadatas"/>
         *       &lt;xs:element ref="RuleMetadatas"/>
         *       &lt;xs:element ref="StateProvMetadatas"/>
         *       &lt;xs:element ref="ZoneMetadatas"/>
         *       &lt;xs:element ref="AddressMetadatas"/>
         *     &lt;/xs:choice>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OtherMetadata implements Serializable
        {
            private int otherMetadataListSelect = -1;
            private static final int AIRCRAFT_METADATAS_CHOICE = 0;
            private static final int AIRPORT_METADATAS_CHOICE = 1;
            private static final int CITY_METADATAS_CHOICE = 2;
            private static final int CODESET_METADATAS_CHOICE = 3;
            private static final int CONTACT_METADATAS_CHOICE = 4;
            private static final int COUNTRY_METADATAS_CHOICE = 5;
            private static final int CURRENCY_METADATAS_CHOICE = 6;
            private static final int DESCRIPTION_METADATAS_CHOICE = 7;
            private static final int EQUIVALENT_ID_METADATAS_CHOICE = 8;
            private static final int LANGUAGE_METADATAS_CHOICE = 9;
            private static final int PAYMENT_CARD_METADATAS_CHOICE = 10;
            private static final int PAYMENT_FORM_METADATAS_CHOICE = 11;
            private static final int PRICE_METADATAS_CHOICE = 12;
            private static final int RULE_METADATAS_CHOICE = 13;
            private static final int STATE_PROV_METADATAS_CHOICE = 14;
            private static final int ZONE_METADATAS_CHOICE = 15;
            private static final int ADDRESS_METADATAS_CHOICE = 16;
            private AircraftMetadatas aircraftMetadatas;
            private AirportMetadatas airportMetadatas;
            private CityMetadatas cityMetadatas;
            private CodesetMetadatas codesetMetadatas;
            private ContactMetadatas contactMetadatas;
            private CountryMetadatas countryMetadatas;
            private CurrencyMetadatas currencyMetadatas;
            private DescriptionMetadatas descriptionMetadatas;
            private EquivalentIDMetadatas equivalentIDMetadatas;
            private LanguageMetadatas languageMetadatas;
            private PaymentCardMetadatas paymentCardMetadatas;
            private PaymentFormMetadatas paymentFormMetadatas;
            private PriceMetadatas priceMetadatas;
            private RuleMetadatas ruleMetadatas;
            private StateProvMetadatas stateProvMetadatas;
            private ZoneMetadatas zoneMetadatas;
            private AddressMetadatas addressMetadatas;

            private void setOtherMetadataListSelect(int choice) {
                if (otherMetadataListSelect == -1) {
                    otherMetadataListSelect = choice;
                } else if (otherMetadataListSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearOtherMetadataListSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearOtherMetadataListSelect() {
                otherMetadataListSelect = -1;
            }

            /** 
             * Check if AircraftMetadatas is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifAircraftMetadatas() {
                return otherMetadataListSelect == AIRCRAFT_METADATAS_CHOICE;
            }

            /** 
             * Get the 'AircraftMetadatas' element value.
             * 
             * @return value
             */
            public AircraftMetadatas getAircraftMetadatas() {
                return aircraftMetadatas;
            }

            /** 
             * Set the 'AircraftMetadatas' element value.
             * 
             * @param aircraftMetadatas
             */
            public void setAircraftMetadatas(AircraftMetadatas aircraftMetadatas) {
                setOtherMetadataListSelect(AIRCRAFT_METADATAS_CHOICE);
                this.aircraftMetadatas = aircraftMetadatas;
            }

            /** 
             * Check if AirportMetadatas is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifAirportMetadatas() {
                return otherMetadataListSelect == AIRPORT_METADATAS_CHOICE;
            }

            /** 
             * Get the 'AirportMetadatas' element value.
             * 
             * @return value
             */
            public AirportMetadatas getAirportMetadatas() {
                return airportMetadatas;
            }

            /** 
             * Set the 'AirportMetadatas' element value.
             * 
             * @param airportMetadatas
             */
            public void setAirportMetadatas(AirportMetadatas airportMetadatas) {
                setOtherMetadataListSelect(AIRPORT_METADATAS_CHOICE);
                this.airportMetadatas = airportMetadatas;
            }

            /** 
             * Check if CityMetadatas is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifCityMetadatas() {
                return otherMetadataListSelect == CITY_METADATAS_CHOICE;
            }

            /** 
             * Get the 'CityMetadatas' element value.
             * 
             * @return value
             */
            public CityMetadatas getCityMetadatas() {
                return cityMetadatas;
            }

            /** 
             * Set the 'CityMetadatas' element value.
             * 
             * @param cityMetadatas
             */
            public void setCityMetadatas(CityMetadatas cityMetadatas) {
                setOtherMetadataListSelect(CITY_METADATAS_CHOICE);
                this.cityMetadatas = cityMetadatas;
            }

            /** 
             * Check if CodesetMetadatas is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifCodesetMetadatas() {
                return otherMetadataListSelect == CODESET_METADATAS_CHOICE;
            }

            /** 
             * Get the 'CodesetMetadatas' element value.
             * 
             * @return value
             */
            public CodesetMetadatas getCodesetMetadatas() {
                return codesetMetadatas;
            }

            /** 
             * Set the 'CodesetMetadatas' element value.
             * 
             * @param codesetMetadatas
             */
            public void setCodesetMetadatas(CodesetMetadatas codesetMetadatas) {
                setOtherMetadataListSelect(CODESET_METADATAS_CHOICE);
                this.codesetMetadatas = codesetMetadatas;
            }

            /** 
             * Check if ContactMetadatas is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifContactMetadatas() {
                return otherMetadataListSelect == CONTACT_METADATAS_CHOICE;
            }

            /** 
             * Get the 'ContactMetadatas' element value.
             * 
             * @return value
             */
            public ContactMetadatas getContactMetadatas() {
                return contactMetadatas;
            }

            /** 
             * Set the 'ContactMetadatas' element value.
             * 
             * @param contactMetadatas
             */
            public void setContactMetadatas(ContactMetadatas contactMetadatas) {
                setOtherMetadataListSelect(CONTACT_METADATAS_CHOICE);
                this.contactMetadatas = contactMetadatas;
            }

            /** 
             * Check if CountryMetadatas is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifCountryMetadatas() {
                return otherMetadataListSelect == COUNTRY_METADATAS_CHOICE;
            }

            /** 
             * Get the 'CountryMetadatas' element value.
             * 
             * @return value
             */
            public CountryMetadatas getCountryMetadatas() {
                return countryMetadatas;
            }

            /** 
             * Set the 'CountryMetadatas' element value.
             * 
             * @param countryMetadatas
             */
            public void setCountryMetadatas(CountryMetadatas countryMetadatas) {
                setOtherMetadataListSelect(COUNTRY_METADATAS_CHOICE);
                this.countryMetadatas = countryMetadatas;
            }

            /** 
             * Check if CurrencyMetadatas is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifCurrencyMetadatas() {
                return otherMetadataListSelect == CURRENCY_METADATAS_CHOICE;
            }

            /** 
             * Get the 'CurrencyMetadatas' element value.
             * 
             * @return value
             */
            public CurrencyMetadatas getCurrencyMetadatas() {
                return currencyMetadatas;
            }

            /** 
             * Set the 'CurrencyMetadatas' element value.
             * 
             * @param currencyMetadatas
             */
            public void setCurrencyMetadatas(CurrencyMetadatas currencyMetadatas) {
                setOtherMetadataListSelect(CURRENCY_METADATAS_CHOICE);
                this.currencyMetadatas = currencyMetadatas;
            }

            /** 
             * Check if DescriptionMetadatas is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifDescriptionMetadatas() {
                return otherMetadataListSelect == DESCRIPTION_METADATAS_CHOICE;
            }

            /** 
             * Get the 'DescriptionMetadatas' element value.
             * 
             * @return value
             */
            public DescriptionMetadatas getDescriptionMetadatas() {
                return descriptionMetadatas;
            }

            /** 
             * Set the 'DescriptionMetadatas' element value.
             * 
             * @param descriptionMetadatas
             */
            public void setDescriptionMetadatas(
                    DescriptionMetadatas descriptionMetadatas) {
                setOtherMetadataListSelect(DESCRIPTION_METADATAS_CHOICE);
                this.descriptionMetadatas = descriptionMetadatas;
            }

            /** 
             * Check if EquivalentIDMetadatas is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifEquivalentIDMetadatas() {
                return otherMetadataListSelect == EQUIVALENT_ID_METADATAS_CHOICE;
            }

            /** 
             * Get the 'EquivalentID_Metadatas' element value.
             * 
             * @return value
             */
            public EquivalentIDMetadatas getEquivalentIDMetadatas() {
                return equivalentIDMetadatas;
            }

            /** 
             * Set the 'EquivalentID_Metadatas' element value.
             * 
             * @param equivalentIDMetadatas
             */
            public void setEquivalentIDMetadatas(
                    EquivalentIDMetadatas equivalentIDMetadatas) {
                setOtherMetadataListSelect(EQUIVALENT_ID_METADATAS_CHOICE);
                this.equivalentIDMetadatas = equivalentIDMetadatas;
            }

            /** 
             * Check if LanguageMetadatas is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifLanguageMetadatas() {
                return otherMetadataListSelect == LANGUAGE_METADATAS_CHOICE;
            }

            /** 
             * Get the 'LanguageMetadatas' element value.
             * 
             * @return value
             */
            public LanguageMetadatas getLanguageMetadatas() {
                return languageMetadatas;
            }

            /** 
             * Set the 'LanguageMetadatas' element value.
             * 
             * @param languageMetadatas
             */
            public void setLanguageMetadatas(LanguageMetadatas languageMetadatas) {
                setOtherMetadataListSelect(LANGUAGE_METADATAS_CHOICE);
                this.languageMetadatas = languageMetadatas;
            }

            /** 
             * Check if PaymentCardMetadatas is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifPaymentCardMetadatas() {
                return otherMetadataListSelect == PAYMENT_CARD_METADATAS_CHOICE;
            }

            /** 
             * Get the 'PaymentCardMetadatas' element value.
             * 
             * @return value
             */
            public PaymentCardMetadatas getPaymentCardMetadatas() {
                return paymentCardMetadatas;
            }

            /** 
             * Set the 'PaymentCardMetadatas' element value.
             * 
             * @param paymentCardMetadatas
             */
            public void setPaymentCardMetadatas(
                    PaymentCardMetadatas paymentCardMetadatas) {
                setOtherMetadataListSelect(PAYMENT_CARD_METADATAS_CHOICE);
                this.paymentCardMetadatas = paymentCardMetadatas;
            }

            /** 
             * Check if PaymentFormMetadatas is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifPaymentFormMetadatas() {
                return otherMetadataListSelect == PAYMENT_FORM_METADATAS_CHOICE;
            }

            /** 
             * Get the 'PaymentFormMetadatas' element value.
             * 
             * @return value
             */
            public PaymentFormMetadatas getPaymentFormMetadatas() {
                return paymentFormMetadatas;
            }

            /** 
             * Set the 'PaymentFormMetadatas' element value.
             * 
             * @param paymentFormMetadatas
             */
            public void setPaymentFormMetadatas(
                    PaymentFormMetadatas paymentFormMetadatas) {
                setOtherMetadataListSelect(PAYMENT_FORM_METADATAS_CHOICE);
                this.paymentFormMetadatas = paymentFormMetadatas;
            }

            /** 
             * Check if PriceMetadatas is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifPriceMetadatas() {
                return otherMetadataListSelect == PRICE_METADATAS_CHOICE;
            }

            /** 
             * Get the 'PriceMetadatas' element value.
             * 
             * @return value
             */
            public PriceMetadatas getPriceMetadatas() {
                return priceMetadatas;
            }

            /** 
             * Set the 'PriceMetadatas' element value.
             * 
             * @param priceMetadatas
             */
            public void setPriceMetadatas(PriceMetadatas priceMetadatas) {
                setOtherMetadataListSelect(PRICE_METADATAS_CHOICE);
                this.priceMetadatas = priceMetadatas;
            }

            /** 
             * Check if RuleMetadatas is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifRuleMetadatas() {
                return otherMetadataListSelect == RULE_METADATAS_CHOICE;
            }

            /** 
             * Get the 'RuleMetadatas' element value.
             * 
             * @return value
             */
            public RuleMetadatas getRuleMetadatas() {
                return ruleMetadatas;
            }

            /** 
             * Set the 'RuleMetadatas' element value.
             * 
             * @param ruleMetadatas
             */
            public void setRuleMetadatas(RuleMetadatas ruleMetadatas) {
                setOtherMetadataListSelect(RULE_METADATAS_CHOICE);
                this.ruleMetadatas = ruleMetadatas;
            }

            /** 
             * Check if StateProvMetadatas is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifStateProvMetadatas() {
                return otherMetadataListSelect == STATE_PROV_METADATAS_CHOICE;
            }

            /** 
             * Get the 'StateProvMetadatas' element value.
             * 
             * @return value
             */
            public StateProvMetadatas getStateProvMetadatas() {
                return stateProvMetadatas;
            }

            /** 
             * Set the 'StateProvMetadatas' element value.
             * 
             * @param stateProvMetadatas
             */
            public void setStateProvMetadatas(
                    StateProvMetadatas stateProvMetadatas) {
                setOtherMetadataListSelect(STATE_PROV_METADATAS_CHOICE);
                this.stateProvMetadatas = stateProvMetadatas;
            }

            /** 
             * Check if ZoneMetadatas is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifZoneMetadatas() {
                return otherMetadataListSelect == ZONE_METADATAS_CHOICE;
            }

            /** 
             * Get the 'ZoneMetadatas' element value.
             * 
             * @return value
             */
            public ZoneMetadatas getZoneMetadatas() {
                return zoneMetadatas;
            }

            /** 
             * Set the 'ZoneMetadatas' element value.
             * 
             * @param zoneMetadatas
             */
            public void setZoneMetadatas(ZoneMetadatas zoneMetadatas) {
                setOtherMetadataListSelect(ZONE_METADATAS_CHOICE);
                this.zoneMetadatas = zoneMetadatas;
            }

            /** 
             * Check if AddressMetadatas is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifAddressMetadatas() {
                return otherMetadataListSelect == ADDRESS_METADATAS_CHOICE;
            }

            /** 
             * Get the 'AddressMetadatas' element value.
             * 
             * @return value
             */
            public AddressMetadatas getAddressMetadatas() {
                return addressMetadatas;
            }

            /** 
             * Set the 'AddressMetadatas' element value.
             * 
             * @param addressMetadatas
             */
            public void setAddressMetadatas(AddressMetadatas addressMetadatas) {
                setOtherMetadataListSelect(ADDRESS_METADATAS_CHOICE);
                this.addressMetadatas = addressMetadatas;
            }
        }
    }
}
