
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for Core Airline Representation.

 Notes:
 1. This type contains the common properties for all defined Airline Supplier Role definitions, e.g. POA, Operating Carrier.
 2. This type is derived from SupplierCoreRepType.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirlineCoreRepType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="SupplierCoreRepType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="AirlineID"/>
 *         &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirlineCoreRepType extends SupplierCoreRepType implements
    Serializable
{
    private AirlineIDType airlineID;
    private String name;

    /** 
     * Get the 'AirlineID' element value.
     * 
     * @return value
     */
    public AirlineIDType getAirlineID() {
        return airlineID;
    }

    /** 
     * Set the 'AirlineID' element value.
     * 
     * @param airlineID
     */
    public void setAirlineID(AirlineIDType airlineID) {
        this.airlineID = airlineID;
    }

    /** 
     * Get the 'Name' element value. Airline Name. Example: British Airways
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Airline Name. Example: British Airways
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }
}
