
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A base type for an Object with Instance Associations.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociatedObjectBaseType">
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="ApproxInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="RefundAllInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="ExemptAllInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="AllGuaranteeInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="DisclosureInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="BrowserInd"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class AssociatedObjectBaseType implements Serializable
{
    private String refs;
    private Boolean approxInd;
    private Boolean refundAllInd;
    private Boolean exemptAllInd;
    private Boolean allGuaranteeInd;
    private Boolean disclosureInd;
    private Boolean browserInd;

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'ApproxInd' attribute value. When true, this fee is approximate.
     * 
     * @return value
     */
    public Boolean getApproxInd() {
        return approxInd;
    }

    /** 
     * Set the 'ApproxInd' attribute value. When true, this fee is approximate.
     * 
     * @param approxInd
     */
    public void setApproxInd(Boolean approxInd) {
        this.approxInd = approxInd;
    }

    /** 
     * Get the 'RefundAllInd' attribute value. When true, all fee amounts are refundable.
     * 
     * @return value
     */
    public Boolean getRefundAllInd() {
        return refundAllInd;
    }

    /** 
     * Set the 'RefundAllInd' attribute value. When true, all fee amounts are refundable.
     * 
     * @param refundAllInd
     */
    public void setRefundAllInd(Boolean refundAllInd) {
        this.refundAllInd = refundAllInd;
    }

    /** 
     * Get the 'ExemptAllInd' attribute value. When true, price is exempt from all taxes.
     * 
     * @return value
     */
    public Boolean getExemptAllInd() {
        return exemptAllInd;
    }

    /** 
     * Set the 'ExemptAllInd' attribute value. When true, price is exempt from all taxes.
     * 
     * @param exemptAllInd
     */
    public void setExemptAllInd(Boolean exemptAllInd) {
        this.exemptAllInd = exemptAllInd;
    }

    /** 
     * Get the 'AllGuaranteeInd' attribute value. When true, ALL associated inventory has been guaranteed for this and the guarantee information specified in the InventoryGuarantee node.
     * 
     * @return value
     */
    public Boolean getAllGuaranteeInd() {
        return allGuaranteeInd;
    }

    /** 
     * Set the 'AllGuaranteeInd' attribute value. When true, ALL associated inventory has been guaranteed for this and the guarantee information specified in the InventoryGuarantee node.
     * 
     * @param allGuaranteeInd
     */
    public void setAllGuaranteeInd(Boolean allGuaranteeInd) {
        this.allGuaranteeInd = allGuaranteeInd;
    }

    /** 
     * Get the 'DisclosureInd' attribute value. When true, one or more associated Offer Item(s) are subject to regulatory disclosure.
     * 
     * @return value
     */
    public Boolean getDisclosureInd() {
        return disclosureInd;
    }

    /** 
     * Set the 'DisclosureInd' attribute value. When true, one or more associated Offer Item(s) are subject to regulatory disclosure.
     * 
     * @param disclosureInd
     */
    public void setDisclosureInd(Boolean disclosureInd) {
        this.disclosureInd = disclosureInd;
    }

    /** 
     * Get the 'BrowserInd' attribute value. When true, the attachment can be displayed in a browser.
     * 
     * @return value
     */
    public Boolean getBrowserInd() {
        return browserInd;
    }

    /** 
     * Set the 'BrowserInd' attribute value. When true, the attachment can be displayed in a browser.
     * 
     * @param browserInd
     */
    public void setBrowserInd(Boolean browserInd) {
        this.browserInd = browserInd;
    }
}
