
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

/** 
 * A data type definition for Commonly Used Date Representation Formats: Short Date, Date and Time, Timestamp
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AttrCoreDateGrpType">
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="DateTime"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="ShortDate"/>
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="Timestamp"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Time"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class AttrCoreDateGrpType implements Serializable
{
    private DateTime dateTime;
    private LocalDate shortDate;
    private DateTime timestamp;
    private String time;

    /** 
     * Get the 'DateTime' attribute value. Date and time. Example: 2017-01-03T13:20:00
     * 
     * @return value
     */
    public DateTime getDateTime() {
        return dateTime;
    }

    /** 
     * Set the 'DateTime' attribute value. Date and time. Example: 2017-01-03T13:20:00
     * 
     * @param dateTime
     */
    public void setDateTime(DateTime dateTime) {
        this.dateTime = dateTime;
    }

    /** 
     * Get the 'ShortDate' attribute value. Short date. Example: 2017-01-13

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @return value
     */
    public LocalDate getShortDate() {
        return shortDate;
    }

    /** 
     * Set the 'ShortDate' attribute value. Short date. Example: 2017-01-13

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @param shortDate
     */
    public void setShortDate(LocalDate shortDate) {
        this.shortDate = shortDate;
    }

    /** 
     * Get the 'Timestamp' attribute value. Timestamp. Example: 2017-01-13T13:59:38Z
     * 
     * @return value
     */
    public DateTime getTimestamp() {
        return timestamp;
    }

    /** 
     * Set the 'Timestamp' attribute value. Timestamp. Example: 2017-01-13T13:59:38Z
     * 
     * @param timestamp
     */
    public void setTimestamp(DateTime timestamp) {
        this.timestamp = timestamp;
    }

    /** 
     * Get the 'Time' attribute value. Time. Example: 14:00

    [Encoding Scheme] ISO 8601 Military/ 24 Hour (HH:MM)
     * 
     * @return value
     */
    public String getTime() {
        return time;
    }

    /** 
     * Set the 'Time' attribute value. Time. Example: 14:00

    [Encoding Scheme] ISO 8601 Military/ 24 Hour (HH:MM)
     * 
     * @param time
     */
    public void setTime(String time) {
        this.time = time;
    }
}
