
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * A data type definition for Augmentation Point.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AugPointType">
 *   &lt;xs:sequence>
 *     &lt;xs:choice>
 *       &lt;xs:element ref="ns:FareRefKey" minOccurs="0"/>
 *       &lt;xs:element ref="ns:SpecialServiceRequest" minOccurs="0"/>
 *       &lt;xs:element ref="ns:OtherServiceInformation" minOccurs="0"/>
 *       &lt;xs:element ref="ns:ClassOfService" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Diagnostics" minOccurs="0"/>
 *       &lt;xs:element ref="ns:CurrencyCode" minOccurs="0"/>
 *       &lt;xs:element ref="ns:LoyaltyAccrual" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Combinability" minOccurs="0"/>
 *       &lt;xs:element ref="ns:FeeGroup" minOccurs="0"/>
 *       &lt;xs:element ref="ns:ReferenceKey" minOccurs="0"/>
 *       &lt;xs:element ref="ns:DisplayFareComponentPrice" minOccurs="0"/>
 *       &lt;xs:element ref="ns:DisplayFareComponentPenalty" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Vouchers" minOccurs="0"/>
 *       &lt;xs:element ref="ns:ReferenceNumber" minOccurs="0"/>
 *       &lt;xs:element ref="ns:TicketingDateTime" minOccurs="0"/>
 *       &lt;xs:element ref="ns:AliasCVV" minOccurs="0"/>
 *       &lt;xs:element ref="ns:TourCode" minOccurs="0"/>
 *       &lt;xs:element ref="ns:WaiverCode" minOccurs="0"/>
 *       &lt;xs:element ref="ns:CustomParams" minOccurs="0"/>
 *       &lt;xs:element ref="ns:CCApprovalCode" minOccurs="0"/>
 *       &lt;xs:element ref="ns:OrderCommission" minOccurs="0"/>
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Key"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Owner"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="Seq"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AugPointType implements Serializable
{
    private int choiceSelect = -1;
    private static final int FARE_REF_KEY_CHOICE = 0;
    private static final int SPECIAL_SERVICE_REQUEST_CHOICE = 1;
    private static final int OTHER_SERVICE_INFORMATION_CHOICE = 2;
    private static final int CLASS_OF_SERVICE_CHOICE = 3;
    private static final int DIAGNOSTICS_CHOICE = 4;
    private static final int CURRENCY_CODE_CHOICE = 5;
    private static final int LOYALTY_ACCRUAL_CHOICE = 6;
    private static final int COMBINABILITY_CHOICE = 7;
    private static final int FEE_GROUP_CHOICE = 8;
    private static final int REFERENCE_KEY_CHOICE = 9;
    private static final int DISPLAY_FARE_COMPONENT_PRICE_CHOICE = 10;
    private static final int DISPLAY_FARE_COMPONENT_PENALTY_CHOICE = 11;
    private static final int VOUCHERS_CHOICE = 12;
    private static final int REFERENCE_NUMBER_CHOICE = 13;
    private static final int TICKETING_DATE_TIME_CHOICE = 14;
    private static final int ALIAS_CVV_CHOICE = 15;
    private static final int TOUR_CODE_CHOICE = 16;
    private static final int WAIVER_CODE_CHOICE = 17;
    private static final int CUSTOM_PARAMS_CHOICE = 18;
    private static final int CC_APPROVAL_CODE_CHOICE = 19;
    private static final int ORDER_COMMISSION_CHOICE = 20;
    private FareRefKey fareRefKey;
    private SpecialServiceRequest specialServiceRequest;
    private OtherServiceInformation otherServiceInformation;
    private ClassOfService classOfService;
    private Diagnostics diagnostics;
    private CurrencyCode currencyCode;
    private LoyaltyAccrual loyaltyAccrual;
    private Combinability combinability;
    private FeeGroup feeGroup;
    private ReferenceKey referenceKey;
    private DisplayFareComponentPrice displayFareComponentPrice;
    private DisplayFareComponentPenalty displayFareComponentPenalty;
    private Vouchers vouchers;
    private ReferenceNumber referenceNumber;
    private TicketingDateTime ticketingDateTime;
    private AliasCVV aliasCVV;
    private TourCode1 tourCode;
    private WaiverCode waiverCode;
    private CustomParams customParams;
    private CCApprovalCode CCApprovalCode;
    private OrderCommission orderCommission;
    private String key;
    private String owner;
    private BigInteger seq;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if FareRefKey is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFareRefKey() {
        return choiceSelect == FARE_REF_KEY_CHOICE;
    }

    /** 
     * Get the 'FareRefKey' element value.
     * 
     * @return value
     */
    public FareRefKey getFareRefKey() {
        return fareRefKey;
    }

    /** 
     * Set the 'FareRefKey' element value.
     * 
     * @param fareRefKey
     */
    public void setFareRefKey(FareRefKey fareRefKey) {
        setChoiceSelect(FARE_REF_KEY_CHOICE);
        this.fareRefKey = fareRefKey;
    }

    /** 
     * Check if SpecialServiceRequest is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSpecialServiceRequest() {
        return choiceSelect == SPECIAL_SERVICE_REQUEST_CHOICE;
    }

    /** 
     * Get the 'SpecialServiceRequest' element value.
     * 
     * @return value
     */
    public SpecialServiceRequest getSpecialServiceRequest() {
        return specialServiceRequest;
    }

    /** 
     * Set the 'SpecialServiceRequest' element value.
     * 
     * @param specialServiceRequest
     */
    public void setSpecialServiceRequest(
            SpecialServiceRequest specialServiceRequest) {
        setChoiceSelect(SPECIAL_SERVICE_REQUEST_CHOICE);
        this.specialServiceRequest = specialServiceRequest;
    }

    /** 
     * Check if OtherServiceInformation is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOtherServiceInformation() {
        return choiceSelect == OTHER_SERVICE_INFORMATION_CHOICE;
    }

    /** 
     * Get the 'OtherServiceInformation' element value.
     * 
     * @return value
     */
    public OtherServiceInformation getOtherServiceInformation() {
        return otherServiceInformation;
    }

    /** 
     * Set the 'OtherServiceInformation' element value.
     * 
     * @param otherServiceInformation
     */
    public void setOtherServiceInformation(
            OtherServiceInformation otherServiceInformation) {
        setChoiceSelect(OTHER_SERVICE_INFORMATION_CHOICE);
        this.otherServiceInformation = otherServiceInformation;
    }

    /** 
     * Check if ClassOfService is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifClassOfService() {
        return choiceSelect == CLASS_OF_SERVICE_CHOICE;
    }

    /** 
     * Get the 'ClassOfService' element value.
     * 
     * @return value
     */
    public ClassOfService getClassOfService() {
        return classOfService;
    }

    /** 
     * Set the 'ClassOfService' element value.
     * 
     * @param classOfService
     */
    public void setClassOfService(ClassOfService classOfService) {
        setChoiceSelect(CLASS_OF_SERVICE_CHOICE);
        this.classOfService = classOfService;
    }

    /** 
     * Check if Diagnostics is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDiagnostics() {
        return choiceSelect == DIAGNOSTICS_CHOICE;
    }

    /** 
     * Get the 'Diagnostics' element value.
     * 
     * @return value
     */
    public Diagnostics getDiagnostics() {
        return diagnostics;
    }

    /** 
     * Set the 'Diagnostics' element value.
     * 
     * @param diagnostics
     */
    public void setDiagnostics(Diagnostics diagnostics) {
        setChoiceSelect(DIAGNOSTICS_CHOICE);
        this.diagnostics = diagnostics;
    }

    /** 
     * Check if CurrencyCode is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCurrencyCode() {
        return choiceSelect == CURRENCY_CODE_CHOICE;
    }

    /** 
     * Get the 'CurrencyCode' element value.
     * 
     * @return value
     */
    public CurrencyCode getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(CurrencyCode currencyCode) {
        setChoiceSelect(CURRENCY_CODE_CHOICE);
        this.currencyCode = currencyCode;
    }

    /** 
     * Check if LoyaltyAccrual is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifLoyaltyAccrual() {
        return choiceSelect == LOYALTY_ACCRUAL_CHOICE;
    }

    /** 
     * Get the 'LoyaltyAccrual' element value.
     * 
     * @return value
     */
    public LoyaltyAccrual getLoyaltyAccrual() {
        return loyaltyAccrual;
    }

    /** 
     * Set the 'LoyaltyAccrual' element value.
     * 
     * @param loyaltyAccrual
     */
    public void setLoyaltyAccrual(LoyaltyAccrual loyaltyAccrual) {
        setChoiceSelect(LOYALTY_ACCRUAL_CHOICE);
        this.loyaltyAccrual = loyaltyAccrual;
    }

    /** 
     * Check if Combinability is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCombinability() {
        return choiceSelect == COMBINABILITY_CHOICE;
    }

    /** 
     * Get the 'Combinability' element value.
     * 
     * @return value
     */
    public Combinability getCombinability() {
        return combinability;
    }

    /** 
     * Set the 'Combinability' element value.
     * 
     * @param combinability
     */
    public void setCombinability(Combinability combinability) {
        setChoiceSelect(COMBINABILITY_CHOICE);
        this.combinability = combinability;
    }

    /** 
     * Check if FeeGroup is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFeeGroup() {
        return choiceSelect == FEE_GROUP_CHOICE;
    }

    /** 
     * Get the 'FeeGroup' element value.
     * 
     * @return value
     */
    public FeeGroup getFeeGroup() {
        return feeGroup;
    }

    /** 
     * Set the 'FeeGroup' element value.
     * 
     * @param feeGroup
     */
    public void setFeeGroup(FeeGroup feeGroup) {
        setChoiceSelect(FEE_GROUP_CHOICE);
        this.feeGroup = feeGroup;
    }

    /** 
     * Check if ReferenceKey is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifReferenceKey() {
        return choiceSelect == REFERENCE_KEY_CHOICE;
    }

    /** 
     * Get the 'ReferenceKey' element value.
     * 
     * @return value
     */
    public ReferenceKey getReferenceKey() {
        return referenceKey;
    }

    /** 
     * Set the 'ReferenceKey' element value.
     * 
     * @param referenceKey
     */
    public void setReferenceKey(ReferenceKey referenceKey) {
        setChoiceSelect(REFERENCE_KEY_CHOICE);
        this.referenceKey = referenceKey;
    }

    /** 
     * Check if DisplayFareComponentPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDisplayFareComponentPrice() {
        return choiceSelect == DISPLAY_FARE_COMPONENT_PRICE_CHOICE;
    }

    /** 
     * Get the 'DisplayFareComponentPrice' element value.
     * 
     * @return value
     */
    public DisplayFareComponentPrice getDisplayFareComponentPrice() {
        return displayFareComponentPrice;
    }

    /** 
     * Set the 'DisplayFareComponentPrice' element value.
     * 
     * @param displayFareComponentPrice
     */
    public void setDisplayFareComponentPrice(
            DisplayFareComponentPrice displayFareComponentPrice) {
        setChoiceSelect(DISPLAY_FARE_COMPONENT_PRICE_CHOICE);
        this.displayFareComponentPrice = displayFareComponentPrice;
    }

    /** 
     * Check if DisplayFareComponentPenalty is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDisplayFareComponentPenalty() {
        return choiceSelect == DISPLAY_FARE_COMPONENT_PENALTY_CHOICE;
    }

    /** 
     * Get the 'DisplayFareComponentPenalty' element value.
     * 
     * @return value
     */
    public DisplayFareComponentPenalty getDisplayFareComponentPenalty() {
        return displayFareComponentPenalty;
    }

    /** 
     * Set the 'DisplayFareComponentPenalty' element value.
     * 
     * @param displayFareComponentPenalty
     */
    public void setDisplayFareComponentPenalty(
            DisplayFareComponentPenalty displayFareComponentPenalty) {
        setChoiceSelect(DISPLAY_FARE_COMPONENT_PENALTY_CHOICE);
        this.displayFareComponentPenalty = displayFareComponentPenalty;
    }

    /** 
     * Check if Vouchers is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifVouchers() {
        return choiceSelect == VOUCHERS_CHOICE;
    }

    /** 
     * Get the 'Vouchers' element value.
     * 
     * @return value
     */
    public Vouchers getVouchers() {
        return vouchers;
    }

    /** 
     * Set the 'Vouchers' element value.
     * 
     * @param vouchers
     */
    public void setVouchers(Vouchers vouchers) {
        setChoiceSelect(VOUCHERS_CHOICE);
        this.vouchers = vouchers;
    }

    /** 
     * Check if ReferenceNumber is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifReferenceNumber() {
        return choiceSelect == REFERENCE_NUMBER_CHOICE;
    }

    /** 
     * Get the 'ReferenceNumber' element value.
     * 
     * @return value
     */
    public ReferenceNumber getReferenceNumber() {
        return referenceNumber;
    }

    /** 
     * Set the 'ReferenceNumber' element value.
     * 
     * @param referenceNumber
     */
    public void setReferenceNumber(ReferenceNumber referenceNumber) {
        setChoiceSelect(REFERENCE_NUMBER_CHOICE);
        this.referenceNumber = referenceNumber;
    }

    /** 
     * Check if TicketingDateTime is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTicketingDateTime() {
        return choiceSelect == TICKETING_DATE_TIME_CHOICE;
    }

    /** 
     * Get the 'TicketingDateTime' element value.
     * 
     * @return value
     */
    public TicketingDateTime getTicketingDateTime() {
        return ticketingDateTime;
    }

    /** 
     * Set the 'TicketingDateTime' element value.
     * 
     * @param ticketingDateTime
     */
    public void setTicketingDateTime(TicketingDateTime ticketingDateTime) {
        setChoiceSelect(TICKETING_DATE_TIME_CHOICE);
        this.ticketingDateTime = ticketingDateTime;
    }

    /** 
     * Check if AliasCVV is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAliasCVV() {
        return choiceSelect == ALIAS_CVV_CHOICE;
    }

    /** 
     * Get the 'AliasCVV' element value.
     * 
     * @return value
     */
    public AliasCVV getAliasCVV() {
        return aliasCVV;
    }

    /** 
     * Set the 'AliasCVV' element value.
     * 
     * @param aliasCVV
     */
    public void setAliasCVV(AliasCVV aliasCVV) {
        setChoiceSelect(ALIAS_CVV_CHOICE);
        this.aliasCVV = aliasCVV;
    }

    /** 
     * Check if TourCode is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTourCode() {
        return choiceSelect == TOUR_CODE_CHOICE;
    }

    /** 
     * Get the 'TourCode' element value.
     * 
     * @return value
     */
    public TourCode1 getTourCode() {
        return tourCode;
    }

    /** 
     * Set the 'TourCode' element value.
     * 
     * @param tourCode
     */
    public void setTourCode(TourCode1 tourCode) {
        setChoiceSelect(TOUR_CODE_CHOICE);
        this.tourCode = tourCode;
    }

    /** 
     * Check if WaiverCode is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifWaiverCode() {
        return choiceSelect == WAIVER_CODE_CHOICE;
    }

    /** 
     * Get the 'WaiverCode' element value.
     * 
     * @return value
     */
    public WaiverCode getWaiverCode() {
        return waiverCode;
    }

    /** 
     * Set the 'WaiverCode' element value.
     * 
     * @param waiverCode
     */
    public void setWaiverCode(WaiverCode waiverCode) {
        setChoiceSelect(WAIVER_CODE_CHOICE);
        this.waiverCode = waiverCode;
    }

    /** 
     * Check if CustomParams is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustomParams() {
        return choiceSelect == CUSTOM_PARAMS_CHOICE;
    }

    /** 
     * Get the 'CustomParams' element value.
     * 
     * @return value
     */
    public CustomParams getCustomParams() {
        return customParams;
    }

    /** 
     * Set the 'CustomParams' element value.
     * 
     * @param customParams
     */
    public void setCustomParams(CustomParams customParams) {
        setChoiceSelect(CUSTOM_PARAMS_CHOICE);
        this.customParams = customParams;
    }

    /** 
     * Check if CCApprovalCode is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCCApprovalCode() {
        return choiceSelect == CC_APPROVAL_CODE_CHOICE;
    }

    /** 
     * Get the 'CCApprovalCode' element value.
     * 
     * @return value
     */
    public CCApprovalCode getCCApprovalCode() {
        return CCApprovalCode;
    }

    /** 
     * Set the 'CCApprovalCode' element value.
     * 
     * @param CCApprovalCode
     */
    public void setCCApprovalCode(CCApprovalCode CCApprovalCode) {
        setChoiceSelect(CC_APPROVAL_CODE_CHOICE);
        this.CCApprovalCode = CCApprovalCode;
    }

    /** 
     * Check if OrderCommission is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOrderCommission() {
        return choiceSelect == ORDER_COMMISSION_CHOICE;
    }

    /** 
     * Get the 'OrderCommission' element value.
     * 
     * @return value
     */
    public OrderCommission getOrderCommission() {
        return orderCommission;
    }

    /** 
     * Set the 'OrderCommission' element value.
     * 
     * @param orderCommission
     */
    public void setOrderCommission(OrderCommission orderCommission) {
        setChoiceSelect(ORDER_COMMISSION_CHOICE);
        this.orderCommission = orderCommission;
    }

    /** 
     * Get the 'Key' attribute value. Globally Unique Object instance/ class Key.

    Example: 2B75C565-5BB0- 4DCE-8DE6-67CB7B4F25A7
     * 
     * @return value
     */
    public String getKey() {
        return key;
    }

    /** 
     * Set the 'Key' attribute value. Globally Unique Object instance/ class Key.

    Example: 2B75C565-5BB0- 4DCE-8DE6-67CB7B4F25A7
     * 
     * @param key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /** 
     * Get the 'Owner' attribute value. Source Entity Code or ID. Examples: BA, WIDGETCO
     * 
     * @return value
     */
    public String getOwner() {
        return owner;
    }

    /** 
     * Set the 'Owner' attribute value. Source Entity Code or ID. Examples: BA, WIDGETCO
     * 
     * @param owner
     */
    public void setOwner(String owner) {
        this.owner = owner;
    }

    /** 
     * Get the 'Seq' attribute value. Sequence ID. Example: 1
     * 
     * @return value
     */
    public BigInteger getSeq() {
        return seq;
    }

    /** 
     * Set the 'Seq' attribute value. Sequence ID. Example: 1
     * 
     * @param seq
     */
    public void setSeq(BigInteger seq) {
        this.seq = seq;
    }
}
