
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Baggage Determining Carrier as defined in resolution 722 (f), and who’s baggage rules apply.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageDeterminingCarrierType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="AirlineID"/>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BagRule" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BDC_AnalysisResult" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute name="BDC_Reason">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class BDCReason -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BaggageDeterminingCarrierType implements Serializable
{
    private AirlineIDType airlineID;
    private String name;
    private String bagRule;
    private String BDCAnalysisResult;
    private BDCReason BDCReason1;

    /** 
     * Get the 'AirlineID' element value.
     * 
     * @return value
     */
    public AirlineIDType getAirlineID() {
        return airlineID;
    }

    /** 
     * Set the 'AirlineID' element value.
     * 
     * @param airlineID
     */
    public void setAirlineID(AirlineIDType airlineID) {
        this.airlineID = airlineID;
    }

    /** 
     * Get the 'Name' element value. Airline Name.  Example: British Airways
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Airline Name.  Example: British Airways
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'BagRule' element value. US Department of Transportation (DOT) Reservation or Disclosure baggage rule.
    Examples: Y, Disclosure AND US DOT Reservation
     * 
     * @return value
     */
    public String getBagRule() {
        return bagRule;
    }

    /** 
     * Set the 'BagRule' element value. US Department of Transportation (DOT) Reservation or Disclosure baggage rule.
    Examples: Y, Disclosure AND US DOT Reservation
     * 
     * @param bagRule
     */
    public void setBagRule(String bagRule) {
        this.bagRule = bagRule;
    }

    /** 
     * Get the 'BDC_AnalysisResult' element value. In concert with BaggageDeterminingCarrier data field, specifies the reason for the carrier code in the AirlineID element.

    Encoding Scheme: IATA PADIS Code List for data element RES.

     * 
     * @return value
     */
    public String getBDCAnalysisResult() {
        return BDCAnalysisResult;
    }

    /** 
     * Set the 'BDC_AnalysisResult' element value. In concert with BaggageDeterminingCarrier data field, specifies the reason for the carrier code in the AirlineID element.

    Encoding Scheme: IATA PADIS Code List for data element RES.

     * 
     * @param BDCAnalysisResult
     */
    public void setBDCAnalysisResult(String BDCAnalysisResult) {
        this.BDCAnalysisResult = BDCAnalysisResult;
    }

    /** 
     * Get the 'BDC_Reason' attribute value. Enumeration of why this carrier is the BDC.
    1. Regulatory [Application of regulation or Resolution]
    2. Deferral [Example: Deferral by ORA]
    3. Bilateral [Bilateral agreement]

     * 
     * @return value
     */
    public BDCReason getBDCReason1() {
        return BDCReason1;
    }

    /** 
     * Set the 'BDC_Reason' attribute value. Enumeration of why this carrier is the BDC.
    1. Regulatory [Application of regulation or Resolution]
    2. Deferral [Example: Deferral by ORA]
    3. Bilateral [Bilateral agreement]

     * 
     * @param BDCReason1
     */
    public void setBDCReason1(BDCReason BDCReason1) {
        this.BDCReason1 = BDCReason1;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Regulatory"/>
     *     &lt;xs:enumeration value="Deferral"/>
     *     &lt;xs:enumeration value="Bilateral"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum BDCReason implements Serializable {
        REGULATORY("Regulatory"), DEFERRAL("Deferral"), BILATERAL("Bilateral");
        private final String value;

        private BDCReason(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static BDCReason convert(String value) {
            for (BDCReason inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
