
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Corporate Participant
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CorporateParticipant">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *       &lt;xs:element type="xs:string" name="ID"/>
 *       &lt;xs:element type="xs:string" name="CorporateCode" minOccurs="0"/>
 *       &lt;xs:element type="xs:string" name="IATA_Number" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class CorporateParticipant implements Serializable
{
    private String name;
    private String ID;
    private String corporateCode;
    private String IATANumber;

    /** 
     * Get the 'Name' element value. Corporate name 
    Example:  XYZ Corporation
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Corporate name 
    Example:  XYZ Corporation
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'ID' element value. Corporate ID
     * 
     * @return value
     */
    public String getID() {
        return ID;
    }

    /** 
     * Set the 'ID' element value. Corporate ID
     * 
     * @param ID
     */
    public void setID(String ID) {
        this.ID = ID;
    }

    /** 
     * Get the 'CorporateCode' element value. Corporate code used for pricing special fares
     * 
     * @return value
     */
    public String getCorporateCode() {
        return corporateCode;
    }

    /** 
     * Set the 'CorporateCode' element value. Corporate code used for pricing special fares
     * 
     * @param corporateCode
     */
    public void setCorporateCode(String corporateCode) {
        this.corporateCode = corporateCode;
    }

    /** 
     * Get the 'IATA_Number' element value. Agency Seller IATA number. Example: 98417900
     * 
     * @return value
     */
    public String getIATANumber() {
        return IATANumber;
    }

    /** 
     * Set the 'IATA_Number' element value. Agency Seller IATA number. Example: 98417900
     * 
     * @param IATANumber
     */
    public void setIATANumber(String IATANumber) {
        this.IATANumber = IATANumber;
    }
}
