
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for a Coupon Purpose.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CouponPurposeListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Additional"/>
 *     &lt;xs:enumeration value="Base"/>
 *     &lt;xs:enumeration value="Net"/>
 *     &lt;xs:enumeration value="Refund"/>
 *     &lt;xs:enumeration value="Sell"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CouponPurposeListType implements Serializable {
    ADDITIONAL("Additional"), BASE("Base"), NET("Net"), REFUND("Refund"), SELL(
            "Sell");
    private final String value;

    private CouponPurposeListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static CouponPurposeListType convert(String value) {
        for (CouponPurposeListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
