
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * This data is only available on a bilateral basis. Please consult Farelogix or your airline to verify if the node is supported.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomParams">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Param" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Param -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class CustomParams implements Serializable
{
    private List<Param> paramList = new ArrayList<Param>();

    /** 
     * Get the list of 'Param' element items.
     * 
     * @return list
     */
    public List<Param> getParamList() {
        return paramList;
    }

    /** 
     * Set the list of 'Param' element items.
     * 
     * @param list
     */
    public void setParamList(List<Param> list) {
        paramList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Param" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Value"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:anySimpleType" use="required" name="Name"/>
     *     &lt;xs:attribute type="xs:anySimpleType" name="TRef"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Param implements Serializable
    {
        private String name;
        private String TRef;

        /** 
         * Get the 'Name' attribute value.
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' attribute value.
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }

        /** 
         * Get the 'TRef' attribute value. Traveler Association. Example: T1
         * 
         * @return value
         */
        public String getTRef() {
            return TRef;
        }

        /** 
         * Set the 'TRef' attribute value. Traveler Association. Example: T1
         * 
         * @param TRef
         */
        public void setTRef(String TRef) {
            this.TRef = TRef;
        }
    }
}
