
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Common NDC Data List choices.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataListType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="BagDisclosureList" minOccurs="0"/>
 *     &lt;xs:element name="BaggageAllowanceList" minOccurs="0">
 *       &lt;!-- Reference to inner class BaggageAllowanceList -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="ClassOfServiceList" minOccurs="0"/>
 *     &lt;xs:element ref="ContentSourceList" minOccurs="0"/>
 *     &lt;xs:element name="DescriptionList" minOccurs="0">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element ref="Description"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element ref="DisclosureList" minOccurs="0"/>
 *     &lt;xs:element ref="FareList" minOccurs="0"/>
 *     &lt;xs:element name="FlightSegmentList" minOccurs="0">
 *       &lt;!-- Reference to inner class FlightSegmentList -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="FlightList" minOccurs="0">
 *       &lt;!-- Reference to inner class FlightList -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="OriginDestinationList" minOccurs="0">
 *       &lt;!-- Reference to inner class OriginDestinationList -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="InstructionsList" minOccurs="0"/>
 *     &lt;xs:element ref="MediaList" minOccurs="0"/>
 *     &lt;xs:element ref="PenaltyList" minOccurs="0"/>
 *     &lt;xs:element ref="PriceClassList" minOccurs="0"/>
 *     &lt;xs:element ref="ServiceBundleList" minOccurs="0"/>
 *     &lt;xs:element ref="ServiceList" minOccurs="0"/>
 *     &lt;xs:element ref="TermsList" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DataListType implements Serializable
{
    private ListOfBagDisclosureType bagDisclosureList;
    private BaggageAllowanceList baggageAllowanceList;
    private ListOfClassOfServiceType classOfServiceList;
    private ListOfContentSourceType contentSourceList;
    private Description descriptionList;
    private ListOfDisclosureType disclosureList;
    private FareList fareList;
    private FlightSegmentList flightSegmentList;
    private FlightList flightList;
    private OriginDestinationList originDestinationList;
    private ListOfOfferInstructionsType instructionsList;
    private ListOfMediaType mediaList;
    private ListOfOfferPenaltyType penaltyList;
    private ListOfPriceClassType priceClassList;
    private ListOfServiceBundleType serviceBundleList;
    private ServiceList serviceList;
    private ListOfOfferTermsType termsList;

    /** 
     * Get the 'BagDisclosureList' element value.
     * 
     * @return value
     */
    public ListOfBagDisclosureType getBagDisclosureList() {
        return bagDisclosureList;
    }

    /** 
     * Set the 'BagDisclosureList' element value.
     * 
     * @param bagDisclosureList
     */
    public void setBagDisclosureList(ListOfBagDisclosureType bagDisclosureList) {
        this.bagDisclosureList = bagDisclosureList;
    }

    /** 
     * Get the 'BaggageAllowanceList' element value.
     * 
     * @return value
     */
    public BaggageAllowanceList getBaggageAllowanceList() {
        return baggageAllowanceList;
    }

    /** 
     * Set the 'BaggageAllowanceList' element value.
     * 
     * @param baggageAllowanceList
     */
    public void setBaggageAllowanceList(
            BaggageAllowanceList baggageAllowanceList) {
        this.baggageAllowanceList = baggageAllowanceList;
    }

    /** 
     * Get the 'ClassOfServiceList' element value.
     * 
     * @return value
     */
    public ListOfClassOfServiceType getClassOfServiceList() {
        return classOfServiceList;
    }

    /** 
     * Set the 'ClassOfServiceList' element value.
     * 
     * @param classOfServiceList
     */
    public void setClassOfServiceList(
            ListOfClassOfServiceType classOfServiceList) {
        this.classOfServiceList = classOfServiceList;
    }

    /** 
     * Get the 'ContentSourceList' element value.
     * 
     * @return value
     */
    public ListOfContentSourceType getContentSourceList() {
        return contentSourceList;
    }

    /** 
     * Set the 'ContentSourceList' element value.
     * 
     * @param contentSourceList
     */
    public void setContentSourceList(ListOfContentSourceType contentSourceList) {
        this.contentSourceList = contentSourceList;
    }

    /** 
     * Get the 'Description' element value. Description Details
     * 
     * @return value
     */
    public Description getDescriptionList() {
        return descriptionList;
    }

    /** 
     * Set the 'Description' element value. Description Details
     * 
     * @param descriptionList
     */
    public void setDescriptionList(Description descriptionList) {
        this.descriptionList = descriptionList;
    }

    /** 
     * Get the 'DisclosureList' element value.
     * 
     * @return value
     */
    public ListOfDisclosureType getDisclosureList() {
        return disclosureList;
    }

    /** 
     * Set the 'DisclosureList' element value.
     * 
     * @param disclosureList
     */
    public void setDisclosureList(ListOfDisclosureType disclosureList) {
        this.disclosureList = disclosureList;
    }

    /** 
     * Get the 'FareList' element value.
     * 
     * @return value
     */
    public FareList getFareList() {
        return fareList;
    }

    /** 
     * Set the 'FareList' element value.
     * 
     * @param fareList
     */
    public void setFareList(FareList fareList) {
        this.fareList = fareList;
    }

    /** 
     * Get the 'FlightSegmentList' element value.
     * 
     * @return value
     */
    public FlightSegmentList getFlightSegmentList() {
        return flightSegmentList;
    }

    /** 
     * Set the 'FlightSegmentList' element value.
     * 
     * @param flightSegmentList
     */
    public void setFlightSegmentList(FlightSegmentList flightSegmentList) {
        this.flightSegmentList = flightSegmentList;
    }

    /** 
     * Get the 'FlightList' element value.
     * 
     * @return value
     */
    public FlightList getFlightList() {
        return flightList;
    }

    /** 
     * Set the 'FlightList' element value.
     * 
     * @param flightList
     */
    public void setFlightList(FlightList flightList) {
        this.flightList = flightList;
    }

    /** 
     * Get the 'OriginDestinationList' element value.
     * 
     * @return value
     */
    public OriginDestinationList getOriginDestinationList() {
        return originDestinationList;
    }

    /** 
     * Set the 'OriginDestinationList' element value.
     * 
     * @param originDestinationList
     */
    public void setOriginDestinationList(
            OriginDestinationList originDestinationList) {
        this.originDestinationList = originDestinationList;
    }

    /** 
     * Get the 'InstructionsList' element value.
     * 
     * @return value
     */
    public ListOfOfferInstructionsType getInstructionsList() {
        return instructionsList;
    }

    /** 
     * Set the 'InstructionsList' element value.
     * 
     * @param instructionsList
     */
    public void setInstructionsList(ListOfOfferInstructionsType instructionsList) {
        this.instructionsList = instructionsList;
    }

    /** 
     * Get the 'MediaList' element value.
     * 
     * @return value
     */
    public ListOfMediaType getMediaList() {
        return mediaList;
    }

    /** 
     * Set the 'MediaList' element value.
     * 
     * @param mediaList
     */
    public void setMediaList(ListOfMediaType mediaList) {
        this.mediaList = mediaList;
    }

    /** 
     * Get the 'PenaltyList' element value.
     * 
     * @return value
     */
    public ListOfOfferPenaltyType getPenaltyList() {
        return penaltyList;
    }

    /** 
     * Set the 'PenaltyList' element value.
     * 
     * @param penaltyList
     */
    public void setPenaltyList(ListOfOfferPenaltyType penaltyList) {
        this.penaltyList = penaltyList;
    }

    /** 
     * Get the 'PriceClassList' element value.
     * 
     * @return value
     */
    public ListOfPriceClassType getPriceClassList() {
        return priceClassList;
    }

    /** 
     * Set the 'PriceClassList' element value.
     * 
     * @param priceClassList
     */
    public void setPriceClassList(ListOfPriceClassType priceClassList) {
        this.priceClassList = priceClassList;
    }

    /** 
     * Get the 'ServiceBundleList' element value.
     * 
     * @return value
     */
    public ListOfServiceBundleType getServiceBundleList() {
        return serviceBundleList;
    }

    /** 
     * Set the 'ServiceBundleList' element value.
     * 
     * @param serviceBundleList
     */
    public void setServiceBundleList(ListOfServiceBundleType serviceBundleList) {
        this.serviceBundleList = serviceBundleList;
    }

    /** 
     * Get the 'ServiceList' element value.
     * 
     * @return value
     */
    public ServiceList getServiceList() {
        return serviceList;
    }

    /** 
     * Set the 'ServiceList' element value.
     * 
     * @param serviceList
     */
    public void setServiceList(ServiceList serviceList) {
        this.serviceList = serviceList;
    }

    /** 
     * Get the 'TermsList' element value.
     * 
     * @return value
     */
    public ListOfOfferTermsType getTermsList() {
        return termsList;
    }

    /** 
     * Set the 'TermsList' element value.
     * 
     * @param termsList
     */
    public void setTermsList(ListOfOfferTermsType termsList) {
        this.termsList = termsList;
    }
    /** 
     * Checked or Carry-On Baggage Allowance detail. Use BaggageCategory to specify which of the two.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageAllowanceList" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="BaggageAllowance" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class BaggageAllowance -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BaggageAllowanceList implements Serializable
    {
        private List<BaggageAllowance> baggageAllowanceList = new ArrayList<BaggageAllowance>();

        /** 
         * Get the list of 'BaggageAllowance' element items.
         * 
         * @return list
         */
        public List<BaggageAllowance> getBaggageAllowanceList() {
            return baggageAllowanceList;
        }

        /** 
         * Set the list of 'BaggageAllowance' element items.
         * 
         * @param list
         */
        public void setBaggageAllowanceList(List<BaggageAllowance> list) {
            baggageAllowanceList = list;
        }
        /** 
         * Checked or Carry-On Baggage Allowance detail. Use BaggageCategory to specify which of the two.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageAllowance" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="BaggageCategoryListType" name="BaggageCategory"/>
         *       &lt;xs:element ref="AllowanceDescription" minOccurs="0"/>
         *       &lt;xs:element ref="DimensionAllowance" minOccurs="0"/>
         *       &lt;xs:element ref="PieceAllowance" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element ref="WeightAllowance" minOccurs="0"/>
         *       &lt;xs:element type="BaggageDeterminingCarrierType" name="BaggageDeterminingCarrier" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="required" name="BaggageAllowanceID"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BaggageAllowance implements Serializable
        {
            private BaggageCategoryListType baggageCategory;
            private BagAllowanceDescType allowanceDescription;
            private BagAllowanceDimensionType dimensionAllowance;
            private List<BagAllowancePieceType> pieceAllowanceList = new ArrayList<BagAllowancePieceType>();
            private WeightAllowance weightAllowance;
            private BaggageDeterminingCarrierType baggageDeterminingCarrier;
            private String baggageAllowanceID;

            /** 
             * Get the 'BaggageCategory' element value. Enumeration:

            CarryOn
            Checked
             * 
             * @return value
             */
            public BaggageCategoryListType getBaggageCategory() {
                return baggageCategory;
            }

            /** 
             * Set the 'BaggageCategory' element value. Enumeration:

            CarryOn
            Checked
             * 
             * @param baggageCategory
             */
            public void setBaggageCategory(
                    BaggageCategoryListType baggageCategory) {
                this.baggageCategory = baggageCategory;
            }

            /** 
             * Get the 'AllowanceDescription' element value.
             * 
             * @return value
             */
            public BagAllowanceDescType getAllowanceDescription() {
                return allowanceDescription;
            }

            /** 
             * Set the 'AllowanceDescription' element value.
             * 
             * @param allowanceDescription
             */
            public void setAllowanceDescription(
                    BagAllowanceDescType allowanceDescription) {
                this.allowanceDescription = allowanceDescription;
            }

            /** 
             * Get the 'DimensionAllowance' element value.
             * 
             * @return value
             */
            public BagAllowanceDimensionType getDimensionAllowance() {
                return dimensionAllowance;
            }

            /** 
             * Set the 'DimensionAllowance' element value.
             * 
             * @param dimensionAllowance
             */
            public void setDimensionAllowance(
                    BagAllowanceDimensionType dimensionAllowance) {
                this.dimensionAllowance = dimensionAllowance;
            }

            /** 
             * Get the list of 'PieceAllowance' element items.
             * 
             * @return list
             */
            public List<BagAllowancePieceType> getPieceAllowanceList() {
                return pieceAllowanceList;
            }

            /** 
             * Set the list of 'PieceAllowance' element items.
             * 
             * @param list
             */
            public void setPieceAllowanceList(List<BagAllowancePieceType> list) {
                pieceAllowanceList = list;
            }

            /** 
             * Get the 'WeightAllowance' element value.
             * 
             * @return value
             */
            public WeightAllowance getWeightAllowance() {
                return weightAllowance;
            }

            /** 
             * Set the 'WeightAllowance' element value.
             * 
             * @param weightAllowance
             */
            public void setWeightAllowance(WeightAllowance weightAllowance) {
                this.weightAllowance = weightAllowance;
            }

            /** 
             * Get the 'BaggageDeterminingCarrier' element value. Baggage Determining Carrier as defined in resolution 722 (f), and who’s baggage rules apply.
             * 
             * @return value
             */
            public BaggageDeterminingCarrierType getBaggageDeterminingCarrier() {
                return baggageDeterminingCarrier;
            }

            /** 
             * Set the 'BaggageDeterminingCarrier' element value. Baggage Determining Carrier as defined in resolution 722 (f), and who’s baggage rules apply.
             * 
             * @param baggageDeterminingCarrier
             */
            public void setBaggageDeterminingCarrier(
                    BaggageDeterminingCarrierType baggageDeterminingCarrier) {
                this.baggageDeterminingCarrier = baggageDeterminingCarrier;
            }

            /** 
             * Get the 'BaggageAllowanceID' attribute value.
             * 
             * @return value
             */
            public String getBaggageAllowanceID() {
                return baggageAllowanceID;
            }

            /** 
             * Set the 'BaggageAllowanceID' attribute value.
             * 
             * @param baggageAllowanceID
             */
            public void setBaggageAllowanceID(String baggageAllowanceID) {
                this.baggageAllowanceID = baggageAllowanceID;
            }
        }
    }
    /** 
     * List of flight segments.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegmentList" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ListOfFlightSegmentType" name="FlightSegment" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FlightSegmentList implements Serializable
    {
        private List<ListOfFlightSegmentType> flightSegmentList = new ArrayList<ListOfFlightSegmentType>();

        /** 
         * Get the list of 'FlightSegment' element items. FlighSegment information. Contains details flight segment information.
         * 
         * @return list
         */
        public List<ListOfFlightSegmentType> getFlightSegmentList() {
            return flightSegmentList;
        }

        /** 
         * Set the list of 'FlightSegment' element items. FlighSegment information. Contains details flight segment information.
         * 
         * @param list
         */
        public void setFlightSegmentList(List<ListOfFlightSegmentType> list) {
            flightSegmentList = list;
        }
    }
    /** 
     * List of Flight elements.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightList" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Flight" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Flight -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FlightList implements Serializable
    {
        private List<Flight> flightList = new ArrayList<Flight>();

        /** 
         * Get the list of 'Flight' element items.
         * 
         * @return list
         */
        public List<Flight> getFlightList() {
            return flightList;
        }

        /** 
         * Set the list of 'Flight' element items.
         * 
         * @param list
         */
        public void setFlightList(List<Flight> list) {
            flightList = list;
        }
        /** 
         * Journey information describing the travel between an airport/city where travel commences and an airport/city where travel ultimately terminates. A journey may be comprised of one or more segments. Note: This node will be renamed to journey in future releases.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="TotalJourneyType" name="Journey" minOccurs="0"/>
         *       &lt;xs:element ref="SegmentReferences"/>
         *       &lt;xs:element name="Settlement" minOccurs="0">
         *         &lt;!-- Reference to inner class Settlement -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
         *     &lt;xs:attribute type="xs:string" name="FlightKey"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Flight implements Serializable
        {
            private TotalJourneyType journey;
            private SegmentReferences segmentReferences;
            private Settlement settlement;
            private String refs;
            private String flightKey;

            /** 
             * Get the 'Journey' element value. Flight journey information.
             * 
             * @return value
             */
            public TotalJourneyType getJourney() {
                return journey;
            }

            /** 
             * Set the 'Journey' element value. Flight journey information.
             * 
             * @param journey
             */
            public void setJourney(TotalJourneyType journey) {
                this.journey = journey;
            }

            /** 
             * Get the 'SegmentReferences' element value.
             * 
             * @return value
             */
            public SegmentReferences getSegmentReferences() {
                return segmentReferences;
            }

            /** 
             * Set the 'SegmentReferences' element value.
             * 
             * @param segmentReferences
             */
            public void setSegmentReferences(SegmentReferences segmentReferences) {
                this.segmentReferences = segmentReferences;
            }

            /** 
             * Get the 'Settlement' element value.
             * 
             * @return value
             */
            public Settlement getSettlement() {
                return settlement;
            }

            /** 
             * Set the 'Settlement' element value.
             * 
             * @param settlement
             */
            public void setSettlement(Settlement settlement) {
                this.settlement = settlement;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }

            /** 
             * Get the 'FlightKey' attribute value. A globally unique identifier for this Flight instance. Example: flight1
             * 
             * @return value
             */
            public String getFlightKey() {
                return flightKey;
            }

            /** 
             * Set the 'FlightKey' attribute value. A globally unique identifier for this Flight instance. Example: flight1
             * 
             * @param flightKey
             */
            public void setFlightKey(String flightKey) {
                this.flightKey = flightKey;
            }
            /** 
             * Interline Settlement information between airlines, including method of settlement, interline settlement value and currency.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Settlement" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Method"/>
             *       &lt;xs:element type="CurrencyAmountOptType" name="InterlineSettlementValue" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Settlement implements Serializable
            {
                private String method;
                private CurrencyAmountOptType interlineSettlementValue;

                /** 
                 * Get the 'Method' element value. Service settlement method.
                Examples:
                AD (Internal Airline Document)
                DS (Direct Settlement)
                EA (EMD Associated or Internal Airline Document)
                ES (EMD Standalone )
                FI (Fare Integrated)
                MA (Flight Associated, Settled via MCO)
                MS (Standalone, Settled via MCO)

                Encoding Scheme: IATA PADIS Codeset SST (Service Settlement Type)
                 * 
                 * @return value
                 */
                public String getMethod() {
                    return method;
                }

                /** 
                 * Set the 'Method' element value. Service settlement method.
                Examples:
                AD (Internal Airline Document)
                DS (Direct Settlement)
                EA (EMD Associated or Internal Airline Document)
                ES (EMD Standalone )
                FI (Fare Integrated)
                MA (Flight Associated, Settled via MCO)
                MS (Standalone, Settled via MCO)

                Encoding Scheme: IATA PADIS Codeset SST (Service Settlement Type)
                 * 
                 * @param method
                 */
                public void setMethod(String method) {
                    this.method = method;
                }

                /** 
                 * Get the 'InterlineSettlementValue' element value. Settlement (Price) Value. Example: 300 (USD)

                Note: This represents a Settlement value that is only used between the POA and ORA.
                 * 
                 * @return value
                 */
                public CurrencyAmountOptType getInterlineSettlementValue() {
                    return interlineSettlementValue;
                }

                /** 
                 * Set the 'InterlineSettlementValue' element value. Settlement (Price) Value. Example: 300 (USD)

                Note: This represents a Settlement value that is only used between the POA and ORA.
                 * 
                 * @param interlineSettlementValue
                 */
                public void setInterlineSettlementValue(
                        CurrencyAmountOptType interlineSettlementValue) {
                    this.interlineSettlementValue = interlineSettlementValue;
                }
            }
        }
    }
    /** 
     * List of Origin/Destination elements.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationList" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="OriginDestination" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginDestinationList implements Serializable
    {
        private List<OriginDestination> originDestinationList = new ArrayList<OriginDestination>();

        /** 
         * Get the list of 'OriginDestination' element items.
         * 
         * @return list
         */
        public List<OriginDestination> getOriginDestinationList() {
            return originDestinationList;
        }

        /** 
         * Set the list of 'OriginDestination' element items.
         * 
         * @param list
         */
        public void setOriginDestinationList(List<OriginDestination> list) {
            originDestinationList = list;
        }
    }
}
