
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import org.joda.time.LocalDate;

/** 
 * A data type for Effective/ Expiration Short Date Period Representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DatePeriodRepType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:date" name="Effective" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="Expiration" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DatePeriodRepType implements Serializable
{
    private LocalDate effective;
    private LocalDate expiration;

    /** 
     * Get the 'Effective' element value. Effective (start) date.  Example: 2017-01-13

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @return value
     */
    public LocalDate getEffective() {
        return effective;
    }

    /** 
     * Set the 'Effective' element value. Effective (start) date.  Example: 2017-01-13

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @param effective
     */
    public void setEffective(LocalDate effective) {
        this.effective = effective;
    }

    /** 
     * Get the 'Expiration' element value. Expiration (end) date.  Example: 2017-01-14

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @return value
     */
    public LocalDate getExpiration() {
        return expiration;
    }

    /** 
     * Set the 'Expiration' element value. Expiration (end) date.  Example: 2017-01-14

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @param expiration
     */
    public void setExpiration(LocalDate expiration) {
        this.expiration = expiration;
    }
}
