
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for NDC Domain List.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DomainSimpleType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="AirlineProfile"/>
 *     &lt;xs:enumeration value="OrderManagement"/>
 *     &lt;xs:enumeration value="PaymentTicketing"/>
 *     &lt;xs:enumeration value="Shopping"/>
 *     &lt;xs:enumeration value="Utility"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum DomainSimpleType implements Serializable {
    AIRLINE_PROFILE("AirlineProfile"), ORDER_MANAGEMENT("OrderManagement"), PAYMENT_TICKETING(
            "PaymentTicketing"), SHOPPING("Shopping"), UTILITY("Utility");
    private final String value;

    private DomainSimpleType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static DomainSimpleType convert(String value) {
        for (DomainSimpleType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
