
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Fare Type Code.

 Examples:
 70J, Published Fares
 70K, Dynamic Discounted Fares
 749, Negotiated Fares
 756, One Way Fare
 758, Private Fares

 Encoding Scheme: PADIS codeset element 9910 - Fare Qualifier
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" type="xs:string" name="FareCode"/>
 * </pre>
 */
public class FareCode implements Serializable
{
    private String fareCode;

    /** 
     * Get the 'FareCode' element value.
     * 
     * @return value
     */
    public String getFareCode() {
        return fareCode;
    }

    /** 
     * Set the 'FareCode' element value.
     * 
     * @param fareCode
     */
    public void setFareCode(String fareCode) {
        this.fareCode = fareCode;
    }
}
