
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * FARE FILING definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareFilingType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="CurrencyAmountOptType" name="BaseAmount"/>
 *     &lt;xs:element type="xs:decimal" name="NUC_Amount" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ExchangeRate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TicketBulkMask" minOccurs="0"/>
 *     &lt;xs:element ref="FiledFare" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class FareFilingType implements Serializable
{
    private CurrencyAmountOptType baseAmount;
    private BigDecimal NUCAmount;
    private String exchangeRate;
    private String ticketBulkMask;
    private FileFareType filedFare;
    private String refs;

    /** 
     * Get the 'BaseAmount' element value. Filed fare amount.
    Example: 2385 USD

    Note: This contains the originally filed base fare amount.
     * 
     * @return value
     */
    public CurrencyAmountOptType getBaseAmount() {
        return baseAmount;
    }

    /** 
     * Set the 'BaseAmount' element value. Filed fare amount.
    Example: 2385 USD

    Note: This contains the originally filed base fare amount.
     * 
     * @param baseAmount
     */
    public void setBaseAmount(CurrencyAmountOptType baseAmount) {
        this.baseAmount = baseAmount;
    }

    /** 
     * Get the 'NUC_Amount' element value. Fare neutral unit of construction amount.
    Example: 4327

    Note: This contains the fare amount expressed in Neutral Units of Construction (NUC) values rather than in any currency for provisional billing purposes by airline revenue accounting departments.
     * 
     * @return value
     */
    public BigDecimal getNUCAmount() {
        return NUCAmount;
    }

    /** 
     * Set the 'NUC_Amount' element value. Fare neutral unit of construction amount.
    Example: 4327

    Note: This contains the fare amount expressed in Neutral Units of Construction (NUC) values rather than in any currency for provisional billing purposes by airline revenue accounting departments.
     * 
     * @param NUCAmount
     */
    public void setNUCAmount(BigDecimal NUCAmount) {
        this.NUCAmount = NUCAmount;
    }

    /** 
     * Get the 'ExchangeRate' element value. Applicable exchange rate. Example: 1 : 0.895
     * 
     * @return value
     */
    public String getExchangeRate() {
        return exchangeRate;
    }

    /** 
     * Set the 'ExchangeRate' element value. Applicable exchange rate. Example: 1 : 0.895
     * 
     * @param exchangeRate
     */
    public void setExchangeRate(String exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    /** 
     * Get the 'TicketBulkMask' element value. Ticket masked value. Examples: IT, BT
     * 
     * @return value
     */
    public String getTicketBulkMask() {
        return ticketBulkMask;
    }

    /** 
     * Set the 'TicketBulkMask' element value. Ticket masked value. Examples: IT, BT
     * 
     * @param ticketBulkMask
     */
    public void setTicketBulkMask(String ticketBulkMask) {
        this.ticketBulkMask = ticketBulkMask;
    }

    /** 
     * Get the 'FiledFare' element value. Filed fare information that may contain specific indicators applicable to the use of filed fares scenarios.
     * 
     * @return value
     */
    public FileFareType getFiledFare() {
        return filedFare;
    }

    /** 
     * Set the 'FiledFare' element value. Filed fare information that may contain specific indicators applicable to the use of filed fares scenarios.
     * 
     * @param filedFare
     */
    public void setFiledFare(FileFareType filedFare) {
        this.filedFare = filedFare;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
