
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Element combining Fare Basis Code and Fare Details.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareList">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="FareGroup" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class FareGroup -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class FareList implements Serializable
{
    private List<FareGroup> fareGroupList = new ArrayList<FareGroup>();

    /** 
     * Get the list of 'FareGroup' element items.
     * 
     * @return list
     */
    public List<FareGroup> getFareGroupList() {
        return fareGroupList;
    }

    /** 
     * Set the list of 'FareGroup' element items.
     * 
     * @param list
     */
    public void setFareGroupList(List<FareGroup> list) {
        fareGroupList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareGroup" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Fare">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element ref="FareCode"/>
     *             &lt;xs:element ref="FareDetail" minOccurs="0"/>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareBasisCode">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element type="xs:string" name="Code"/>
     *             &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="DataListObjAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareGroup implements Serializable
    {
        private FareCode fareFareCode;
        private FareDetailType fareFareDetail;
        private String fareBasisCodeCode;
        private String fareBasisCodeApplication;
        private DataListObjAttrGroup dataListObjAttrGroup;

        /** 
         * Get the 'FareCode' element value.
         * 
         * @return value
         */
        public FareCode getFareFareCode() {
            return fareFareCode;
        }

        /** 
         * Set the 'FareCode' element value.
         * 
         * @param fareFareCode
         */
        public void setFareFareCode(FareCode fareFareCode) {
            this.fareFareCode = fareFareCode;
        }

        /** 
         * Get the 'FareDetail' element value.
         * 
         * @return value
         */
        public FareDetailType getFareFareDetail() {
            return fareFareDetail;
        }

        /** 
         * Set the 'FareDetail' element value.
         * 
         * @param fareFareDetail
         */
        public void setFareFareDetail(FareDetailType fareFareDetail) {
            this.fareFareDetail = fareFareDetail;
        }

        /** 
         * Get the 'Code' element value. Fare basis code. Example: Y26
         * 
         * @return value
         */
        public String getFareBasisCodeCode() {
            return fareBasisCodeCode;
        }

        /** 
         * Set the 'Code' element value. Fare basis code. Example: Y26
         * 
         * @param fareBasisCodeCode
         */
        public void setFareBasisCodeCode(String fareBasisCodeCode) {
            this.fareBasisCodeCode = fareBasisCodeCode;
        }

        /** 
         * Get the 'Application' element value. Fare basis application.
        Examples: Requested, Ticketed, Other
         * 
         * @return value
         */
        public String getFareBasisCodeApplication() {
            return fareBasisCodeApplication;
        }

        /** 
         * Set the 'Application' element value. Fare basis application.
        Examples: Requested, Ticketed, Other
         * 
         * @param fareBasisCodeApplication
         */
        public void setFareBasisCodeApplication(String fareBasisCodeApplication) {
            this.fareBasisCodeApplication = fareBasisCodeApplication;
        }

        /** 
         * Get the 'DataListObjAttrGroup' attributeGroup value.
         * 
         * @return value
         */
        public DataListObjAttrGroup getDataListObjAttrGroup() {
            return dataListObjAttrGroup;
        }

        /** 
         * Set the 'DataListObjAttrGroup' attributeGroup value.
         * 
         * @param dataListObjAttrGroup
         */
        public void setDataListObjAttrGroup(
                DataListObjAttrGroup dataListObjAttrGroup) {
            this.dataListObjAttrGroup = dataListObjAttrGroup;
        }
    }
}
