
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * FARE BASE PRICE definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FarePriceBaseType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="TotalAmount" minOccurs="0">
 *       &lt;!-- Reference to inner class TotalAmount -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="CurrencyAmountOptType" name="BaseAmount"/>
 *     &lt;xs:element ref="FareFiledIn" minOccurs="0"/>
 *     &lt;xs:element name="Surcharges" minOccurs="0">
 *       &lt;!-- Reference to inner class Surcharges -->
 *     &lt;/xs:element>
 *     &lt;xs:choice>
 *       &lt;xs:element type="AwardPriceUnitType" name="AwardPricing" minOccurs="0"/>
 *       &lt;xs:element type="CombinationPriceType" name="CombinationPricing" minOccurs="0"/>
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FarePriceBaseType implements Serializable
{
    private TotalAmount totalAmount;
    private CurrencyAmountOptType baseAmount;
    private FareFilingType fareFiledIn;
    private Surcharges surcharges;
    private int choiceSelect = -1;
    private static final int AWARD_PRICING_CHOICE = 0;
    private static final int COMBINATION_PRICING_CHOICE = 1;
    private AwardPriceUnitType awardPricing;
    private CombinationPriceType combinationPricing;

    /** 
     * Get the 'TotalAmount' element value.
     * 
     * @return value
     */
    public TotalAmount getTotalAmount() {
        return totalAmount;
    }

    /** 
     * Set the 'TotalAmount' element value.
     * 
     * @param totalAmount
     */
    public void setTotalAmount(TotalAmount totalAmount) {
        this.totalAmount = totalAmount;
    }

    /** 
     * Get the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

    Note: This includes  surcharges (if applicable).
     * 
     * @return value
     */
    public CurrencyAmountOptType getBaseAmount() {
        return baseAmount;
    }

    /** 
     * Set the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

    Note: This includes  surcharges (if applicable).
     * 
     * @param baseAmount
     */
    public void setBaseAmount(CurrencyAmountOptType baseAmount) {
        this.baseAmount = baseAmount;
    }

    /** 
     * Get the 'FareFiledIn' element value.
     * 
     * @return value
     */
    public FareFilingType getFareFiledIn() {
        return fareFiledIn;
    }

    /** 
     * Set the 'FareFiledIn' element value.
     * 
     * @param fareFiledIn
     */
    public void setFareFiledIn(FareFilingType fareFiledIn) {
        this.fareFiledIn = fareFiledIn;
    }

    /** 
     * Get the 'Surcharges' element value.
     * 
     * @return value
     */
    public Surcharges getSurcharges() {
        return surcharges;
    }

    /** 
     * Set the 'Surcharges' element value.
     * 
     * @param surcharges
     */
    public void setSurcharges(Surcharges surcharges) {
        this.surcharges = surcharges;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if AwardPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAwardPricing() {
        return choiceSelect == AWARD_PRICING_CHOICE;
    }

    /** 
     * Get the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
     * 
     * @return value
     */
    public AwardPriceUnitType getAwardPricing() {
        return awardPricing;
    }

    /** 
     * Set the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
     * 
     * @param awardPricing
     */
    public void setAwardPricing(AwardPriceUnitType awardPricing) {
        setChoiceSelect(AWARD_PRICING_CHOICE);
        this.awardPricing = awardPricing;
    }

    /** 
     * Check if CombinationPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCombinationPricing() {
        return choiceSelect == COMBINATION_PRICING_CHOICE;
    }

    /** 
     * Get the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
     * 
     * @return value
     */
    public CombinationPriceType getCombinationPricing() {
        return combinationPricing;
    }

    /** 
     * Set the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
     * 
     * @param combinationPricing
     */
    public void setCombinationPricing(CombinationPriceType combinationPricing) {
        setChoiceSelect(COMBINATION_PRICING_CHOICE);
        this.combinationPricing = combinationPricing;
    }
    /** 
     * Total price amount.

    Notes:
    1. This is typically the lowest price for this alternate lead shopping date.
    2. If expressed in currency, this price should include base price, taxes and fees/ surcharges.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalAmount" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="AwardPricing"/>
     *       &lt;xs:element ref="CombinationPricing"/>
     *       &lt;xs:element ref="DetailCurrencyPrice"/>
     *       &lt;xs:element ref="EncodedCurrencyPrice"/>
     *       &lt;xs:element ref="SimpleCurrencyPrice"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TotalAmount implements Serializable
    {
        private int totalAmountSelect = -1;
        private static final int AWARD_PRICING_CHOICE = 0;
        private static final int COMBINATION_PRICING_CHOICE = 1;
        private static final int DETAIL_CURRENCY_PRICE_CHOICE = 2;
        private static final int ENCODED_CURRENCY_PRICE_CHOICE = 3;
        private static final int SIMPLE_CURRENCY_PRICE_CHOICE = 4;
        private AwardPriceUnitType awardPricing;
        private CombinationPriceType combinationPricing;
        private DetailCurrencyPriceType detailCurrencyPrice;
        private EncodedCurrencyPrice encodedCurrencyPrice;
        private SimpleCurrencyPrice simpleCurrencyPrice;

        private void setTotalAmountSelect(int choice) {
            if (totalAmountSelect == -1) {
                totalAmountSelect = choice;
            } else if (totalAmountSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearTotalAmountSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearTotalAmountSelect() {
            totalAmountSelect = -1;
        }

        /** 
         * Check if AwardPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAwardPricing() {
            return totalAmountSelect == AWARD_PRICING_CHOICE;
        }

        /** 
         * Get the 'AwardPricing' element value.
         * 
         * @return value
         */
        public AwardPriceUnitType getAwardPricing() {
            return awardPricing;
        }

        /** 
         * Set the 'AwardPricing' element value.
         * 
         * @param awardPricing
         */
        public void setAwardPricing(AwardPriceUnitType awardPricing) {
            setTotalAmountSelect(AWARD_PRICING_CHOICE);
            this.awardPricing = awardPricing;
        }

        /** 
         * Check if CombinationPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCombinationPricing() {
            return totalAmountSelect == COMBINATION_PRICING_CHOICE;
        }

        /** 
         * Get the 'CombinationPricing' element value.
         * 
         * @return value
         */
        public CombinationPriceType getCombinationPricing() {
            return combinationPricing;
        }

        /** 
         * Set the 'CombinationPricing' element value.
         * 
         * @param combinationPricing
         */
        public void setCombinationPricing(
                CombinationPriceType combinationPricing) {
            setTotalAmountSelect(COMBINATION_PRICING_CHOICE);
            this.combinationPricing = combinationPricing;
        }

        /** 
         * Check if DetailCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifDetailCurrencyPrice() {
            return totalAmountSelect == DETAIL_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'DetailCurrencyPrice' element value.
         * 
         * @return value
         */
        public DetailCurrencyPriceType getDetailCurrencyPrice() {
            return detailCurrencyPrice;
        }

        /** 
         * Set the 'DetailCurrencyPrice' element value.
         * 
         * @param detailCurrencyPrice
         */
        public void setDetailCurrencyPrice(
                DetailCurrencyPriceType detailCurrencyPrice) {
            setTotalAmountSelect(DETAIL_CURRENCY_PRICE_CHOICE);
            this.detailCurrencyPrice = detailCurrencyPrice;
        }

        /** 
         * Check if EncodedCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifEncodedCurrencyPrice() {
            return totalAmountSelect == ENCODED_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'EncodedCurrencyPrice' element value.
         * 
         * @return value
         */
        public EncodedCurrencyPrice getEncodedCurrencyPrice() {
            return encodedCurrencyPrice;
        }

        /** 
         * Set the 'EncodedCurrencyPrice' element value.
         * 
         * @param encodedCurrencyPrice
         */
        public void setEncodedCurrencyPrice(
                EncodedCurrencyPrice encodedCurrencyPrice) {
            setTotalAmountSelect(ENCODED_CURRENCY_PRICE_CHOICE);
            this.encodedCurrencyPrice = encodedCurrencyPrice;
        }

        /** 
         * Check if SimpleCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSimpleCurrencyPrice() {
            return totalAmountSelect == SIMPLE_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'SimpleCurrencyPrice' element value.
         * 
         * @return value
         */
        public SimpleCurrencyPrice getSimpleCurrencyPrice() {
            return simpleCurrencyPrice;
        }

        /** 
         * Set the 'SimpleCurrencyPrice' element value.
         * 
         * @param simpleCurrencyPrice
         */
        public void setSimpleCurrencyPrice(
                SimpleCurrencyPrice simpleCurrencyPrice) {
            setTotalAmountSelect(SIMPLE_CURRENCY_PRICE_CHOICE);
            this.simpleCurrencyPrice = simpleCurrencyPrice;
        }
    }
    /** 
     * Applicable Surcharge(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharges" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="FeeSurchargeType" name="Surcharge" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Surcharges implements Serializable
    {
        private List<FeeSurchargeType> surchargeList = new ArrayList<FeeSurchargeType>();

        /** 
         * Get the list of 'Surcharge' element items. Surcharge detail.
         * 
         * @return list
         */
        public List<FeeSurchargeType> getSurchargeList() {
            return surchargeList;
        }

        /** 
         * Set the list of 'Surcharge' element items. Surcharge detail.
         * 
         * @param list
         */
        public void setSurchargeList(List<FeeSurchargeType> list) {
            surchargeList = list;
        }
    }
}
