
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * FARE definition.NDC Capability Model: FARE

 ============
 Representation(s)
 ============
 • Core Fare information
 • Detail Fare information (Fare Component, Fare Rules)

 ============
 Feature(s)
 ============
 • Fare Indicators for Cat35 Fare, Reissue Pricing, Auto Exchange Pricing
 • Fare Code (PADIS codeset element 9910 - Fare Qualifier)

 ============
 Metadata
 ============
 • FareMetadata

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="FareCode"/>
 *     &lt;xs:element ref="FareDetail" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class FareType implements Serializable
{
    private FareCode fareCode;
    private FareDetailType fareDetail;
    private String refs;

    /** 
     * Get the 'FareCode' element value.
     * 
     * @return value
     */
    public FareCode getFareCode() {
        return fareCode;
    }

    /** 
     * Set the 'FareCode' element value.
     * 
     * @param fareCode
     */
    public void setFareCode(FareCode fareCode) {
        this.fareCode = fareCode;
    }

    /** 
     * Get the 'FareDetail' element value.
     * 
     * @return value
     */
    public FareDetailType getFareDetail() {
        return fareDetail;
    }

    /** 
     * Set the 'FareDetail' element value.
     * 
     * @param fareDetail
     */
    public void setFareDetail(FareDetailType fareDetail) {
        this.fareDetail = fareDetail;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
