
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * File Fare definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FileFareType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="FareIndicatorCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="Cat35NetFareInd"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class FileFareType implements Serializable
{
    private String fareIndicatorCode;
    private String refs;
    private Boolean cat35NetFareInd;

    /** 
     * Get the 'FareIndicatorCode' element value. Fare global indicator.
    Example: AT (Via Atlantic)
     * 
     * @return value
     */
    public String getFareIndicatorCode() {
        return fareIndicatorCode;
    }

    /** 
     * Set the 'FareIndicatorCode' element value. Fare global indicator.
    Example: AT (Via Atlantic)
     * 
     * @param fareIndicatorCode
     */
    public void setFareIndicatorCode(String fareIndicatorCode) {
        this.fareIndicatorCode = fareIndicatorCode;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'Cat35NetFareInd' attribute value. When true, this is a Cat35 C-Type Net Fare.
     * 
     * @return value
     */
    public Boolean getCat35NetFareInd() {
        return cat35NetFareInd;
    }

    /** 
     * Set the 'Cat35NetFareInd' attribute value. When true, this is a Cat35 C-Type Net Fare.
     * 
     * @param cat35NetFareInd
     */
    public void setCat35NetFareInd(Boolean cat35NetFareInd) {
        this.cat35NetFareInd = cat35NetFareInd;
    }
}
