
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for Class of Service Core.

 Class of service code.
 Example: B
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightCOS_CoreType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Code">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="xs:string">
 *             &lt;xs:attribute type="xs:int" name="SeatsLeft"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="MarketingName" minOccurs="0">
 *       &lt;!-- Reference to inner class MarketingName -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="FareBasisCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class FlightCOSCoreType implements Serializable
{
    private String codeString;
    private Integer codeSeatsLeft;
    private MarketingName marketingName;
    private String fareBasisCode;
    private String refs;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getCodeString() {
        return codeString;
    }

    /** 
     * Set the extension value.
     * 
     * @param codeString
     */
    public void setCodeString(String codeString) {
        this.codeString = codeString;
    }

    /** 
     * Get the 'SeatsLeft' attribute value. Inidcates how many seats are still available in this class of service.
     * 
     * @return value
     */
    public Integer getCodeSeatsLeft() {
        return codeSeatsLeft;
    }

    /** 
     * Set the 'SeatsLeft' attribute value. Inidcates how many seats are still available in this class of service.
     * 
     * @param codeSeatsLeft
     */
    public void setCodeSeatsLeft(Integer codeSeatsLeft) {
        this.codeSeatsLeft = codeSeatsLeft;
    }

    /** 
     * Get the 'MarketingName' element value.
     * 
     * @return value
     */
    public MarketingName getMarketingName() {
        return marketingName;
    }

    /** 
     * Set the 'MarketingName' element value.
     * 
     * @param marketingName
     */
    public void setMarketingName(MarketingName marketingName) {
        this.marketingName = marketingName;
    }

    /** 
     * Get the 'FareBasisCode' element value. Fare basis code. Example: Y26CH
     * 
     * @return value
     */
    public String getFareBasisCode() {
        return fareBasisCode;
    }

    /** 
     * Set the 'FareBasisCode' element value. Fare basis code. Example: Y26CH
     * 
     * @param fareBasisCode
     */
    public void setFareBasisCode(String fareBasisCode) {
        this.fareBasisCode = fareBasisCode;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Cabin Class Marketing Name. Example: Premium Economy
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingName" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" name="CabinDesignator"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class MarketingName implements Serializable
    {
        private String string;
        private String cabinDesignator;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'CabinDesignator' attribute value. Designator code for the cabin. Example: Y
         * 
         * @return value
         */
        public String getCabinDesignator() {
            return cabinDesignator;
        }

        /** 
         * Set the 'CabinDesignator' attribute value. Designator code for the cabin. Example: Y
         * 
         * @param cabinDesignator
         */
        public void setCabinDesignator(String cabinDesignator) {
            this.cabinDesignator = cabinDesignator;
        }
    }
}
