
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * FLIGHT DISTANCE with Application definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightDistanceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Value"/>
 *     &lt;xs:element type="xs:string" name="UOM"/>
 *     &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class FlightDistanceType implements Serializable
{
    private String value;
    private String UOM;
    private String application;
    private String refs;

    /** 
     * Get the 'Value' element value. Flight distance value and distance unit of measure.
    Example: 818, 5467
     * 
     * @return value
     */
    public String getValue() {
        return value;
    }

    /** 
     * Set the 'Value' element value. Flight distance value and distance unit of measure.
    Example: 818, 5467
     * 
     * @param value
     */
    public void setValue(String value) {
        this.value = value;
    }

    /** 
     * Get the 'UOM' element value. Flight Distance Unit of Measure.
    Examples: Kilometers, Miles
     * 
     * @return value
     */
    public String getUOM() {
        return UOM;
    }

    /** 
     * Set the 'UOM' element value. Flight Distance Unit of Measure.
    Examples: Kilometers, Miles
     * 
     * @param UOM
     */
    public void setUOM(String UOM) {
        this.UOM = UOM;
    }

    /** 
     * Get the 'Application' element value. Flight Distance Application.
    Examples: FlightSegment, TotalJourney
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. Flight Distance Application.
    Examples: FlightSegment, TotalJourney
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
