
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * FLIGHT Metadata definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightMetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="MetadataObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="ActionCode" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="BindingKey" minOccurs="0"/>
 *         &lt;xs:element ref="FlightStatus" minOccurs="0"/>
 *         &lt;xs:element ref="Frequency" minOccurs="0"/>
 *         &lt;xs:element ref="InstantPurchase" minOccurs="0"/>
 *         &lt;xs:element name="Meals" minOccurs="0">
 *           &lt;!-- Reference to inner class Meals -->
 *         &lt;/xs:element>
 *         &lt;xs:element ref="OnTimePerformance" minOccurs="0"/>
 *         &lt;xs:element ref="Remarks" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightMetadataType extends MetadataObjectBaseType implements
    Serializable
{
    private String actionCode;
    private String bindingKey;
    private FlightStatus flightStatus;
    private Frequency frequency;
    private InstantPurchase instantPurchase;
    private Meals meals;
    private OnTimePerformance onTimePerformance;
    private Remarks remarks;

    /** 
     * Get the 'ActionCode' element value. Reservation system action code. Example: HK
     * 
     * @return value
     */
    public String getActionCode() {
        return actionCode;
    }

    /** 
     * Set the 'ActionCode' element value. Reservation system action code. Example: HK
     * 
     * @param actionCode
     */
    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    /** 
     * Get the 'BindingKey' element value. A unique flight segment reference that may be used when binding request/ response messages.
     * 
     * @return value
     */
    public String getBindingKey() {
        return bindingKey;
    }

    /** 
     * Set the 'BindingKey' element value. A unique flight segment reference that may be used when binding request/ response messages.
     * 
     * @param bindingKey
     */
    public void setBindingKey(String bindingKey) {
        this.bindingKey = bindingKey;
    }

    /** 
     * Get the 'FlightStatus' element value.
     * 
     * @return value
     */
    public FlightStatus getFlightStatus() {
        return flightStatus;
    }

    /** 
     * Set the 'FlightStatus' element value.
     * 
     * @param flightStatus
     */
    public void setFlightStatus(FlightStatus flightStatus) {
        this.flightStatus = flightStatus;
    }

    /** 
     * Get the 'Frequency' element value.
     * 
     * @return value
     */
    public Frequency getFrequency() {
        return frequency;
    }

    /** 
     * Set the 'Frequency' element value.
     * 
     * @param frequency
     */
    public void setFrequency(Frequency frequency) {
        this.frequency = frequency;
    }

    /** 
     * Get the 'InstantPurchase' element value.
     * 
     * @return value
     */
    public InstantPurchase getInstantPurchase() {
        return instantPurchase;
    }

    /** 
     * Set the 'InstantPurchase' element value.
     * 
     * @param instantPurchase
     */
    public void setInstantPurchase(InstantPurchase instantPurchase) {
        this.instantPurchase = instantPurchase;
    }

    /** 
     * Get the 'Meals' element value.
     * 
     * @return value
     */
    public Meals getMeals() {
        return meals;
    }

    /** 
     * Set the 'Meals' element value.
     * 
     * @param meals
     */
    public void setMeals(Meals meals) {
        this.meals = meals;
    }

    /** 
     * Get the 'OnTimePerformance' element value.
     * 
     * @return value
     */
    public OnTimePerformance getOnTimePerformance() {
        return onTimePerformance;
    }

    /** 
     * Set the 'OnTimePerformance' element value.
     * 
     * @param onTimePerformance
     */
    public void setOnTimePerformance(OnTimePerformance onTimePerformance) {
        this.onTimePerformance = onTimePerformance;
    }

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public Remarks getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(Remarks remarks) {
        this.remarks = remarks;
    }
    /** 
     * Meal(s) Served.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Meals" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Meal" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Meals implements Serializable
    {
        private List<String> mealList = new ArrayList<String>();

        /** 
         * Get the list of 'Meal' element items. Meal served code. Example: B (Breakfast)

        Encoding Scheme: IATA Padis Codeset - List for data element 7161 - Special Service, Coded
         * 
         * @return list
         */
        public List<String> getMealList() {
            return mealList;
        }

        /** 
         * Set the list of 'Meal' element items. Meal served code. Example: B (Breakfast)

        Encoding Scheme: IATA Padis Codeset - List for data element 7161 - Special Service, Coded
         * 
         * @param list
         */
        public void setMealList(List<String> list) {
            mealList = list;
        }
    }
}
