
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Association to to single Flight  segment instance(s). Example: segment1
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegmentReference">
 *   &lt;xs:complexType>
 *     &lt;xs:choice>
 *       &lt;xs:element type="FlightCabin_CoreType" name="Cabin"/>
 *       &lt;xs:sequence>
 *         &lt;xs:element type="FlightCOS_CoreType" name="ClassOfService"/>
 *         &lt;xs:element ref="BagDetailAssociation" minOccurs="0"/>
 *         &lt;xs:element type="xs:integer" name="MarriedSegmentGroup" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:choice>
 *     &lt;xs:attribute type="xs:string" name="ref"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class FlightSegmentReference implements Serializable
{
    private int choiceSelect = -1;
    private static final int CABIN_CHOICE = 0;
    private static final int CLASS_OF_SERVICE_CHOICE = 1;
    private FlightCabinCoreType cabin;
    private FlightCOSCoreType classOfService;
    private BagDetailAssociation bagDetailAssociation;
    private BigInteger marriedSegmentGroup;
    private String ref;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Cabin is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCabin() {
        return choiceSelect == CABIN_CHOICE;
    }

    /** 
     * Get the 'Cabin' element value.
     * 
     * @return value
     */
    public FlightCabinCoreType getCabin() {
        return cabin;
    }

    /** 
     * Set the 'Cabin' element value.
     * 
     * @param cabin
     */
    public void setCabin(FlightCabinCoreType cabin) {
        setChoiceSelect(CABIN_CHOICE);
        this.cabin = cabin;
    }

    /** 
     * Check if ClassOfService is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifClassOfService() {
        return choiceSelect == CLASS_OF_SERVICE_CHOICE;
    }

    /** 
     * Get the 'ClassOfService' element value.
     * 
     * @return value
     */
    public FlightCOSCoreType getClassOfService() {
        return classOfService;
    }

    /** 
     * Set the 'ClassOfService' element value.
     * 
     * @param classOfService
     */
    public void setClassOfService(FlightCOSCoreType classOfService) {
        setChoiceSelect(CLASS_OF_SERVICE_CHOICE);
        this.classOfService = classOfService;
    }

    /** 
     * Get the 'BagDetailAssociation' element value.
     * 
     * @return value
     */
    public BagDetailAssociation getBagDetailAssociation() {
        return bagDetailAssociation;
    }

    /** 
     * Set the 'BagDetailAssociation' element value.
     * 
     * @param bagDetailAssociation
     */
    public void setBagDetailAssociation(
            BagDetailAssociation bagDetailAssociation) {
        setChoiceSelect(CLASS_OF_SERVICE_CHOICE);
        this.bagDetailAssociation = bagDetailAssociation;
    }

    /** 
     * Get the 'MarriedSegmentGroup' element value. To indicate married segment group number.
    Exmple 5
     * 
     * @return value
     */
    public BigInteger getMarriedSegmentGroup() {
        return marriedSegmentGroup;
    }

    /** 
     * Set the 'MarriedSegmentGroup' element value. To indicate married segment group number.
    Exmple 5
     * 
     * @param marriedSegmentGroup
     */
    public void setMarriedSegmentGroup(BigInteger marriedSegmentGroup) {
        setChoiceSelect(CLASS_OF_SERVICE_CHOICE);
        this.marriedSegmentGroup = marriedSegmentGroup;
    }

    /** 
     * Get the 'ref' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRef() {
        return ref;
    }

    /** 
     * Set the 'ref' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param ref
     */
    public void setRef(String ref) {
        this.ref = ref;
    }
}
