
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.LocalDate;

/** 
 * Any document which may be used to identify a person or verify aspects of a person's personal identity. If issued in a small, standard credit card size form, it is usually called an identity card. Some countries issue formal identity documents, while others may require identity verification using informal documents. When the identity document incorporates a person's photograph, it may be called photo ID.

 In the absence of a formal identity document, a driver's license may be accepted in many countries for identity verification. Most countries accept passports as a form of identification.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IdentityDocumentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="IdentityDocumentNumber"/>
 *     &lt;xs:element type="xs:string" name="IdentityDocumentType"/>
 *     &lt;xs:element type="xs:string" name="IssuingCountryCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CitizenshipCountryCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ResidenceCountryCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="IssueDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="ExpiryDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="Birthdate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Birthplace" minOccurs="0"/>
 *     &lt;xs:element type="GenderCodeContentType" name="Gender" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="NameTitle" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="GivenName" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="xs:string" name="MiddleName" minOccurs="0" maxOccurs="3"/>
 *     &lt;xs:element type="xs:string" name="Surname" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SurnameSuffix" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="VisaType" name="Visa" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class IdentityDocumentType implements Serializable
{
    private String identityDocumentNumber;
    private String identityDocumentType;
    private String issuingCountryCode;
    private String citizenshipCountryCode;
    private String residenceCountryCode;
    private LocalDate issueDate;
    private LocalDate expiryDate;
    private LocalDate birthdate;
    private String birthplace;
    private GenderCodeContentType gender;
    private String nameTitle;
    private List<String> givenNameList = new ArrayList<String>();
    private List<String> middleNameList = new ArrayList<String>();
    private String surname;
    private String surnameSuffix;
    private List<VisaType> visaList = new ArrayList<VisaType>();

    /** 
     * Get the 'IdentityDocumentNumber' element value. Uniquely identifies the document from all other identity documents issued by the state or organization. e.g. passport number, drive license number.
     * 
     * @return value
     */
    public String getIdentityDocumentNumber() {
        return identityDocumentNumber;
    }

    /** 
     * Set the 'IdentityDocumentNumber' element value. Uniquely identifies the document from all other identity documents issued by the state or organization. e.g. passport number, drive license number.
     * 
     * @param identityDocumentNumber
     */
    public void setIdentityDocumentNumber(String identityDocumentNumber) {
        this.identityDocumentNumber = identityDocumentNumber;
    }

    /** 
     * Get the 'IdentityDocumentType' element value. The type of passenger document. 
    Examples: PT (Passport)
     * 
     * @return value
     */
    public String getIdentityDocumentType() {
        return identityDocumentType;
    }

    /** 
     * Set the 'IdentityDocumentType' element value. The type of passenger document. 
    Examples: PT (Passport)
     * 
     * @param identityDocumentType
     */
    public void setIdentityDocumentType(String identityDocumentType) {
        this.identityDocumentType = identityDocumentType;
    }

    /** 
     * Get the 'IssuingCountryCode' element value. Issuing country code of the identity document.
     * 
     * @return value
     */
    public String getIssuingCountryCode() {
        return issuingCountryCode;
    }

    /** 
     * Set the 'IssuingCountryCode' element value. Issuing country code of the identity document.
     * 
     * @param issuingCountryCode
     */
    public void setIssuingCountryCode(String issuingCountryCode) {
        this.issuingCountryCode = issuingCountryCode;
    }

    /** 
     * Get the 'CitizenshipCountryCode' element value. Citizenship Country Code. Examples: US, FR.
     * 
     * @return value
     */
    public String getCitizenshipCountryCode() {
        return citizenshipCountryCode;
    }

    /** 
     * Set the 'CitizenshipCountryCode' element value. Citizenship Country Code. Examples: US, FR.
     * 
     * @param citizenshipCountryCode
     */
    public void setCitizenshipCountryCode(String citizenshipCountryCode) {
        this.citizenshipCountryCode = citizenshipCountryCode;
    }

    /** 
     * Get the 'ResidenceCountryCode' element value. Residence Country Code. Examples: US, FR.
     * 
     * @return value
     */
    public String getResidenceCountryCode() {
        return residenceCountryCode;
    }

    /** 
     * Set the 'ResidenceCountryCode' element value. Residence Country Code. Examples: US, FR.
     * 
     * @param residenceCountryCode
     */
    public void setResidenceCountryCode(String residenceCountryCode) {
        this.residenceCountryCode = residenceCountryCode;
    }

    /** 
     * Get the 'IssueDate' element value. The date the identity document was issued.
     * 
     * @return value
     */
    public LocalDate getIssueDate() {
        return issueDate;
    }

    /** 
     * Set the 'IssueDate' element value. The date the identity document was issued.
     * 
     * @param issueDate
     */
    public void setIssueDate(LocalDate issueDate) {
        this.issueDate = issueDate;
    }

    /** 
     * Get the 'ExpiryDate' element value. The date the identity document expires.
     * 
     * @return value
     */
    public LocalDate getExpiryDate() {
        return expiryDate;
    }

    /** 
     * Set the 'ExpiryDate' element value. The date the identity document expires.
     * 
     * @param expiryDate
     */
    public void setExpiryDate(LocalDate expiryDate) {
        this.expiryDate = expiryDate;
    }

    /** 
     * Get the 'Birthdate' element value. Holder’s date of birth as written on the document.
     * 
     * @return value
     */
    public LocalDate getBirthdate() {
        return birthdate;
    }

    /** 
     * Set the 'Birthdate' element value. Holder’s date of birth as written on the document.
     * 
     * @param birthdate
     */
    public void setBirthdate(LocalDate birthdate) {
        this.birthdate = birthdate;
    }

    /** 
     * Get the 'Birthplace' element value. Holder's birth location (e.g. city and/or country) as written on the  document. 
     * 
     * @return value
     */
    public String getBirthplace() {
        return birthplace;
    }

    /** 
     * Set the 'Birthplace' element value. Holder's birth location (e.g. city and/or country) as written on the  document. 
     * 
     * @param birthplace
     */
    public void setBirthplace(String birthplace) {
        this.birthplace = birthplace;
    }

    /** 
     * Get the 'Gender' element value. Holder’s gender as specified on the document (M, F, or X for unspecified).
     * 
     * @return value
     */
    public GenderCodeContentType getGender() {
        return gender;
    }

    /** 
     * Set the 'Gender' element value. Holder’s gender as specified on the document (M, F, or X for unspecified).
     * 
     * @param gender
     */
    public void setGender(GenderCodeContentType gender) {
        this.gender = gender;
    }

    /** 
     * Get the 'NameTitle' element value. Holder's name title as written on the document. Examples: MR, MRS, DRn.
     * 
     * @return value
     */
    public String getNameTitle() {
        return nameTitle;
    }

    /** 
     * Set the 'NameTitle' element value. Holder's name title as written on the document. Examples: MR, MRS, DRn.
     * 
     * @param nameTitle
     */
    public void setNameTitle(String nameTitle) {
        this.nameTitle = nameTitle;
    }

    /** 
     * Get the list of 'GivenName' element items. Holder's first or given name, as written on the document.  Example: JOHN.
     * 
     * @return list
     */
    public List<String> getGivenNameList() {
        return givenNameList;
    }

    /** 
     * Set the list of 'GivenName' element items. Holder's first or given name, as written on the document.  Example: JOHN.
     * 
     * @param list
     */
    public void setGivenNameList(List<String> list) {
        givenNameList = list;
    }

    /** 
     * Get the list of 'MiddleName' element items. Holder's middle name or initial, as written on the document.  Examples: G, GEORGE
     * 
     * @return list
     */
    public List<String> getMiddleNameList() {
        return middleNameList;
    }

    /** 
     * Set the list of 'MiddleName' element items. Holder's middle name or initial, as written on the document.  Examples: G, GEORGE
     * 
     * @param list
     */
    public void setMiddleNameList(List<String> list) {
        middleNameList = list;
    }

    /** 
     * Get the 'Surname' element value. Holder's family name, last name as written on the document. Example: SMITH.
     * 
     * @return value
     */
    public String getSurname() {
        return surname;
    }

    /** 
     * Set the 'Surname' element value. Holder's family name, last name as written on the document. Example: SMITH.
     * 
     * @param surname
     */
    public void setSurname(String surname) {
        this.surname = surname;
    }

    /** 
     * Get the 'SurnameSuffix' element value. Holder's surname suffixes and letters as written on the document. Examples: Jr., Sr., III, Ret., Esq.
     * 
     * @return value
     */
    public String getSurnameSuffix() {
        return surnameSuffix;
    }

    /** 
     * Set the 'SurnameSuffix' element value. Holder's surname suffixes and letters as written on the document. Examples: Jr., Sr., III, Ret., Esq.
     * 
     * @param surnameSuffix
     */
    public void setSurnameSuffix(String surnameSuffix) {
        this.surnameSuffix = surnameSuffix;
    }

    /** 
     * Get the list of 'Visa' element items. An official entry in a Passport or other Travel Document made by an official of a government to indicate that the bearer has been granted authority to enter or re-enter the country or region concerned.
     * 
     * @return list
     */
    public List<VisaType> getVisaList() {
        return visaList;
    }

    /** 
     * Set the list of 'Visa' element items. An official entry in a Passport or other Travel Document made by an official of a government to indicate that the bearer has been granted authority to enter or re-enter the country or region concerned.
     * 
     * @param list
     */
    public void setVisaList(List<VisaType> list) {
        visaList = list;
    }
}
