
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for an Image UOM constrained list.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ImageUnitListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Inch"/>
 *     &lt;xs:enumeration value="Millimeter"/>
 *     &lt;xs:enumeration value="Pixel"/>
 *     &lt;xs:enumeration value="Point"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ImageUnitListType implements Serializable {
    INCH("Inch"), MILLIMETER("Millimeter"), PIXEL("Pixel"), POINT("Point"), OTHER(
            "Other");
    private final String value;

    private ImageUnitListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ImageUnitListType convert(String value) {
        for (ImageUnitListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
