
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Describes the Loyalty credits  that would be accrued with the specified offer
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LoyaltyAccrual">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="xs:string" name="StatusTier" minOccurs="0"/>
 *       &lt;xs:element type="xs:string" name="StatusTierCode" minOccurs="0"/>
 *       &lt;xs:element type="xs:integer" name="StatusCredits" minOccurs="0"/>
 *       &lt;xs:element type="xs:integer" name="EarnedCredit" minOccurs="0"/>
 *       &lt;xs:element type="xs:string" name="ClassOfService" minOccurs="0"/>
 *       &lt;xs:element name="Associations" minOccurs="0">
 *         &lt;!-- Reference to inner class Associations -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class LoyaltyAccrual implements Serializable
{
    private String statusTier;
    private String statusTierCode;
    private BigInteger statusCredits;
    private BigInteger earnedCredit;
    private String classOfService;
    private Associations associations;
    private String refs;

    /** 
     * Get the 'StatusTier' element value. The current Status Tier for the traveler Example: Bronze
     * 
     * @return value
     */
    public String getStatusTier() {
        return statusTier;
    }

    /** 
     * Set the 'StatusTier' element value. The current Status Tier for the traveler Example: Bronze
     * 
     * @param statusTier
     */
    public void setStatusTier(String statusTier) {
        this.statusTier = statusTier;
    }

    /** 
     * Get the 'StatusTierCode' element value. The current Status Tier Code for the traveler Example "FFBR"
     * 
     * @return value
     */
    public String getStatusTierCode() {
        return statusTierCode;
    }

    /** 
     * Set the 'StatusTierCode' element value. The current Status Tier Code for the traveler Example "FFBR"
     * 
     * @param statusTierCode
     */
    public void setStatusTierCode(String statusTierCode) {
        this.statusTierCode = statusTierCode;
    }

    /** 
     * Get the 'StatusCredits' element value. Frequent flyer credits counted toward program tier status advancement awarded if selecting this offer
     * 
     * @return value
     */
    public BigInteger getStatusCredits() {
        return statusCredits;
    }

    /** 
     * Set the 'StatusCredits' element value. Frequent flyer credits counted toward program tier status advancement awarded if selecting this offer
     * 
     * @param statusCredits
     */
    public void setStatusCredits(BigInteger statusCredits) {
        this.statusCredits = statusCredits;
    }

    /** 
     * Get the 'EarnedCredit' element value. Frequent flyer miles, points or other credit awarded if selecting this offer
     * 
     * @return value
     */
    public BigInteger getEarnedCredit() {
        return earnedCredit;
    }

    /** 
     * Set the 'EarnedCredit' element value. Frequent flyer miles, points or other credit awarded if selecting this offer
     * 
     * @param earnedCredit
     */
    public void setEarnedCredit(BigInteger earnedCredit) {
        this.earnedCredit = earnedCredit;
    }

    /** 
     * Get the 'ClassOfService' element value. Class Of Service Example "B"
     * 
     * @return value
     */
    public String getClassOfService() {
        return classOfService;
    }

    /** 
     * Set the 'ClassOfService' element value. Class Of Service Example "B"
     * 
     * @param classOfService
     */
    public void setClassOfService(String classOfService) {
        this.classOfService = classOfService;
    }

    /** 
     * Get the 'Associations' element value.
     * 
     * @return value
     */
    public Associations getAssociations() {
        return associations;
    }

    /** 
     * Set the 'Associations' element value.
     * 
     * @param associations
     */
    public void setAssociations(Associations associations) {
        this.associations = associations;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any object instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any object instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Associations" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Passengers" minOccurs="0">
     *         &lt;!-- Reference to inner class Passengers -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Flight" minOccurs="0">
     *         &lt;!-- Reference to inner class Flight -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Associations implements Serializable
    {
        private Passengers passengers;
        private Flight flight;

        /** 
         * Get the 'Passengers' element value.
         * 
         * @return value
         */
        public Passengers getPassengers() {
            return passengers;
        }

        /** 
         * Set the 'Passengers' element value.
         * 
         * @param passengers
         */
        public void setPassengers(Passengers passengers) {
            this.passengers = passengers;
        }

        /** 
         * Get the 'Flight' element value.
         * 
         * @return value
         */
        public Flight getFlight() {
            return flight;
        }

        /** 
         * Set the 'Flight' element value.
         * 
         * @param flight
         */
        public void setFlight(Flight flight) {
            this.flight = flight;
        }
        /** 
         * Passenger(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="PassengerReferences"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Passengers implements Serializable
        {
            private String passengerReferences;

            /** 
             * Get the 'PassengerReferences' element value. 
                                        Association to multiple Passenger instance(s). Example: pax1 pax2
                                      
             * 
             * @return value
             */
            public String getPassengerReferences() {
                return passengerReferences;
            }

            /** 
             * Set the 'PassengerReferences' element value. 
                                        Association to multiple Passenger instance(s). Example: pax1 pax2
                                      
             * 
             * @param passengerReferences
             */
            public void setPassengerReferences(String passengerReferences) {
                this.passengerReferences = passengerReferences;
            }
        }
        /** 
         * Flight that the offer applies to.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:choice>
         *       &lt;xs:element type="xs:boolean" name="AllFlightInd"/>
         *       &lt;xs:element type="xs:boolean" name="AllOriginDestinationInd"/>
         *       &lt;xs:element type="xs:boolean" name="AllSegmentInd"/>
         *       &lt;xs:choice maxOccurs="2">
         *         &lt;!-- Reference to inner class Choice -->
         *       &lt;/xs:choice>
         *     &lt;/xs:choice>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Flight implements Serializable
        {
            private int flightSelect = -1;
            private static final int ALL_FLIGHT_IND_CHOICE = 0;
            private static final int ALL_ORIGIN_DESTINATION_IND_CHOICE = 1;
            private static final int ALL_SEGMENT_IND_CHOICE = 2;
            private static final int CHOICE_LIST_CHOICE = 3;
            private boolean allFlightInd;
            private boolean allOriginDestinationInd;
            private boolean allSegmentInd;
            private List<Choice> choiceList = new ArrayList<Choice>();

            private void setFlightSelect(int choice) {
                if (flightSelect == -1) {
                    flightSelect = choice;
                } else if (flightSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearFlightSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearFlightSelect() {
                flightSelect = -1;
            }

            /** 
             * Check if AllFlightInd is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifAllFlightInd() {
                return flightSelect == ALL_FLIGHT_IND_CHOICE;
            }

            /** 
             * Get the 'AllFlightInd' element value. When true, this Baggage Offer applies to all specified flights.
             * 
             * @return value
             */
            public boolean isAllFlightInd() {
                return allFlightInd;
            }

            /** 
             * Set the 'AllFlightInd' element value. When true, this Baggage Offer applies to all specified flights.
             * 
             * @param allFlightInd
             */
            public void setAllFlightInd(boolean allFlightInd) {
                setFlightSelect(ALL_FLIGHT_IND_CHOICE);
                this.allFlightInd = allFlightInd;
            }

            /** 
             * Check if AllOriginDestinationInd is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifAllOriginDestinationInd() {
                return flightSelect == ALL_ORIGIN_DESTINATION_IND_CHOICE;
            }

            /** 
             * Get the 'AllOriginDestinationInd' element value. When true, this Baggage Offer applies to all specified flight Origin/ Destination Pairs.
             * 
             * @return value
             */
            public boolean isAllOriginDestinationInd() {
                return allOriginDestinationInd;
            }

            /** 
             * Set the 'AllOriginDestinationInd' element value. When true, this Baggage Offer applies to all specified flight Origin/ Destination Pairs.
             * 
             * @param allOriginDestinationInd
             */
            public void setAllOriginDestinationInd(
                    boolean allOriginDestinationInd) {
                setFlightSelect(ALL_ORIGIN_DESTINATION_IND_CHOICE);
                this.allOriginDestinationInd = allOriginDestinationInd;
            }

            /** 
             * Check if AllSegmentInd is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifAllSegmentInd() {
                return flightSelect == ALL_SEGMENT_IND_CHOICE;
            }

            /** 
             * Get the 'AllSegmentInd' element value. When true, this Baggage Offer applies to all specified flight Segments.
             * 
             * @return value
             */
            public boolean isAllSegmentInd() {
                return allSegmentInd;
            }

            /** 
             * Set the 'AllSegmentInd' element value. When true, this Baggage Offer applies to all specified flight Segments.
             * 
             * @param allSegmentInd
             */
            public void setAllSegmentInd(boolean allSegmentInd) {
                setFlightSelect(ALL_SEGMENT_IND_CHOICE);
                this.allSegmentInd = allSegmentInd;
            }

            /** 
             * Check if ChoiceList is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifChoiceList() {
                return flightSelect == CHOICE_LIST_CHOICE;
            }

            /** 
             * Get the list of choice items.
             * 
             * @return list
             */
            public List<Choice> getChoiceList() {
                return choiceList;
            }

            /** 
             * Set the list of choice items.
             * 
             * @param list
             */
            public void setChoiceList(List<Choice> list) {
                setFlightSelect(CHOICE_LIST_CHOICE);
                choiceList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="2">
             *   &lt;xs:element type="xs:string" name="OriginDestinationReferences"/>
             *   &lt;xs:element type="xs:string" name="SegmentReferences"/>
             * &lt;/xs:choice>
             * </pre>
             */
            public static class Choice implements Serializable
            {
                private int choiceListSelect = -1;
                private static final int ORIGIN_DESTINATION_REFERENCES_CHOICE = 0;
                private static final int SEGMENT_REFERENCES_CHOICE = 1;
                private String originDestinationReferences;
                private String segmentReferences;

                private void setChoiceListSelect(int choice) {
                    if (choiceListSelect == -1) {
                        choiceListSelect = choice;
                    } else if (choiceListSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearChoiceListSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearChoiceListSelect() {
                    choiceListSelect = -1;
                }

                /** 
                 * Check if OriginDestinationReferences is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifOriginDestinationReferences() {
                    return choiceListSelect == ORIGIN_DESTINATION_REFERENCES_CHOICE;
                }

                /** 
                 * Get the 'OriginDestinationReferences' element value.
                 * 
                 * @return value
                 */
                public String getOriginDestinationReferences() {
                    return originDestinationReferences;
                }

                /** 
                 * Set the 'OriginDestinationReferences' element value.
                 * 
                 * @param originDestinationReferences
                 */
                public void setOriginDestinationReferences(
                        String originDestinationReferences) {
                    setChoiceListSelect(ORIGIN_DESTINATION_REFERENCES_CHOICE);
                    this.originDestinationReferences = originDestinationReferences;
                }

                /** 
                 * Check if SegmentReferences is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifSegmentReferences() {
                    return choiceListSelect == SEGMENT_REFERENCES_CHOICE;
                }

                /** 
                 * Get the 'SegmentReferences' element value.
                 * 
                 * @return value
                 */
                public String getSegmentReferences() {
                    return segmentReferences;
                }

                /** 
                 * Set the 'SegmentReferences' element value.
                 * 
                 * @param segmentReferences
                 */
                public void setSegmentReferences(String segmentReferences) {
                    setChoiceListSelect(SEGMENT_REFERENCES_CHOICE);
                    this.segmentReferences = segmentReferences;
                }
            }
        }
    }
}
