
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * An account set up for a customer within a rewards program which holds funds on behalf of that customer.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LoyaltyProgramAccountType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="AllianceType" name="Alliance" minOccurs="0"/>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *     &lt;xs:element type="xs:string" name="ProgramName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ProgramCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AccountNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="URL" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SignInID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TierCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TierName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TierPriority" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LoyaltyProgramAccountType implements Serializable
{
    private AllianceType alliance;
    private Choice choice;
    private String programName;
    private String programCode;
    private String accountNumber;
    private String URL;
    private String signInID;
    private String tierCode;
    private String tierName;
    private String tierPriority;

    /** 
     * Get the 'Alliance' element value. Two or more airlines participating in a commercial relationship or joint venture.
     * 
     * @return value
     */
    public AllianceType getAlliance() {
        return alliance;
    }

    /** 
     * Set the 'Alliance' element value. Two or more airlines participating in a commercial relationship or joint venture.
     * 
     * @param alliance
     */
    public void setAlliance(AllianceType alliance) {
        this.alliance = alliance;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'ProgramName' element value. Loyalty Program Name. Example: Miles and More
     * 
     * @return value
     */
    public String getProgramName() {
        return programName;
    }

    /** 
     * Set the 'ProgramName' element value. Loyalty Program Name. Example: Miles and More
     * 
     * @param programName
     */
    public void setProgramName(String programName) {
        this.programName = programName;
    }

    /** 
     * Get the 'ProgramCode' element value. Loyalty Program ID: Example: MAM
     * 
     * @return value
     */
    public String getProgramCode() {
        return programCode;
    }

    /** 
     * Set the 'ProgramCode' element value. Loyalty Program ID: Example: MAM
     * 
     * @param programCode
     */
    public void setProgramCode(String programCode) {
        this.programCode = programCode;
    }

    /** 
     * Get the 'AccountNumber' element value. Loyalty Program account number. Example: ABC123456
     * 
     * @return value
     */
    public String getAccountNumber() {
        return accountNumber;
    }

    /** 
     * Set the 'AccountNumber' element value. Loyalty Program account number. Example: ABC123456
     * 
     * @param accountNumber
     */
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    /** 
     * Get the 'URL' element value. Loyalty Program information URL. Example: https://www.britishairways.com/en-gb/executive-club/about-the-club
     * 
     * @return value
     */
    public String getURL() {
        return URL;
    }

    /** 
     * Set the 'URL' element value. Loyalty Program information URL. Example: https://www.britishairways.com/en-gb/executive-club/about-the-club
     * 
     * @param URL
     */
    public void setURL(String URL) {
        this.URL = URL;
    }

    /** 
     * Get the 'SignInID' element value. Loyalty Program sign-in ID (or username).
     * 
     * @return value
     */
    public String getSignInID() {
        return signInID;
    }

    /** 
     * Set the 'SignInID' element value. Loyalty Program sign-in ID (or username).
     * 
     * @param signInID
     */
    public void setSignInID(String signInID) {
        this.signInID = signInID;
    }

    /** 
     * Get the 'TierCode' element value. Loyalty Program tier code.
     * 
     * @return value
     */
    public String getTierCode() {
        return tierCode;
    }

    /** 
     * Set the 'TierCode' element value. Loyalty Program tier code.
     * 
     * @param tierCode
     */
    public void setTierCode(String tierCode) {
        this.tierCode = tierCode;
    }

    /** 
     * Get the 'TierName' element value. Loyalty Program tier name.
     * 
     * @return value
     */
    public String getTierName() {
        return tierName;
    }

    /** 
     * Set the 'TierName' element value. Loyalty Program tier name.
     * 
     * @param tierName
     */
    public void setTierName(String tierName) {
        this.tierName = tierName;
    }

    /** 
     * Get the 'TierPriority' element value. Loyalty Program account priority within the tier (e.g. Platinum, executive, etc.)
     * 
     * @return value
     */
    public String getTierPriority() {
        return tierPriority;
    }

    /** 
     * Set the 'TierPriority' element value. Loyalty Program account priority within the tier (e.g. Platinum, executive, etc.)
     * 
     * @param tierPriority
     */
    public void setTierPriority(String tierPriority) {
        this.tierPriority = tierPriority;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="AirlineTypeAIDM" name="Airline" minOccurs="0"/>
     *   &lt;xs:element type="xs:string" name="ProviderName" minOccurs="0"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int AIRLINE_CHOICE = 0;
        private static final int PROVIDER_NAME_CHOICE = 1;
        private AirlineTypeAIDM airline;
        private String providerName;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if Airline is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAirline() {
            return choiceSelect == AIRLINE_CHOICE;
        }

        /** 
         * Get the 'Airline' element value. An enterprise operating aircraft for commercial purposes
         * 
         * @return value
         */
        public AirlineTypeAIDM getAirline() {
            return airline;
        }

        /** 
         * Set the 'Airline' element value. An enterprise operating aircraft for commercial purposes
         * 
         * @param airline
         */
        public void setAirline(AirlineTypeAIDM airline) {
            setChoiceSelect(AIRLINE_CHOICE);
            this.airline = airline;
        }

        /** 
         * Check if ProviderName is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifProviderName() {
            return choiceSelect == PROVIDER_NAME_CHOICE;
        }

        /** 
         * Get the 'ProviderName' element value. Non-airline loyalty program provider name.
         * 
         * @return value
         */
        public String getProviderName() {
            return providerName;
        }

        /** 
         * Set the 'ProviderName' element value. Non-airline loyalty program provider name.
         * 
         * @param providerName
         */
        public void setProviderName(String providerName) {
            setChoiceSelect(PROVIDER_NAME_CHOICE);
            this.providerName = providerName;
        }
    }
}
