
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for Offer Match Application.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MatchAppListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="ATTRIBUTE"/>
 *     &lt;xs:enumeration value="AFFINITY"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum MatchAppListType implements Serializable {
    ATTRIBUTE("ATTRIBUTE"), AFFINITY("AFFINITY"), OTHER("Other");
    private final String value;

    private MatchAppListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static MatchAppListType convert(String value) {
        for (MatchAppListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
