
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;

/** 
 * A data type definition for Named Association Type.

 Named Association(s).

 Note: This capability supports implementer-specified, or "Named" reference associations to other (target) instantiated objects with @Key, @GroupKey and/ or @ListKey attributes.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NamedAssocType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="NamedAssoc" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class NamedAssoc -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class NamedAssocType implements Serializable
{
    private java.util.List<NamedAssoc> namedAssocList = new ArrayList<NamedAssoc>();

    /** 
     * Get the list of 'NamedAssoc' element items.
     * 
     * @return list
     */
    public java.util.List<NamedAssoc> getNamedAssocList() {
        return namedAssocList;
    }

    /** 
     * Set the list of 'NamedAssoc' element items.
     * 
     * @param list
     */
    public void setNamedAssocList(java.util.List<NamedAssoc> list) {
        namedAssocList = list;
    }
    /** 
     * Association detail, including:

    - Target object name
    - Group instance/ class key reference
    - Object instance/ class key reference
    - From object name
    - Sequence id
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NamedAssoc" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Group" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Group -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="List" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class List -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="UniqueKeyID" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class UniqueKeyID -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="required" name="Target"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="KeyRef"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="From"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="Seq"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class NamedAssoc implements Serializable
    {
        private java.util.List<Group> groupList = new ArrayList<Group>();
        private java.util.List<List> listList = new ArrayList<List>();
        private java.util.List<UniqueKeyID> uniqueKeyIDList = new ArrayList<UniqueKeyID>();
        private String target;
        private String keyRef;
        private String from;
        private BigInteger seq;

        /** 
         * Get the list of 'Group' element items.
         * 
         * @return list
         */
        public java.util.List<Group> getGroupList() {
            return groupList;
        }

        /** 
         * Set the list of 'Group' element items.
         * 
         * @param list
         */
        public void setGroupList(java.util.List<Group> list) {
            groupList = list;
        }

        /** 
         * Get the list of 'List' element items.
         * 
         * @return list
         */
        public java.util.List<List> getListList() {
            return listList;
        }

        /** 
         * Set the list of 'List' element items.
         * 
         * @param list
         */
        public void setListList(java.util.List<List> list) {
            listList = list;
        }

        /** 
         * Get the list of 'UniqueKeyID' element items.
         * 
         * @return list
         */
        public java.util.List<UniqueKeyID> getUniqueKeyIDList() {
            return uniqueKeyIDList;
        }

        /** 
         * Set the list of 'UniqueKeyID' element items.
         * 
         * @param list
         */
        public void setUniqueKeyIDList(java.util.List<UniqueKeyID> list) {
            uniqueKeyIDList = list;
        }

        /** 
         * Get the 'Target' attribute value. Target Object Source Name.

        Example: PolicyList
         * 
         * @return value
         */
        public String getTarget() {
            return target;
        }

        /** 
         * Set the 'Target' attribute value. Target Object Source Name.

        Example: PolicyList
         * 
         * @param target
         */
        public void setTarget(String target) {
            this.target = target;
        }

        /** 
         * Get the 'KeyRef' attribute value. A reference to the @Target OBJECT instance/ class Key.

        Example: 23D20750-1FFE-4EA7-A5CD-A4B9733A491B
         * 
         * @return value
         */
        public String getKeyRef() {
            return keyRef;
        }

        /** 
         * Set the 'KeyRef' attribute value. A reference to the @Target OBJECT instance/ class Key.

        Example: 23D20750-1FFE-4EA7-A5CD-A4B9733A491B
         * 
         * @param keyRef
         */
        public void setKeyRef(String keyRef) {
            this.keyRef = keyRef;
        }

        /** 
         * Get the 'From' attribute value. From Object Name. 

        Example: FlightSegmentList
         * 
         * @return value
         */
        public String getFrom() {
            return from;
        }

        /** 
         * Set the 'From' attribute value. From Object Name. 

        Example: FlightSegmentList
         * 
         * @param from
         */
        public void setFrom(String from) {
            this.from = from;
        }

        /** 
         * Get the 'Seq' attribute value. Sequence ID. Example: 1
         * 
         * @return value
         */
        public BigInteger getSeq() {
            return seq;
        }

        /** 
         * Set the 'Seq' attribute value. Sequence ID. Example: 1
         * 
         * @param seq
         */
        public void setSeq(BigInteger seq) {
            this.seq = seq;
        }
        /** 
         * Associated Target Group Key and/ or Token.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Group" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="GroupKeyRef"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="TokenRef"/>
         *     &lt;xs:attribute type="xs:integer" use="optional" name="Seq"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Group implements Serializable
        {
            private String groupKeyRef;
            private String tokenRef;
            private BigInteger seq;

            /** 
             * Get the 'GroupKeyRef' attribute value. Reference to globally unique TARGET GROUP instance/ class Key.

            Example: A3E9CF38-B140-4E03-A550-493A817A2BC9
             * 
             * @return value
             */
            public String getGroupKeyRef() {
                return groupKeyRef;
            }

            /** 
             * Set the 'GroupKeyRef' attribute value. Reference to globally unique TARGET GROUP instance/ class Key.

            Example: A3E9CF38-B140-4E03-A550-493A817A2BC9
             * 
             * @param groupKeyRef
             */
            public void setGroupKeyRef(String groupKeyRef) {
                this.groupKeyRef = groupKeyRef;
            }

            /** 
             * Get the 'TokenRef' attribute value. Reference to globally unique TARGET GROUP COLLECTION instance/ class Key.

            Example: {AEF93466-0464-46C6-89B5-487DF5007D3E}
             * 
             * @return value
             */
            public String getTokenRef() {
                return tokenRef;
            }

            /** 
             * Set the 'TokenRef' attribute value. Reference to globally unique TARGET GROUP COLLECTION instance/ class Key.

            Example: {AEF93466-0464-46C6-89B5-487DF5007D3E}
             * 
             * @param tokenRef
             */
            public void setTokenRef(String tokenRef) {
                this.tokenRef = tokenRef;
            }

            /** 
             * Get the 'Seq' attribute value. Sequence ID. Example: 1
             * 
             * @return value
             */
            public BigInteger getSeq() {
                return seq;
            }

            /** 
             * Set the 'Seq' attribute value. Sequence ID. Example: 1
             * 
             * @param seq
             */
            public void setSeq(BigInteger seq) {
                this.seq = seq;
            }
        }
        /** 
         * Associated Target List Key and/ or Token.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="List" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ListKeyRef"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="TokenRef"/>
         *     &lt;xs:attribute type="xs:integer" use="optional" name="Seq"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class List implements Serializable
        {
            private String listKeyRef;
            private String tokenRef;
            private BigInteger seq;

            /** 
             * Get the 'ListKeyRef' attribute value. Reference to globally unique TARGET LIST instance/ class Key.

            Example: {E7A28E6D-045C-4BE1-B85E-304262911773}
             * 
             * @return value
             */
            public String getListKeyRef() {
                return listKeyRef;
            }

            /** 
             * Set the 'ListKeyRef' attribute value. Reference to globally unique TARGET LIST instance/ class Key.

            Example: {E7A28E6D-045C-4BE1-B85E-304262911773}
             * 
             * @param listKeyRef
             */
            public void setListKeyRef(String listKeyRef) {
                this.listKeyRef = listKeyRef;
            }

            /** 
             * Get the 'TokenRef' attribute value. Reference to globally unique TARGET LIST COLLECTION instance/ class Key.

            Example: E20C732E-17AE-40E8-B3DB-FCC04585DD4C
             * 
             * @return value
             */
            public String getTokenRef() {
                return tokenRef;
            }

            /** 
             * Set the 'TokenRef' attribute value. Reference to globally unique TARGET LIST COLLECTION instance/ class Key.

            Example: E20C732E-17AE-40E8-B3DB-FCC04585DD4C
             * 
             * @param tokenRef
             */
            public void setTokenRef(String tokenRef) {
                this.tokenRef = tokenRef;
            }

            /** 
             * Get the 'Seq' attribute value. Sequence ID. Example: 1
             * 
             * @return value
             */
            public BigInteger getSeq() {
                return seq;
            }

            /** 
             * Set the 'Seq' attribute value. Sequence ID. Example: 1
             * 
             * @param seq
             */
            public void setSeq(BigInteger seq) {
                this.seq = seq;
            }
        }
        /** 
         * Object Unique Key ID.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UniqueKeyID" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="UniqueID_Ref"/>
         *     &lt;xs:attribute type="xs:integer" use="optional" name="Seq"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class UniqueKeyID implements Serializable
        {
            private String uniqueIDRef;
            private BigInteger seq;

            /** 
             * Get the 'UniqueID_Ref' attribute value. A reference to a Unique (string-based) Object ID. Example: OBJ001
             * 
             * @return value
             */
            public String getUniqueIDRef() {
                return uniqueIDRef;
            }

            /** 
             * Set the 'UniqueID_Ref' attribute value. A reference to a Unique (string-based) Object ID. Example: OBJ001
             * 
             * @param uniqueIDRef
             */
            public void setUniqueIDRef(String uniqueIDRef) {
                this.uniqueIDRef = uniqueIDRef;
            }

            /** 
             * Get the 'Seq' attribute value. Sequence ID. Example: 1
             * 
             * @return value
             */
            public BigInteger getSeq() {
                return seq;
            }

            /** 
             * Set the 'Seq' attribute value. Sequence ID. Example: 1
             * 
             * @param seq
             */
            public void setSeq(BigInteger seq) {
                this.seq = seq;
            }
        }
    }
}
