
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * OFFER ITEM TIME LIMIT SET (collection) definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItemTimeLimitSetType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="TimeLimit" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class TimeLimit -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferItemTimeLimitSetType implements Serializable
{
    private List<TimeLimit> timeLimitList = new ArrayList<TimeLimit>();

    /** 
     * Get the list of 'TimeLimit' element items.
     * 
     * @return list
     */
    public List<TimeLimit> getTimeLimitList() {
        return timeLimitList;
    }

    /** 
     * Set the list of 'TimeLimit' element items.
     * 
     * @param list
     */
    public void setTimeLimitList(List<TimeLimit> list) {
        timeLimitList = list;
    }
    /** 
     * Offer Item Time Limit detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TimeLimit" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="PriceGuaranteeTimeLimit"/>
     *       &lt;xs:element ref="TicketByTimeLimit"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class TimeLimit implements Serializable
    {
        private PriceGuarTimeLimitType priceGuaranteeTimeLimit;
        private TicketByTimeLimitType ticketByTimeLimit;
        private String refs;

        /** 
         * Get the 'PriceGuaranteeTimeLimit' element value.
         * 
         * @return value
         */
        public PriceGuarTimeLimitType getPriceGuaranteeTimeLimit() {
            return priceGuaranteeTimeLimit;
        }

        /** 
         * Set the 'PriceGuaranteeTimeLimit' element value.
         * 
         * @param priceGuaranteeTimeLimit
         */
        public void setPriceGuaranteeTimeLimit(
                PriceGuarTimeLimitType priceGuaranteeTimeLimit) {
            this.priceGuaranteeTimeLimit = priceGuaranteeTimeLimit;
        }

        /** 
         * Get the 'TicketByTimeLimit' element value.
         * 
         * @return value
         */
        public TicketByTimeLimitType getTicketByTimeLimit() {
            return ticketByTimeLimit;
        }

        /** 
         * Set the 'TicketByTimeLimit' element value.
         * 
         * @param ticketByTimeLimit
         */
        public void setTicketByTimeLimit(TicketByTimeLimitType ticketByTimeLimit) {
            this.ticketByTimeLimit = ticketByTimeLimit;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
