
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="TotalPriceDetail">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element name="TotalAmount">
 *             &lt;xs:complexType>
 *               &lt;xs:choice>
 *                 &lt;xs:element ref="AwardPricing"/>
 *                 &lt;xs:element ref="CombinationPricing"/>
 *                 &lt;xs:element ref="DetailCurrencyPrice"/>
 *                 &lt;xs:element ref="EncodedCurrencyPrice"/>
 *                 &lt;xs:element ref="SimpleCurrencyPrice"/>
 *               &lt;/xs:choice>
 *             &lt;/xs:complexType>
 *           &lt;/xs:element>
 *           &lt;xs:element type="CurrencyAmountOptType" name="BaseAmount" minOccurs="0"/>
 *           &lt;xs:element ref="FareFiledIn" minOccurs="0"/>
 *           &lt;xs:element type="DiscountType" name="Discount" minOccurs="0"/>
 *           &lt;xs:element name="Surcharges" minOccurs="0">
 *             &lt;!-- Reference to inner class Surcharges -->
 *           &lt;/xs:element>
 *           &lt;xs:element type="TaxDetailType" name="Taxes" minOccurs="0"/>
 *           &lt;xs:element ref="TaxExemption" minOccurs="0"/>
 *           &lt;xs:choice minOccurs="0">
 *             &lt;!-- Reference to inner class Choice -->
 *           &lt;/xs:choice>
 *           &lt;xs:element type="FeeSurchargeType" name="Fees" minOccurs="0"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="Service" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Service -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="FareDetailType" name="FareDetail" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="OfferItemID"/>
 *   &lt;xs:attribute type="xs:boolean" name="MandatoryInd"/>
 *   &lt;xs:attribute type="xs:boolean" name="ModificationProhibitedInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferItemType implements Serializable
{
    private int totalPriceDetailTotalAmountSelect = -1;
    private static final int TOTAL_PRICE_DETAIL_AWARD_PRICING_CHOICE = 0;
    private static final int TOTAL_PRICE_DETAIL_COMBINATION_PRICING_CHOICE = 1;
    private static final int TOTAL_PRICE_DETAIL_DETAIL_CURRENCY_PRICE_CHOICE = 2;
    private static final int TOTAL_PRICE_DETAIL_ENCODED_CURRENCY_PRICE_CHOICE = 3;
    private static final int TOTAL_PRICE_DETAIL_SIMPLE_CURRENCY_PRICE_CHOICE = 4;
    private AwardPriceUnitType totalPriceDetailAwardPricing;
    private CombinationPriceType totalPriceDetailCombinationPricing;
    private DetailCurrencyPriceType totalPriceDetailDetailCurrencyPrice;
    private EncodedCurrencyPrice totalPriceDetailEncodedCurrencyPrice;
    private SimpleCurrencyPrice totalPriceDetailSimpleCurrencyPrice;
    private CurrencyAmountOptType totalPriceDetailBaseAmount;
    private FareFilingType totalPriceDetailFareFiledIn;
    private DiscountType totalPriceDetailDiscount;
    private Surcharges surcharges;
    private TaxDetailType totalPriceDetailTaxes;
    private TaxExemptionType totalPriceDetailTaxExemption;
    private Choice choice;
    private FeeSurchargeType totalPriceDetailFees;
    private List<Service> serviceList = new ArrayList<Service>();
    private List<FareDetailType> fareDetailList = new ArrayList<FareDetailType>();
    private String offerItemID;
    private Boolean mandatoryInd;
    private Boolean modificationProhibitedInd;

    private void setTotalPriceDetailTotalAmountSelect(int choice) {
        if (totalPriceDetailTotalAmountSelect == -1) {
            totalPriceDetailTotalAmountSelect = choice;
        } else if (totalPriceDetailTotalAmountSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearTotalPriceDetailTotalAmountSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearTotalPriceDetailTotalAmountSelect() {
        totalPriceDetailTotalAmountSelect = -1;
    }

    /** 
     * Check if TotalPriceDetailAwardPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTotalPriceDetailAwardPricing() {
        return totalPriceDetailTotalAmountSelect == TOTAL_PRICE_DETAIL_AWARD_PRICING_CHOICE;
    }

    /** 
     * Get the 'AwardPricing' element value.
     * 
     * @return value
     */
    public AwardPriceUnitType getTotalPriceDetailAwardPricing() {
        return totalPriceDetailAwardPricing;
    }

    /** 
     * Set the 'AwardPricing' element value.
     * 
     * @param totalPriceDetailAwardPricing
     */
    public void setTotalPriceDetailAwardPricing(
            AwardPriceUnitType totalPriceDetailAwardPricing) {
        setTotalPriceDetailTotalAmountSelect(TOTAL_PRICE_DETAIL_AWARD_PRICING_CHOICE);
        this.totalPriceDetailAwardPricing = totalPriceDetailAwardPricing;
    }

    /** 
     * Check if TotalPriceDetailCombinationPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTotalPriceDetailCombinationPricing() {
        return totalPriceDetailTotalAmountSelect == TOTAL_PRICE_DETAIL_COMBINATION_PRICING_CHOICE;
    }

    /** 
     * Get the 'CombinationPricing' element value.
     * 
     * @return value
     */
    public CombinationPriceType getTotalPriceDetailCombinationPricing() {
        return totalPriceDetailCombinationPricing;
    }

    /** 
     * Set the 'CombinationPricing' element value.
     * 
     * @param totalPriceDetailCombinationPricing
     */
    public void setTotalPriceDetailCombinationPricing(
            CombinationPriceType totalPriceDetailCombinationPricing) {
        setTotalPriceDetailTotalAmountSelect(TOTAL_PRICE_DETAIL_COMBINATION_PRICING_CHOICE);
        this.totalPriceDetailCombinationPricing = totalPriceDetailCombinationPricing;
    }

    /** 
     * Check if TotalPriceDetailDetailCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTotalPriceDetailDetailCurrencyPrice() {
        return totalPriceDetailTotalAmountSelect == TOTAL_PRICE_DETAIL_DETAIL_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'DetailCurrencyPrice' element value.
     * 
     * @return value
     */
    public DetailCurrencyPriceType getTotalPriceDetailDetailCurrencyPrice() {
        return totalPriceDetailDetailCurrencyPrice;
    }

    /** 
     * Set the 'DetailCurrencyPrice' element value.
     * 
     * @param totalPriceDetailDetailCurrencyPrice
     */
    public void setTotalPriceDetailDetailCurrencyPrice(
            DetailCurrencyPriceType totalPriceDetailDetailCurrencyPrice) {
        setTotalPriceDetailTotalAmountSelect(TOTAL_PRICE_DETAIL_DETAIL_CURRENCY_PRICE_CHOICE);
        this.totalPriceDetailDetailCurrencyPrice = totalPriceDetailDetailCurrencyPrice;
    }

    /** 
     * Check if TotalPriceDetailEncodedCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTotalPriceDetailEncodedCurrencyPrice() {
        return totalPriceDetailTotalAmountSelect == TOTAL_PRICE_DETAIL_ENCODED_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'EncodedCurrencyPrice' element value.
     * 
     * @return value
     */
    public EncodedCurrencyPrice getTotalPriceDetailEncodedCurrencyPrice() {
        return totalPriceDetailEncodedCurrencyPrice;
    }

    /** 
     * Set the 'EncodedCurrencyPrice' element value.
     * 
     * @param totalPriceDetailEncodedCurrencyPrice
     */
    public void setTotalPriceDetailEncodedCurrencyPrice(
            EncodedCurrencyPrice totalPriceDetailEncodedCurrencyPrice) {
        setTotalPriceDetailTotalAmountSelect(TOTAL_PRICE_DETAIL_ENCODED_CURRENCY_PRICE_CHOICE);
        this.totalPriceDetailEncodedCurrencyPrice = totalPriceDetailEncodedCurrencyPrice;
    }

    /** 
     * Check if TotalPriceDetailSimpleCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTotalPriceDetailSimpleCurrencyPrice() {
        return totalPriceDetailTotalAmountSelect == TOTAL_PRICE_DETAIL_SIMPLE_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'SimpleCurrencyPrice' element value.
     * 
     * @return value
     */
    public SimpleCurrencyPrice getTotalPriceDetailSimpleCurrencyPrice() {
        return totalPriceDetailSimpleCurrencyPrice;
    }

    /** 
     * Set the 'SimpleCurrencyPrice' element value.
     * 
     * @param totalPriceDetailSimpleCurrencyPrice
     */
    public void setTotalPriceDetailSimpleCurrencyPrice(
            SimpleCurrencyPrice totalPriceDetailSimpleCurrencyPrice) {
        setTotalPriceDetailTotalAmountSelect(TOTAL_PRICE_DETAIL_SIMPLE_CURRENCY_PRICE_CHOICE);
        this.totalPriceDetailSimpleCurrencyPrice = totalPriceDetailSimpleCurrencyPrice;
    }

    /** 
     * Get the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

    Note: This includes  surcharges (if applicable).
     * 
     * @return value
     */
    public CurrencyAmountOptType getTotalPriceDetailBaseAmount() {
        return totalPriceDetailBaseAmount;
    }

    /** 
     * Set the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

    Note: This includes  surcharges (if applicable).
     * 
     * @param totalPriceDetailBaseAmount
     */
    public void setTotalPriceDetailBaseAmount(
            CurrencyAmountOptType totalPriceDetailBaseAmount) {
        this.totalPriceDetailBaseAmount = totalPriceDetailBaseAmount;
    }

    /** 
     * Get the 'FareFiledIn' element value.
     * 
     * @return value
     */
    public FareFilingType getTotalPriceDetailFareFiledIn() {
        return totalPriceDetailFareFiledIn;
    }

    /** 
     * Set the 'FareFiledIn' element value.
     * 
     * @param totalPriceDetailFareFiledIn
     */
    public void setTotalPriceDetailFareFiledIn(
            FareFilingType totalPriceDetailFareFiledIn) {
        this.totalPriceDetailFareFiledIn = totalPriceDetailFareFiledIn;
    }

    /** 
     * Get the 'Discount' element value. Discount Information
     * 
     * @return value
     */
    public DiscountType getTotalPriceDetailDiscount() {
        return totalPriceDetailDiscount;
    }

    /** 
     * Set the 'Discount' element value. Discount Information
     * 
     * @param totalPriceDetailDiscount
     */
    public void setTotalPriceDetailDiscount(
            DiscountType totalPriceDetailDiscount) {
        this.totalPriceDetailDiscount = totalPriceDetailDiscount;
    }

    /** 
     * Get the 'Surcharges' element value. Total price reflecting all services for all passengers across all segments referenced within this Offer Item.
     * 
     * @return value
     */
    public Surcharges getSurcharges() {
        return surcharges;
    }

    /** 
     * Set the 'Surcharges' element value. Total price reflecting all services for all passengers across all segments referenced within this Offer Item.
     * 
     * @param surcharges
     */
    public void setSurcharges(Surcharges surcharges) {
        this.surcharges = surcharges;
    }

    /** 
     * Get the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
     * 
     * @return value
     */
    public TaxDetailType getTotalPriceDetailTaxes() {
        return totalPriceDetailTaxes;
    }

    /** 
     * Set the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
     * 
     * @param totalPriceDetailTaxes
     */
    public void setTotalPriceDetailTaxes(TaxDetailType totalPriceDetailTaxes) {
        this.totalPriceDetailTaxes = totalPriceDetailTaxes;
    }

    /** 
     * Get the 'TaxExemption' element value.
     * 
     * @return value
     */
    public TaxExemptionType getTotalPriceDetailTaxExemption() {
        return totalPriceDetailTaxExemption;
    }

    /** 
     * Set the 'TaxExemption' element value.
     * 
     * @param totalPriceDetailTaxExemption
     */
    public void setTotalPriceDetailTaxExemption(
            TaxExemptionType totalPriceDetailTaxExemption) {
        this.totalPriceDetailTaxExemption = totalPriceDetailTaxExemption;
    }

    /** 
     * Get the choice value. Total price reflecting all services for all passengers across all segments referenced within this Offer Item.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value. Total price reflecting all services for all passengers across all segments referenced within this Offer Item.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
     * 
     * @return value
     */
    public FeeSurchargeType getTotalPriceDetailFees() {
        return totalPriceDetailFees;
    }

    /** 
     * Set the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
     * 
     * @param totalPriceDetailFees
     */
    public void setTotalPriceDetailFees(FeeSurchargeType totalPriceDetailFees) {
        this.totalPriceDetailFees = totalPriceDetailFees;
    }

    /** 
     * Get the list of 'Service' element items.
     * 
     * @return list
     */
    public List<Service> getServiceList() {
        return serviceList;
    }

    /** 
     * Set the list of 'Service' element items.
     * 
     * @param list
     */
    public void setServiceList(List<Service> list) {
        serviceList = list;
    }

    /** 
     * Get the list of 'FareDetail' element items. Fare Detail, including Fare Component and Fare Rules.
     * 
     * @return list
     */
    public List<FareDetailType> getFareDetailList() {
        return fareDetailList;
    }

    /** 
     * Set the list of 'FareDetail' element items. Fare Detail, including Fare Component and Fare Rules.
     * 
     * @param list
     */
    public void setFareDetailList(List<FareDetailType> list) {
        fareDetailList = list;
    }

    /** 
     * Get the 'OfferItemID' attribute value. Unique identifier for this OfferItem instance. Must be unique within XML message. Exceeding 64 characters or use of dashes is not recommended.
     * 
     * @return value
     */
    public String getOfferItemID() {
        return offerItemID;
    }

    /** 
     * Set the 'OfferItemID' attribute value. Unique identifier for this OfferItem instance. Must be unique within XML message. Exceeding 64 characters or use of dashes is not recommended.
     * 
     * @param offerItemID
     */
    public void setOfferItemID(String offerItemID) {
        this.offerItemID = offerItemID;
    }

    /** 
     * Get the 'MandatoryInd' attribute value. If set to 'true', indicates mandatory Offer Items which cannot be removed from the Offer. Mandatory Offer Items transition into Order Items. If not present or 'false', the Offer item is optional. The aggregate price at the Offer level initially reflects the sum of the prices for all Mandatory Offer Items within it.
     * 
     * @return value
     */
    public Boolean getMandatoryInd() {
        return mandatoryInd;
    }

    /** 
     * Set the 'MandatoryInd' attribute value. If set to 'true', indicates mandatory Offer Items which cannot be removed from the Offer. Mandatory Offer Items transition into Order Items. If not present or 'false', the Offer item is optional. The aggregate price at the Offer level initially reflects the sum of the prices for all Mandatory Offer Items within it.
     * 
     * @param mandatoryInd
     */
    public void setMandatoryInd(Boolean mandatoryInd) {
        this.mandatoryInd = mandatoryInd;
    }

    /** 
     * Get the 'ModificationProhibitedInd' attribute value. POA to ORA only: to indicate that the offer is non-modifiable. This indicates to ORA that its offer is non-modifiable (eg. Regulatory or brand protection reasons). If indicator is set to true, nodifications to the POA’s offer ARE NOT allowed.
     * 
     * @return value
     */
    public Boolean getModificationProhibitedInd() {
        return modificationProhibitedInd;
    }

    /** 
     * Set the 'ModificationProhibitedInd' attribute value. POA to ORA only: to indicate that the offer is non-modifiable. This indicates to ORA that its offer is non-modifiable (eg. Regulatory or brand protection reasons). If indicator is set to true, nodifications to the POA’s offer ARE NOT allowed.
     * 
     * @param modificationProhibitedInd
     */
    public void setModificationProhibitedInd(Boolean modificationProhibitedInd) {
        this.modificationProhibitedInd = modificationProhibitedInd;
    }
    /** 
     * Applicable Surcharge(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharges" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="FeeSurchargeType" name="Surcharge" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Surcharges implements Serializable
    {
        private List<FeeSurchargeType> surchargeList = new ArrayList<FeeSurchargeType>();

        /** 
         * Get the list of 'Surcharge' element items. Surcharge detail.
         * 
         * @return list
         */
        public List<FeeSurchargeType> getSurchargeList() {
            return surchargeList;
        }

        /** 
         * Set the list of 'Surcharge' element items. Surcharge detail.
         * 
         * @param list
         */
        public void setSurchargeList(List<FeeSurchargeType> list) {
            surchargeList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="AwardPriceUnitType" name="AwardPricing" minOccurs="0"/>
     *   &lt;xs:element type="CombinationPriceType" name="CombinationPricing" minOccurs="0"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int AWARD_PRICING_CHOICE = 0;
        private static final int COMBINATION_PRICING_CHOICE = 1;
        private AwardPriceUnitType awardPricing;
        private CombinationPriceType combinationPricing;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if AwardPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAwardPricing() {
            return choiceSelect == AWARD_PRICING_CHOICE;
        }

        /** 
         * Get the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
         * 
         * @return value
         */
        public AwardPriceUnitType getAwardPricing() {
            return awardPricing;
        }

        /** 
         * Set the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
         * 
         * @param awardPricing
         */
        public void setAwardPricing(AwardPriceUnitType awardPricing) {
            setChoiceSelect(AWARD_PRICING_CHOICE);
            this.awardPricing = awardPricing;
        }

        /** 
         * Check if CombinationPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCombinationPricing() {
            return choiceSelect == COMBINATION_PRICING_CHOICE;
        }

        /** 
         * Get the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
         * 
         * @return value
         */
        public CombinationPriceType getCombinationPricing() {
            return combinationPricing;
        }

        /** 
         * Set the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
         * 
         * @param combinationPricing
         */
        public void setCombinationPricing(
                CombinationPriceType combinationPricing) {
            setChoiceSelect(COMBINATION_PRICING_CHOICE);
            this.combinationPricing = combinationPricing;
        }
    }
    /** 
     * The individual instance of a specific flight, service or service bundle (as found in DataLists) as it has been offered, and eventually ordered and consumed by, a specific Passenger in the context of an Offer.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Service" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="PassengerRefs"/>
     *       &lt;xs:element type="xs:string" name="ServiceRef" minOccurs="0"/>
     *       &lt;xs:choice>
     *         &lt;xs:element type="xs:string" name="FlightRefs"/>
     *         &lt;xs:element name="ServiceDefinitionRef">
     *           &lt;xs:complexType>
     *             &lt;xs:simpleContent>
     *               &lt;xs:extension base="xs:string">
     *                 &lt;xs:attribute type="xs:string" name="SegmentRefs"/>
     *               &lt;/xs:extension>
     *             &lt;/xs:simpleContent>
     *           &lt;/xs:complexType>
     *         &lt;/xs:element>
     *         &lt;xs:element name="SelectedSeat">
     *           &lt;xs:complexType>
     *             &lt;xs:sequence>
     *               &lt;xs:element name="Seat">
     *                 &lt;xs:complexType>
     *                   &lt;xs:sequence>
     *                     &lt;xs:element type="xs:integer" name="Row"/>
     *                     &lt;xs:element type="xs:string" name="Column"/>
     *                   &lt;/xs:sequence>
     *                 &lt;/xs:complexType>
     *               &lt;/xs:element>
     *               &lt;xs:element name="SegmentRef"/>
     *               &lt;xs:element name="ServiceDefinitionRef"/>
     *             &lt;/xs:sequence>
     *           &lt;/xs:complexType>
     *         &lt;/xs:element>
     *       &lt;/xs:choice>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="required" name="ServiceID"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Service implements Serializable
    {
        private String passengerRefs;
        private String serviceRef;
        private int choiceSelect = -1;
        private static final int FLIGHT_REFS_CHOICE = 0;
        private static final int SERVICE_DEFINITION_REF_CHOICE = 1;
        private static final int SELECTED_SEAT_CHOICE = 2;
        private String flightRefs;
        private String serviceDefinitionRefString;
        private String serviceDefinitionRefSegmentRefs;
        private BigInteger selectedSeatRow;
        private String selectedSeatColumn;
        private String serviceID;

        /** 
         * Get the 'PassengerRefs' element value. Reference to the PassengerID of one or more Passengers in DataLists. The Passenger is the recipient entitled to receive/consume the Service(s) offered by the Airline, whether the Service(s) are flight-related or not.
         * 
         * @return value
         */
        public String getPassengerRefs() {
            return passengerRefs;
        }

        /** 
         * Set the 'PassengerRefs' element value. Reference to the PassengerID of one or more Passengers in DataLists. The Passenger is the recipient entitled to receive/consume the Service(s) offered by the Airline, whether the Service(s) are flight-related or not.
         * 
         * @param passengerRefs
         */
        public void setPassengerRefs(String passengerRefs) {
            this.passengerRefs = passengerRefs;
        }

        /** 
         * Get the 'ServiceRef' element value. Create dependencies with parent services to which this particular Service is linked. Can reference Services across different OfferItems within the same Offer.
         * 
         * @return value
         */
        public String getServiceRef() {
            return serviceRef;
        }

        /** 
         * Set the 'ServiceRef' element value. Create dependencies with parent services to which this particular Service is linked. Can reference Services across different OfferItems within the same Offer.
         * 
         * @param serviceRef
         */
        public void setServiceRef(String serviceRef) {
            this.serviceRef = serviceRef;
        }

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if FlightRefs is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifFlightRefs() {
            return choiceSelect == FLIGHT_REFS_CHOICE;
        }

        /** 
         * Get the 'FlightRefs' element value. Reference to one or more flights in the Datalists that are being sold as part of this OfferItem/Service.
         * 
         * @return value
         */
        public String getFlightRefs() {
            return flightRefs;
        }

        /** 
         * Set the 'FlightRefs' element value. Reference to one or more flights in the Datalists that are being sold as part of this OfferItem/Service.
         * 
         * @param flightRefs
         */
        public void setFlightRefs(String flightRefs) {
            setChoiceSelect(FLIGHT_REFS_CHOICE);
            this.flightRefs = flightRefs;
        }

        /** 
         * Check if ServiceDefinitionRef is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifServiceDefinitionRef() {
            return choiceSelect == SERVICE_DEFINITION_REF_CHOICE;
        }

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getServiceDefinitionRefString() {
            return serviceDefinitionRefString;
        }

        /** 
         * Set the extension value.
         * 
         * @param serviceDefinitionRefString
         */
        public void setServiceDefinitionRefString(
                String serviceDefinitionRefString) {
            setChoiceSelect(SERVICE_DEFINITION_REF_CHOICE);
            this.serviceDefinitionRefString = serviceDefinitionRefString;
        }

        /** 
         * Get the 'SegmentRefs' attribute value. Reference to one or more segments in the Datalists to restrict the eligibility of the associated ServiceDefinition. 
         * 
         * @return value
         */
        public String getServiceDefinitionRefSegmentRefs() {
            return serviceDefinitionRefSegmentRefs;
        }

        /** 
         * Set the 'SegmentRefs' attribute value. Reference to one or more segments in the Datalists to restrict the eligibility of the associated ServiceDefinition. 
         * 
         * @param serviceDefinitionRefSegmentRefs
         */
        public void setServiceDefinitionRefSegmentRefs(
                String serviceDefinitionRefSegmentRefs) {
            setChoiceSelect(SERVICE_DEFINITION_REF_CHOICE);
            this.serviceDefinitionRefSegmentRefs = serviceDefinitionRefSegmentRefs;
        }

        /** 
         * Check if SelectedSeat is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSelectedSeat() {
            return choiceSelect == SELECTED_SEAT_CHOICE;
        }

        /** 
         * Get the 'Row' element value. Seat row number. Example: 2
         * 
         * @return value
         */
        public BigInteger getSelectedSeatRow() {
            return selectedSeatRow;
        }

        /** 
         * Set the 'Row' element value. Seat row number. Example: 2
         * 
         * @param selectedSeatRow
         */
        public void setSelectedSeatRow(BigInteger selectedSeatRow) {
            setChoiceSelect(SELECTED_SEAT_CHOICE);
            this.selectedSeatRow = selectedSeatRow;
        }

        /** 
         * Get the 'Column' element value. Seat column to identify a particular seat position on an aircraft
         * 
         * @return value
         */
        public String getSelectedSeatColumn() {
            return selectedSeatColumn;
        }

        /** 
         * Set the 'Column' element value. Seat column to identify a particular seat position on an aircraft
         * 
         * @param selectedSeatColumn
         */
        public void setSelectedSeatColumn(String selectedSeatColumn) {
            setChoiceSelect(SELECTED_SEAT_CHOICE);
            this.selectedSeatColumn = selectedSeatColumn;
        }

        /** 
         * Get the 'ServiceID' attribute value. ID for the Service unique across the entire XML document.
         * 
         * @return value
         */
        public String getServiceID() {
            return serviceID;
        }

        /** 
         * Set the 'ServiceID' attribute value. ID for the Service unique across the entire XML document.
         * 
         * @param serviceID
         */
        public void setServiceID(String serviceID) {
            this.serviceID = serviceID;
        }
    }
}
